<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.1.0.0-PRO - 2024-07-28
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\{HTML\HTMLHelper, Language\Text, Router\Route};
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Helper\EasyJoomlaBackupHelper;

HTMLHelper::_('behavior.core');
HTMLHelper::_('jquery.framework');
?>
<script type="text/javascript">
    Joomla.submitbutton = function(task) {
        if (task === 'cancel' || document.formvalidator.isValid(document.getElementById('easyjoomlabackup-form'))) {
            Joomla.submitform(task, document.getElementById('easyjoomlabackup-form'));
        } else {
            alert('<?php echo $this->escape(Text::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
        }
    };
</script>
<form action="<?php echo Route::_('index.php?option=com_easyjoomlabackup'); ?>" method="post" name="adminForm" id="easyjoomlabackup-form" class="form-validate">
    <div class="row">
        <div class="col-lg-6 mx-auto form-horizontal">
            <fieldset class="adminform">
                <div id="backup_comment" class="create-container">
                    <label for="comment" class="form-label">
                        <strong><?php echo Text::_('COM_EASYJOOMLABACKUP_COMMENT'); ?></strong>
                    </label>
                    <textarea class="form-control" rows="3" maxlength="" id="comment" name="comment" placeholder="<?php echo Text::_('COM_EASYJOOMLABACKUP_COMMENT_PLACEHOLDER'); ?>"></textarea>
                </div>
                <?php if ($this->encryptBackupArchive) : ?>
                    <div id="backup_password" class="create-container">
                        <label for="password">
                            <strong><?php echo Text::_('COM_EASYJOOMLABACKUP_ARCHIVEPASSWORD'); ?></strong>
                        </label>
                        <?php if ($this->encryptBackupArchiveAllowed) : ?>
                            <div class="row">
                                <div class="col">
                                    <input type="password" id="password" class="form-control" name="password" pattern="[^ ]+" placeholder="<?php echo Text::_('COM_EASYJOOMLABACKUP_ARCHIVEPASSWORD_PLACEHOLDER'); ?>"/>
                                </div>
                                <div class="col">
                                    <input type="password" id="password2" class="form-control" name="password2" pattern="[^ ]+" placeholder="<?php echo Text::_('COM_EASYJOOMLABACKUP_ARCHIVEPASSWORD_PLACEHOLDER_REPEAT'); ?>"/>
                                </div>
                            </div>
                        <?php else : ?>
                            <div class="text-error">
                                <?php echo Text::_('COM_EASYJOOMLABACKUP_ARCHIVEPASSWORD_REQUIREMENTS_NOT_MET'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div id="backup_notice" class="create-container">
                    <div class="accordion" id="accordionExample">
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    <?php echo Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUPNOTES_TITLE'); ?>
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <?php echo Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUPNOTES_BODY'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>
        </div>
    </div>
    <?php $body = $this->loadTemplate('modal'); ?>
    <?php echo HTMLHelper::_('bootstrap.renderModal', 'create-backup-modal', ['title' => Text::_('COM_EASYJOOMLABACKUP_BACKUPMODAL_TITLE'), 'backdrop' => 'static', 'closeButton' => false, 'keyboard' => false, 'modalWidth' => 90, 'footer' => Text::_('COM_EASYJOOMLABACKUP_BACKUPMODAL_FOOTER')], $body); ?>
    <input type="hidden" name="option" value="com_easyjoomlabackup"/>
    <input type="hidden" name="id" value=""/>
    <input type="hidden" name="task" value=""/>
    <input type="hidden" name="controller" value="Create"/>
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
<?php echo EasyJoomlaBackupHelper::getFooter(); ?>
