<?php
namespace JExtstore\Component\Gdpr\Administrator\Model;
/**
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage models
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Html as GdprHelpersHtml;
use JExtstore\Component\Gdpr\Administrator\Framework\Model as GdprModel;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception as GdprException;

/**
 * Cookie descriptions model concrete implementation <<testable_behavior>>
 *
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage models
 * @since 1.4
 */
class CookiedescriptionsModel extends GdprModel {
	/**
	 * Build list entities query
	 * 
	 * @access protected
	 * @return string
	 */
	protected function buildListQuery() {
		// WHERE
		$where = array ();
		$whereString = null;
		$orderString = null;

		// STATE FILTER
		if ($filter_state = $this->state->get ( 'state' )) {
			if ($filter_state == 'P') {
				$where [] = 's.published = 1';
			} else if ($filter_state == 'U') {
				$where [] = 's.published = 0';
			}
		}
		
		if($this->state->get('category', '') !== '') {
			$category = (int)$this->state->get('category');
			$where[] = "\n (s.category =" . (int)$category . ")";
		}
		
		// Filtro testo
		if($this->state->get('searchword')) {
			$where[] = "\n s.cookie LIKE " .
					$this->dbInstance->quote('%' . $this->state->get('searchword') . '%');
		}
		
		if (count ( $where )) {
			$whereString = "\n WHERE " . implode ( "\n AND ", $where );
		}
		
		// ORDERBY
		if ($this->state->get ( 'order' )) {
			$orderString = "\n ORDER BY " . $this->state->get ( 'order' ) . " ";
		}
		
		// ORDERDIR
		if ($this->state->get ( 'order_dir' )) {
			$orderString .= $this->state->get ( 'order_dir' );
		}
		
		$query = "SELECT s.*" .
				 "\n FROM #__gdpr_cookie_descriptions AS s" .
				 $whereString . 
				 $orderString;
		return $query;
	}

	/**
	 * Main get data methods
	 * 
	 * @access public
	 * @return array
	 */
	public function getData(): array {
		// Build query
		$query = $this->buildListQuery ();
		try {
			$dbQuery = method_exists ( $this->dbInstance, 'createQuery' ) ? $this->dbInstance->createQuery () : $this->dbInstance->getQuery ( true );
			$dbQuery->setQuery ( $query )->setLimit ( $this->getState ( 'limit' ), $this->getState ( 'limitstart' ) );
			$this->dbInstance->setQuery ( $dbQuery );
			$result = $this->dbInstance->loadObjectList ();
		} catch (GdprException $e) {
			$this->app->enqueueMessage($e->getMessage(), $e->getExceptionLevel());
			$result = array();
		} catch (\Exception $e) {
			$gdprException = new GdprException($e->getMessage(), 'error');
			$this->app->enqueueMessage($gdprException->getMessage(), $gdprException->getExceptionLevel());
			$result = array();
		}
		return $result;
	}
	
	/**
	 * Storing entity by ORM table
	 *
	 * @access public
	 * @param bool $updateNulls
	 * @return mixed
	 */
	public function storeEntity($updateNulls = true) {
		return parent::storeEntity($updateNulls);
	}
	
	/**
	 * Return select lists used as filter for listEntities
	 *
	 * @access public
	 * @return array
	 */
	public function getFilters(): array {
		$filters = array();
		
		$filters ['state'] = GdprHelpersHtml::state ( $this->getState ( 'state' ) );
		
		// Add categories list
		$arrayCategories = array (''=>Text::_('COM_GDPR_SELECT_CAT'),
								  '1'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT1'),
								  '2'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT2'),
								  '3'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT3'),
								  '4'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT4'));
		foreach ($arrayCategories as $value=>$text) {
			$options[] = HTMLHelper::_('select.option', $value, $text);
		}
		$filters ['categories'] = HTMLHelper::_( 'select.genericlist', $options, 'category', 'class="inputbox hidden-phone" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $this->getState ( 'category' ));
		
		return $filters;
	}
	
	/**
	 * Return select lists used as filter for editEntity
	 *
	 * @access public
	 * @param Object $record
	 * @return array
	 */
	public function getLists($record = null): array {
		$lists = parent::getLists($record);

		// Add categories list
		$arrayCategories = array (''=>Text::_('COM_GDPR_COOKIE_DESCRIPTIONS_CATEGORY_CHOOSE'),
								  '1'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT1'),
								  '2'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT2'),
								  '3'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT3'),
								  '4'=>Text::_('COM_GDPR_CONFIGURATION_COOKIECATEGORIES_CAT4'));
		foreach ($arrayCategories as $value=>$text) {
			$options[] = HTMLHelper::_('select.option', $value, $text);
		}
		$lists ['categories'] = HTMLHelper::_( 'select.genericlist', $options, 'category', 'data-validation="required" class="form-select"', 'value', 'text', $record->category);
		
		return $lists;
	}
}