-- Basic release schema 1.0 
CREATE TABLE IF NOT EXISTS `#__gdpr_logs` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
	 `user_id` int unsigned NOT NULL default '0',
	 `name` varchar(255) NOT NULL DEFAULT '',
  	 `username` varchar(150) NOT NULL DEFAULT '',
  	 `email` varchar(100) NOT NULL DEFAULT '',
	 `change_name` tinyint NOT NULL DEFAULT 0,
	 `change_username` tinyint NOT NULL DEFAULT 0,
	 `change_password` tinyint NOT NULL DEFAULT 0,
	 `change_email` tinyint NOT NULL DEFAULT 0,
	 `change_params` tinyint NOT NULL DEFAULT 0,
	 `change_requirereset` tinyint NOT NULL DEFAULT 0,
	 `change_block` tinyint NOT NULL DEFAULT 0,
	 `change_sendemail` tinyint NOT NULL DEFAULT 0,
	 `change_usergroups` tinyint NOT NULL DEFAULT 0,
	 `change_activation` tinyint NOT NULL DEFAULT 0,
	 `created_user` tinyint NOT NULL DEFAULT 0,
	 `deleted_user` tinyint NOT NULL DEFAULT 0,
	 `privacy_policy` tinyint NOT NULL DEFAULT 1,
	 `editor_user_id` int unsigned NOT NULL default '0',
	 `editor_name` varchar(255) NOT NULL DEFAULT '',
  	 `editor_username` varchar(150) NOT NULL DEFAULT '',
  	 `change_date` datetime NULL,
  	 `changes_structure` TEXT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_username` (`username`),
  KEY `idx_email` (`email`),
  KEY `idx_editor_name` (`editor_name`),
  KEY `idx_editor_username` (`editor_username`),
  KEY `idx_change_date` (`change_date`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_databreach_users` (
	`userid` INT NOT NULL ,
	`violated_user` tinyint NOT NULL DEFAULT 0,
	PRIMARY KEY ( `userid` ),
	INDEX `violateduseridx` (`violated_user`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_consent_registry` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
	 `url` varchar(255) NOT NULL DEFAULT '',
	 `formid` varchar(255) NOT NULL DEFAULT '',
  	 `formname` varchar(255) NOT NULL DEFAULT '',
  	 `user_id` int unsigned NOT NULL default '0',
	 `session_id` varchar(255) NOT NULL DEFAULT '',
	 `consent_date` datetime NULL,
	 `formfields` text NULL,
	  PRIMARY KEY (`id`),
	  KEY `idx_url` (`url`),
	  KEY `idx_formid` (`formid`),
	  KEY `idx_formname` (`formname`),
	  KEY `idx_userid` (`user_id`),
	  KEY `idx_sessionid` (`session_id`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_record` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
	 `fields` text NULL,
	 `checked_out` int unsigned NULL,
  	 `checked_out_time` datetime NULL,
  	 `published` tinyint NOT NULL default '1',
  	 `ordering` int NOT NULL default '0',
	  PRIMARY KEY (`id`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_checkbox` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
	 `placeholder` varchar(255) NOT NULL DEFAULT '',
	 `name` varchar(255) NOT NULL DEFAULT '',
	 `descriptionhtml` text NULL,
	 `formselector` varchar(255) NULL,
	 `required` tinyint NOT NULL default '0',
	 `checked_out` int unsigned NULL,
  	 `checked_out_time` datetime NULL,
  	 `published` tinyint NOT NULL default '1',
  	 `access` int NOT NULL default '1',
	  PRIMARY KEY (`id`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_cookie_consent_registry` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
  	 `user_id` int unsigned NOT NULL default '0',
	 `session_id` varchar(255) NOT NULL DEFAULT '',
	 `ipaddress` varchar(255) NULL,
	 `consent_date` datetime NULL,
	 `generic` tinyint NOT NULL default '0',
	 `category1` tinyint NOT NULL default '0',
	 `category2` tinyint NOT NULL default '0',
	 `category3` tinyint NOT NULL default '0',
	 `category4` tinyint NOT NULL default '0',
	  PRIMARY KEY (`id`),
	  KEY `idx_userid` (`user_id`),
	  KEY `idx_sessionid` (`session_id`),
	  KEY `idx_ipaddress` (`ipaddress`),
	  KEY `idx_consent_date` (`consent_date`)
) ENGINE=InnoDB CHARACTER SET `utf8`;

CREATE TABLE IF NOT EXISTS `#__gdpr_cookie_descriptions` (
	 `id` int unsigned NOT NULL AUTO_INCREMENT,
	 `cookie` varchar(255) NOT NULL DEFAULT '',
	 `category` int unsigned NOT NULL default '1',
	 `descriptionhtml` text NULL,
	 `checked_out` int unsigned NULL,
  	 `checked_out_time` datetime NULL,
  	 `published` tinyint NOT NULL default '1',
	  PRIMARY KEY (`id`)
) ENGINE=InnoDB CHARACTER SET `utf8`;
-- Exceptions queries in reverse versioning order 10.0 -> 1.0