<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

/**
 * Class WeblinkHelper
 */
class WeblinkHelper
{
	/**
	 * Get an instance of the named model
	 *
	 * @param   string  $name  Model name
	 *
	 * @return null|object
	 */
	public static function getModel($name)
	{
		$model = null;

		if (file_exists(JPATH_SITE . '/components/com_weblinklogospro/models/' . strtolower($name) . '.php'))
		{
			require_once JPATH_SITE . '/components/com_weblinklogospro/models/' . strtolower($name) . '.php';
			$model = BaseDatabaseModel::getInstance($name, 'WeblinklogosproModel');
		}

		return $model;
	}

    /**
     * Gets the edit permission for an user
     *
     * @param   mixed  $item  The item
     *
     * @return  bool
     */
    public static function canUserEdit($item)
    {
        $permission = false;

        $user = Factory::getUser();

        if ($user->authorise('core.edit', 'com_weblinklogospro')) {
            $permission = true;
        } else {
            if (isset($item->created_by)) {
                if ($user->authorise('core.edit.own', 'com_weblinklogospro') && $item->created_by == $user->id) {
                    $permission = true;
                }
            } else {
                $permission = true; // new creation
            }
        }

        return $permission;
    }
}
