<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Service;

defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Categories\CategoryFactoryInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Component\Router\RouterViewConfiguration;
use Joomla\CMS\Component\Router\Rules\MenuRules;
use Joomla\CMS\Component\Router\Rules\NomenuRules;
use Joomla\CMS\Component\Router\Rules\StandardRules;
use Joomla\CMS\Menu\AbstractMenu;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;

/**
 * Routing class of com_weblinklogospro
 */
class Router extends RouterView
{
	/**
	 * Flag to remove IDs
	 *
	 * @var    boolean
	 */
	protected $noIDs = false;

	/**
	 * The category factory
	 *
	 * @var CategoryFactoryInterface
	 */
	private $categoryFactory;

	/**
	 * The category cache
	 *
	 * @var  array
	 */
	private $categoryCache = [];

	/**
	 * The db
	 *
	 * @var DatabaseInterface
	 */
	private $db;

	/**
	 * Weblink Logos Pro Component router constructor
	 *
	 * @param   SiteApplication           $app              The application object
	 * @param   AbstractMenu              $menu             The menu object to work with
	 * @param   CategoryFactoryInterface  $categoryFactory  The category object
	 * @param   DatabaseInterface         $db               The database object
	 */
	public function __construct(SiteApplication $app, AbstractMenu $menu, CategoryFactoryInterface $categoryFactory, DatabaseInterface $db)
	{
		$this->categoryFactory = $categoryFactory;
		$this->db = $db;

		$params = ComponentHelper::getParams('com_weblinklogospro');
		$weblink_params = ComponentHelper::getParams('com_weblinks');

		$this->noIDs = (bool) $weblink_params->get('sef_ids');
		
// 		$category = new RouterViewConfiguration('category');
// 		$category->setKey('id')->setNestable();
// 		$this->registerView($category);

		$this->registerView(new RouterViewConfiguration('directory'));
		
		$this->registerView(new RouterViewConfiguration('weblinks'));
		
		$weblink = new RouterViewConfiguration('weblink');
		$weblink->setKey('id');
		$this->registerView($weblink);

		parent::__construct($app, $menu);

		$this->attachRule(new MenuRules($this));
		$this->attachRule(new StandardRules($this));
		$this->attachRule(new NomenuRules($this));
	}	
	
	/**
	 * Method to get the segment(s) for a category
	 *
	 * @param   string  $id     ID of the category to retrieve the segments for
	 * @param   array   $query  The request that is built right now
	 *
	 * @return  array|string  The segments of this item
	 */
// 	public function getCategorySegment($id, $query)
// 	{
// 	    $category = $this->getCategories()->get($id);
	    
// 	    if ($category)
// 	    {
// 	        $path = array_reverse($category->getPath(), true);
// 	        //$path[0] = '1:root';
	        
// 	        if ($this->noIDs)
// 	        {
// 	            foreach ($path as &$segment)
// 	            {
// 	                list($id, $segment) = explode(':', $segment, 2);
// 	            }
// 	        }
	        
// 	        return $path;
// 	    }
	    
// 	    return array();
// 	}
	
	/**
	 * Method to get the id for a category
	 *
	 * @param   string  $segment  Segment to retrieve the ID for
	 * @param   array   $query    The request that is parsed right now
	 *
	 * @return  mixed   The id of this item or false
	 */
// 	public function getCategoryId($segment, $query)
// 	{
// 	    if (isset($query['id']))
// 	    {
// 	        $category = $this->getCategories(['access' => false])->get($query['id']);
	        
// 	        if ($category)
// 	        {
// 	            foreach ($category->getChildren() as $child)
// 	            {
// 	                if ($this->noIDs)
// 	                {
// 	                    if ($child->alias == $segment)
// 	                    {
// 	                        return $child->id;
// 	                    }
// 	                }
// 	                else
// 	                {
// 	                    if ($child->id == (int) $segment)
// 	                    {
// 	                        return $child->id;
// 	                    }
// 	                }
// 	            }
// 	        }
// 	    }
	    
// 	    return false;
// 	}
	
	public function getDirectorySegment($id, $query)
	{
	    return array();
	}
	
	public function getDirectoryId($segment, $query)
	{
	    return (int) $segment;
	}
	
	public function getWeblinkSegment($id, $query)
	{
	    if (!strpos($id, ':'))
	    {
	        $id = (int) $id;
	        $dbquery = $this->db->getQuery(true);
	        $dbquery->select($this->db->quoteName('alias'))
	        ->from($this->db->quoteName('#__weblinks'))
	        ->where($this->db->quoteName('id') . ' = :id')
	        ->bind(':id', $id, ParameterType::INTEGER);
	        $this->db->setQuery($dbquery);
	        
	        $id .= ':' . $this->db->loadResult();
	    }
	    
	    if ($this->noIDs)
	    {
	        list($void, $segment) = explode(':', $id, 2);
	        
	        return array($void => $segment);
	    }
	    
	    return array((int) $id => $id);
	}
	
	public function getWeblinkId($segment, $query)
	{
	    if ($this->noIDs)
	    {
	        $dbquery = $this->db->getQuery(true);
	        $dbquery->select($this->db->quoteName('id'))
	        ->from($this->db->quoteName('#__weblinks'))
	        ->where(
	            [
	                $this->db->quoteName('alias') . ' = :alias',
	                $this->db->quoteName('catid') . ' = :catid',
	            ]
	            )
	            ->bind(':alias', $segment)
	            ->bind(':catid', $query['id'], ParameterType::INTEGER);
	            $this->db->setQuery($dbquery);
	            
	            return (int) $this->db->loadResult();
	    }
	        
	    return (int) $segment;
	}
	
	public function preprocess($query)
	{
	    if ($this->menu->getActive() && !isset($query['Itemid'])) {
	        $query['Itemid'] = $this->menu->getActive()->id;
	    }
	    
	    // Process the parsed variables based on custom defined rules
	    foreach ($this->rules as $rule)
	    {
	        $rule->preprocess($query);
	    }
	    
	    return $query;
	}

}
