<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\View\Directory;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\CategoryFeedView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Document\Feed\FeedItem;

/**
 * RSS View class for the WebLink Logos Pro component
 */
class FeedView extends CategoryFeedView
{
	public function display($tpl = null)
	{
		$app = Factory::getApplication();
		$doc = Factory::getDocument();

		$doc->link = Route::_('index.php?option=com_weblinklogospro&view=directory');

		$app->input->set('limitstart', 0);
		$app->input->set('limit', $app->get('feed_limit'));

		$siteEmail = $app->get('mailfrom');
		$fromName = $app->get('fromname');
		$feedEmail = $app->get('feed_email', 'none');

		$doc->editor = $fromName;

		if ($feedEmail != "none") {
			$doc->editorEmail = $siteEmail;
		}

		// TODO ? description

		// get data from the model
		$items = $this->get('Items');

		foreach ($items as $item) {

			$feeditem = new FeedItem;
			
			// title
			
			$title = $this->escape($item->title);
			$feeditem->title = html_entity_decode($title, ENT_COMPAT, 'UTF-8'); // strip HTML from feed item title
			
			// link
			
			$feeditem->link = $item->url;
			
			// description
			
			$feeditem->description = '';
			
			// add image, if any
			if ($item->image_first) {
				$image = preg_match('/http/', $item->image_first) ? $item->image_first : Uri::root() . $item->image_first;
				$feeditem->description .= '<p class="item_image"><img src="' . $image . '" /></p>';
			}
			
			$feeditem->description .= $item->description;
			
			// date
			
			$feeditem->date = date('r', strtotime($item->created)); // publish_up date would be great, but info missing most of the time
			
			// category
			
			$feeditem->category = $item->category_title;
			
			// author
			
			$feeditem->author = $item->author;
			if ($feedEmail === 'site') {
				$feeditem->authorEmail = $siteEmail;
			} elseif ($feedEmail === 'author') {
				$feeditem->authorEmail = $item->author_email;
			}

			// loads item info into RSS array
			$doc->addItem($feeditem);
		}
	}

}
