<?php
/**
 * ------------------------------------------------------------------------
 * Logo Slider  Module
 * ------------------------------------------------------------------------
 * Copyright (C) 2014-2018 LogicHunt, All Rights Reserved.
 * license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: LogicHunt,
 * Websites:  http://logichunt.com
 * ------------------------------------------------------------------------
 */
defined('_JEXEC') or die;


// Include the syndicate functions only once
require_once __DIR__ . '/helper/helper.php';

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));



// Newly Add: 2020

$ticker_en       =  $params->get('ticker_en');


if($ticker_en == 1) {
    $autoplayTimeout = 0;
    $autoplaySpeed = 3000;

} else {
    $autoplayTimeout    = intval($params->get('lgx_logo_autoplaytimeout', 2000));
    $autoplaySpeed      = intval($params->get('lgx_logo_autoplay_speed', 1000));
}






// Newly Add: 2019

$custom_style       = trim($params->get('custom_style'));



// Basic params
//$source              = $params->get('source', 'custom');
$random_display      = $params->get('random', 0);
$native_field        = $params->get('lgxrepeatfield');
$custom_field        = json_decode(str_replace("|lgx|", "\"", htmlspecialchars($params->get('slides'))));
$loop                = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_loop', 1));
$margin              = intval($params->get('lgx_logo_margin', 10));
$stagePadding        = intval($params->get('lgx_logo_stagepadding', 0));

$compnayanme_en      = intval($params->get('company_name_en', 0));
$load_jquery         = intval($params->get('load_jquery', 1));

$company_tooltip_en  = $params->get('company_tooltip_en', 'tooltip');

$hover_style         = $params->get('hover_type');
$active_anim         = $params->get('active_anim');

$target_type         = $params->get('target_type', '_blank');
$url_en              = intval($params->get('url_en', 1));

$v_nav_padding_left  = intval($params->get('v_nav_padding_left', 50));
$v_nav_padding_right = intval($params->get('v_nav_padding_right', 250));
$v_nav_position      = intval($params->get('v_nav_position', 38));
$tlr_nav_position    = intval($params->get('tlr_nav_position', 0));
$img_border_en       = intval($params->get('img_border_en', 0));

$img_border_width    = intval($params->get('img_border_width', 1));
$img_padding         = intval($params->get('img_padding', 0));
$img_bg_en           = intval($params->get('img_bg_en', 0));


$logo_max_width         =intval($params->get('logo_max_width', 200));
$logo_max_height        =intval($params->get('logo_max_height', 200));


//ToolTip Settings
$tooltip_en            = intval($params->get('tooltip_en', 0));
$tp_side               = $params->get('tp_side', 'top');
$tp_side_arr           = LgxLogoSliderHelper::lgx_TP_Slide_type($tp_side);
$tp_animation          = $params->get('tp_animation', 'fade');
$tp_animationduration  = intval($params->get('tp_animationduration'), 350);
$tp_delay              = intval($params->get('tp_delay'), 300);
$tp_arrow              = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('tp_arrow', 1));
$tp_trigger            = $params->get('tp_trigger', 'hover');
$tp_distance           = intval($params->get('tp_distance', 6));
$tp_minintersection    = intval($params->get('tp_minintersection', 16));
$tp_minwidth           = intval($params->get('tp_minwidth', 0));
$tp_timer              = intval($params->get('tp_timer', 0));
$tp_padding            = intval($params->get('tp_padding', 8));
$tp_border_radius      = intval($params->get('tp_border_radius', 6));
$tp_shadow_en          = intval($params->get('tp_shadow_en', 1));

$nav_margin            =  intval($params->get('nav_margin', 1));;
$nav_padding           =  intval($params->get('nav_padding', 4));;
$nav_img_size          =  intval($params->get('nav_img_size', 20));;


// Slider Params
$nav                = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_nav', 1));
$dots               = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_dots', 0));
$autoplay           = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_autoplay', 1));
$rtl                = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_rtl', 0));
$smartSpeed         = intval($params->get('lgx_logo_smartspeed', 450));
$freeDrag           = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_freedrag', 0));
$pullDrag           = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_pulldrag', 1));
$mouseDrag          = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_mousedrag', 1));
$touchDrag          = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_touchdrag', 1));
$lazyLoad           = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_lazyload', 0));
$lazyContent        = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_lazycontent', 0));
$center             = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_center', 0));

$autoplayHoverPause = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_autoplayhoverpause', 0));
$rewind             = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_rewind', 1));
$dotsEach           = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_doteach',0));


//Responsive Params (Slider)
$responsiveClass    = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_responsiveclass', 1));
$mobile_item        = intval($params->get('lgx_logo_mobile_item', 2));
$mobile_nav         = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_mobile_nav', 1));
$tablet_item        = intval($params->get('lgx_logo_tablet_item', 3));
$tablet_nav         = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_tablet_nav', 1));
$desktop_item       = intval($params->get('lgx_logo_desktop_item', 4));
$desktop_nav        = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_desktop_nav', 1));
$large_desktop_item = intval($params->get('lgx_logo_large_desktop_item', 5));
$large_desktop_nav  = LgxLogoSliderHelper::lgx_logo_btngroup($params->get('lgx_logo_large_desktop_nav', 1));


// Style Params ()
$bg_opacity       = $params->get('logo_bg_opacity', 0);
$inner_bg_color   = $params->get('lgx_logo_inner_bg_color', '#rrggbb');
$inner_op_bg            = LgxLogoSliderHelper::lgx_logo_hex2rgba($inner_bg_color, $bg_opacity);
$nav_position        = $params->get('lgx_logo_nav_position', 'bottom');
$nav_tape            = $params->get('lgx_logo_nav_type', 'img');
$navimgLeft          = $params->get('lgx_logo_navimgleft');
$navimgRight         = $params->get('lgx_logo_navimgright');
$navTextLeft         = $params->get('lgx_logo_navtextleft', 'Prev');
$navTextRight        = $params->get('lgx_logo_navtextright', 'Next');
$nav_area_top_margin = intval($params->get('nav_area_top_margin',10));
$dot_area_top_margin = intval($params->get('dot_area_top_margin',10));

$bg_img_en        = intval($params->get('lgx_logo_bg_img_en', 0));
$bg_color_en      = intval($params->get('lgx_logo_bg_color_en', 0));
$bg_img           = $params->get('lgx_logo_bg_img', '');
$bg_attachment    = $params->get('lgx_logo_bg_attachment', 'initial');
$bg_size          = $params->get('lgx_logo_bg_size_type', 'cover');
$inner_color      = $params->get('lgx_logo_inner_color', '#000');
$company_color    = $params->get('company_text_color', '#000');

$company_font_size      = intval($params->get('company_font_size', 20));
$content_width          = $params->get('content_width', '100%');
$section_margin_top     = intval($params->get('lgx_logo_section_margin_top', 0));
$section_margin_bottom  = intval($params->get('lgx_logo_section_margin_bottom', 0));
$section_padding_top    = intval($params->get('lgx_logo_section_padding_top', 0));
$section_padding_bottom = intval($params->get('lgx_logo_section_padding_bottom', 0));

// Header

$header_en                  = intval($params->get('header_en', 0));

$header_title               = $params->get('header_title');
$header_title_font_size     = intval($params->get('header_title_font_size', 36));
$header_title_font_color    = $params->get('header_title_font_color', '#010101');
$header_title_font_weight   = intval($params->get('header_title_font_weight', 700));
$header_title_margin_bottom = intval($params->get('header_title_margin_bottom', 10));

$header_subtitle               = $params->get('header_subtitle');
$header_subtitle_font_size     = intval($params->get('header_subtitle_font_size', 16));
$header_subtitle_font_color    = $params->get('header_subtitle_font_color', '#888888');
$header_subtitle_font_weight   = intval($params->get('header_subtitle_font_weight', 400));
$header_subtitle_margin_bottom = intval($params->get('header_subtitle_margin_bottom', 10));
$tp_bg_color                   = $params->get('tp_bg_color', '#d3d3d3');
$tp_border_color               = $params->get('tp_border_color', '#333333');
$tp_arrow_bg                   = $params->get('tp_arrow_bg', '#555555');
$tp_arrow_border_color         = $params->get('tp_arrow_border_color', '#333333');
$tp_text_color                 = $params->get('tp_text_color', '#ffffff');

// New
$nav_hover = intval($params->get('nav_hover', 0));
$dot_hover =  intval($params->get('dot_hover', 0));;
$get_img_nav_bg      = $params->get('img_nav_bg', '#222b30');
$get_img_nav_bg_hover      = $params->get('img_nav_bg_hover', '#222b30');

// Color
$dot_color        = $params->get('lgx_logo_dot_color', '#d6d6d6');
$dot_color_active = $params->get('lgx_logo_dot_color_active', '#869791');


$img_nav_bg          = (($get_img_nav_bg == '#rrggbb') ? 'transparent' : $get_img_nav_bg);
$nav_text_color      = $params->get('lgx_logo_nav_text_color', '#fff');

$img_bg_color        = $params->get('img_bg_color','#f9f9f9');
$img_border_color    = $params->get('img_border_color','#d5d5d5');

//  Hover Color

$img_nav_bg_hover          = (($get_img_nav_bg_hover == '#rrggbb') ? 'transparent' : $get_img_nav_bg_hover);
$nav_text_color_hover      = $params->get('lgx_logo_nav_text_color_hover', '#fff');

$img_bg_color_hover        = $params->get('img_bg_color_hover','#f9f9f9');
$img_border_color_hover    = $params->get('img_border_color_hover','#d5d5d5');


// Sibling Array
$sibling_arr = array(
    'sibling-gray',
    'sibling-fade',
    'sibling-fade-gray',
    'sibling-gray logohover-zoom-in',
    'sibling-fade-gray logohover-zoom-in',
    'sibling-gray logohover-perspective-rotate',
    'sibling-fade-gray logohover-perspective-rotate',
    'sibling-gray logohover-rotate-circle',
    'sibling-fade-gray logohover-rotate-circle',
    'sibling-gray logohover-rotateIn',
    'sibling-fade-gray logohover-rotateIn',
    'sibling-gray logohover-jello',
    'sibling-fade-gray logohover-jello',
    'sibling-gray logohover-flash',
    'sibling-fade-gray logohover-flash',
    'sibling-fade-gray logohover-pulse',
    'sibling-fade-gray logohover-spin',
    'sibling-fade-gray logohover-rotate-x',
    'sibling-fade-gray logohover-rotate-y',
    'sibling-fade-gray logohover-flipX',
    'sibling-fade-gray logohover-flipY',
    'sibling-gray logohover-bounceIn',
    'sibling-fade-gray logohover-bounceIn',
);


// Source Selection
$source              = 'joomla';
$items = LgxLogoSliderHelper::LgxLogoSliderSource($source, $native_field, $custom_field);

//Randomize
if($random_display){
    $items = LgxLogoSliderHelper::LgxLogoRandomize($items);
}

if (!empty($items)) {
    // Include All Default Assets // No Need.
   // include(dirname(__FILE__) . '/assets/asset.php');

    require JModuleHelper::getLayoutPath('mod_lgx_logoslider', $params->get('layout', 'default'));

} else {
    echo 'There are No Item. At First add some Item.';
}