<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
*/

defined('_JEXEC') or die;

use Joomla\CMS\Http\Http;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use SYW\Library\Libraries as SYWLibraries;

class plgQuickiconWeblinklogospro extends CMSPlugin
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  4.0.0
     */
    protected $autoloadLanguage = true;

    /**
     * Application object
     */
    protected $app;

	public function onGetIcons($context)
	{
	    if ($context !== $this->params->get('context', 'update_quickicon')
	        || !$this->app->getIdentity()->authorise('core.manage', 'com_installer')) {
			return [];
		}

	    $HTTPClient = new Http();

		$url = 'https://updates.simplifyyourweb.com/pro/weblinklogospro/com_weblinklogospro-j4.json';

		// Try to get informations
		try {
		    $latestVersion = '';

		    $response = $HTTPClient->get($url);

		    if ($response->getStatusCode() == 200) {
		        $decodedUpdateInfos = json_decode($response->getBody());
		        $latestVersion = $decodedUpdateInfos->{'latest'};
		        $infoVersion = $decodedUpdateInfos->{'relevance'};
		    }

		    if ($latestVersion) {
		    	SYWLibraries::loadCompareVersions();

				$currentVersion = strval(simplexml_load_file(JPATH_BASE . '/components/com_weblinklogospro/weblinklogospro.xml')->version);

				$wam = $this->app->getDocument()->getWebAssetManager();

				$compareScript = <<< JS
					document.addEventListener("readystatechange", function(event) {
						if (event.target.readyState === "complete") {
							document.querySelector("span[data-bind=wlp_version]").textContent = "{$latestVersion}";
							if (SYWCompareVersions("{$latestVersion}","{$currentVersion}")) {
                                document.querySelector("span[data-status=wlp_uptodate]").style.display = "inline-block";
                                document.getElementById("plg_quickicon_weblinklogospro").classList.replace("info", "success");
                            } else {
                                document.querySelector("span[data-status=wlp_outdated]").style.display = "inline-block";
                                document.getElementById("plg_quickicon_weblinklogospro").classList.replace("info", "danger");
                            }
							document.querySelector("span[data-status=wlp_unknown]").style.display = "none";
						}
					});
JS;

				$wam->addInlineScript($compareScript);

				$inlineCSS = <<< CSS
                    .icon-wlp {
                        -webkit-mask-image: url("../media/com_weblinklogospro/images/wlp.svg");
                        mask-image: url("../media/com_weblinklogospro/images/wlp.svg");
                        -webkit-mask-size: 100%;
                        mask-size: 100%;
                        width: 32px;
                        height: 32px;
                        background-color: var(--icon-color);
                    }
CSS;
				$wam->addInlineStyle($inlineCSS);

				$iconDefinition = [
				    'link'  => 'index.php?option=com_installer&view=update',
				    'image' => 'icon-wlp',
				    'icon'  => '',
				    'text' => '<span data-status=\'wlp_unknown\'>'.Text::_('PLG_QUICKICON_WEBLINKLOGOSPRO_UNKNOWN_MESSAGE').'</span><span data-status=\'wlp_uptodate\' style=\'display:none\'>'.Text::_('PLG_QUICKICON_WEBLINKLOGOSPRO_VERSION_UPTODATE').'</span><span data-status=\'wlp_outdated\' style=\'display:none\'>'.Text::_('PLG_QUICKICON_WEBLINKLOGOSPRO_VERSION_OUTDATED').' <span title="' . htmlspecialchars($infoVersion, ENT_QUOTES, 'UTF-8') . '" class=\'hasTooltip badge text-dark bg-light\' data-bind=\'wlp_version\'></span></span>',
				    'class' => 'info',
				    'id'    => 'plg_quickicon_weblinklogospro',
				    'group' => 'MOD_QUICKICON_MAINTENANCE',
				];
		    } else {
		        $wam = $this->app->getDocument()->getWebAssetManager();

		        $inlineCSS = <<< CSS
                    .icon-wlp {
                        -webkit-mask-image: url("../media/com_weblinklogospro/images/wlp.svg");
                        mask-image: url("../media/com_weblinklogospro/images/wlp.svg");
                        -webkit-mask-size: 100%;
                        mask-size: 100%;
                        width: 32px;
                        height: 32px;
                        background-color: var(--icon-color);
                    }
CSS;
		        $wam->addInlineStyle($inlineCSS);

		        $iconDefinition = [
		            'link'  => 'index.php?option=com_weblinklogospro',
		            'image' => 'icon-wlp',
		            'icon'  => '',
		            'text'  => 'Weblink Logos Pro',
		            'class' => 'info',
		            'id'    => 'plg_quickicon_weblinklogospro',
		            'group' => 'MOD_QUICKICON_MAINTENANCE'
		        ];
		    }
		} catch(Exception $e) {
		    return [];
		}

		return [
		    $iconDefinition,
		];
	}
}