<?php
/**
 * @version		$Id: install.php 18650 2010-08-26 13:28:49Z ian $
 * @package		Joomla.Administrator
 * @subpackage	com_installer
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die();

// Import library dependencies


jimport('joomla.application.component.model');
jimport('joomla.installer.installer');
jimport('joomla.installer.helper');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');
/**
 * @desc modify from "Extension Manager Install Model" of "Installer Component"
 */
class JaextmanagerModelUploader extends JAEMModel
{
	/** @var object JTable object */
	var $_table = null;
	
	/** @var object JTable object */
	var $_url = null;


	/**
	 * Overridden constructor
	 * @access	protected
	 */
	function __construct()
	{
		parent::__construct();
	
	}


	function upload()
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');
		
		$this->setState('action', 'upload');
		
		switch (JRequest::getWord('installtype')) {
			case 'folder':
				$package = $this->_getPackageFromFolder();
				break;
			
			case 'upload':
				$package = $this->_getPackageFromUpload();
				break;
			
			case 'url':
				$package = $this->_getPackageFromUrl();
				break;
			
			default:
				JError::raiseWarning(100, JText::_('NO_UPLOAD_TYPE_FOUND'));
				return false;
				break;
		}
		
		// Was the package unpacked?
		if (!$package) {
			JError::raiseWarning(100, JText::_('UNABLE_TO_FIND_INSTALL_PACKAGE'));
			return false;
		}
		
		// Get an ja extension uploader instance
		$uploader = jaExtUploader::getInstance();
		$result = $uploader->upload($package['dir']);
		if (!$result) {
			// There was an error uploading the package
			$msg = JText::sprintf('THERE_WAS_AN_ERROR_UPLOADING_THE_PACKAGE_S', $package['type']);
			JError::raiseWarning(100, $msg);
			//$result = false;
		} else {
			// Package uploaded sucessfully
			$msg = JText::sprintf('COM_INSTALLER_INSTALL_SUCCESS', $package['type']);
			//$result = true;
		}
		
		// Cleanup the install files
		if (!JFile::exists($package['packagefile'])) {
			$config = JFactory::getConfig();
			$package['packagefile'] = $config->get('tmp_path').'/'.$package['packagefile'];
		}
		
		JInstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
		
		return $result;
	}


	/**
	 * Works out an installation package from a HTTP upload
	 *
	 * @return package definition or false on failure
	 */
	protected function _getPackageFromUpload()
	{
		// Get the uploaded file information
		$userfile = JRequest::getVar('install_package', null, 'files', 'array');
		
		// Make sure that file uploads are enabled in php
		if (!(bool) ini_get('file_uploads')) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLFILE'));
			return false;
		}
		
		// Make sure that zlib is loaded so that the package can be unpacked
		if (!extension_loaded('zlib')) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLZLIB'));
			return false;
		}
		
		// If there is no uploaded file, we have a problem...
		if (!is_array($userfile)) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_NO_FILE_SELECTED'));
			return false;
		}
		
		// Check if there was a problem uploading the file.
		if ($userfile['error'] || $userfile['size'] < 1) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLUPLOADERROR'));
			return false;
		}
		
		// Build the appropriate paths
		$config = JFactory::getConfig();
		$tmp_dest = $config->get('tmp_path').'/'.$userfile['name'];
		$tmp_src = $userfile['tmp_name'];
		
		// Move uploaded file
		jimport('joomla.filesystem.file');
		$uploaded = JFile::upload($tmp_src, $tmp_dest,false,true);
		
		// Unpack the downloaded package file
		$package = JInstallerHelper::unpack($tmp_dest);
		
		return $package;
	}


	/**
	 * Install an extension from a directory
	 *
	 * @return	Package details or false on failure
	 * @since	1.5
	 */
	protected function _getPackageFromFolder()
	{
		// Get the path to the package to install
		$p_dir = JRequest::getString('install_directory');
		$p_dir = JPath::clean($p_dir);
		
		// Did you give us a valid directory?
		if (!JFolder::exists($p_dir)) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_PLEASE_ENTER_A_PACKAGE_DIRECTORY'));
			return false;
		}
		
		// Detect the package type
		$type = JInstallerHelper::detectType($p_dir);
		
		// Did you give us a valid package?
		if (!$type) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_PATH_DOES_NOT_HAVE_A_VALID_PACKAGE'));
			return false;
		}
		
		$package['packagefile'] = null;
		$package['extractdir'] = null;
		$package['dir'] = $p_dir;
		$package['type'] = $type;
		
		return $package;
	}


	/**
	 * Install an extension from a URL
	 *
	 * @return	Package details or false on failure
	 * @since	1.5
	 */
	protected function _getPackageFromUrl()
	{
		// Get a database connector
		$db = JFactory::getDbo();
		
		// Get the URL of the package to install
		$url = JRequest::getString('install_url');
		
		// Did you give us a URL?
		if (!$url) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_ENTER_A_URL'));
			return false;
		}
		
		// Download the package at the URL given
		$p_file = JInstallerHelper::downloadPackage($url);
		
		// Was the package downloaded?
		if (!$p_file) {
			JError::raiseWarning('', JText::_('COM_INSTALLER_MSG_INSTALL_INVALID_URL'));
			return false;
		}
		
		$config = JFactory::getConfig();
		$tmp_dest = $config->get('tmp_path');
		
		// Unpack the downloaded package file
		$package = JInstallerHelper::unpack($tmp_dest.'/'.$p_file);
		
		return $package;
	}
}