<?php

/**
T4 Overide
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;

$app = Factory::getApplication();

$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$this->category->description = $this->category->text;

$results = $app->triggerEvent('onContentAfterTitle', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentBeforeDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentAfterDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayContent = trim(implode("\n", $results));

$num_columns = $this->params->get('num_columns');

// init columns value if not set
if (empty($num_columns)) $num_columns = 1;

// $this->params->get('num_columns')
// var_dump($num_columns);
// die();

?>
<div class="com-content-category-blog blog <?php echo $this->pageclass_sfx; ?>" itemscope itemtype="https://schema.org/Blog">
  <?php if ($this->params->get('show_page_heading')) : ?>
    <div class="page-header">
      <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
    </div>
  <?php endif; ?>

  <?php if ($this->params->get('show_category_title', 1) or $this->params->get('page_subheading')) : ?>
    <div class="page-subheader clearfix">
      <h2 class="page-subtitle"> <?php echo $this->escape($this->params->get('page_subheading')); ?>
        <?php if ($this->params->get('show_category_title')) : ?>
          <span class="subheading-category"><?php echo $this->category->title; ?></span>
        <?php endif; ?>
      </h2>
    </div>
  <?php endif; ?>

  <?php echo $afterDisplayTitle; ?>

  <?php if ($this->params->get('show_cat_tags', 1) && !empty($this->category->tags->itemTags)) : ?>
    <?php $this->category->tagLayout = new FileLayout('joomla.content.tags'); ?>
    <?php echo $this->category->tagLayout->render($this->category->tags->itemTags); ?>
  <?php endif; ?>

  <?php if ($beforeDisplayContent || $afterDisplayContent || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
    <div class="category-desc clearfix">
      <?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
        <img src="<?php echo $this->category->getParams()->get('image'); ?>" alt="<?php echo htmlspecialchars($this->category->getParams()->get('image_alt'), ENT_COMPAT, 'UTF-8'); ?>">
      <?php endif; ?>
      <?php echo $beforeDisplayContent; ?>
      <?php if ($this->params->get('show_description') && $this->category->description) : ?>
        <?php echo HTMLHelper::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>
      <?php endif; ?>
      <?php echo $afterDisplayContent; ?>
    </div>
  <?php endif; ?>

  <?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
    <?php if ($this->params->get('show_no_articles', 1)) : ?>
      <p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p>
    <?php endif; ?>
  <?php endif; ?>

  <?php $leadingcount = 0; ?>
  <?php if (!empty($this->lead_items)) : ?>
    <div class="com-content-category-blog__items blog-items items-leading <?php echo $this->params->get('blog_class_leading'); ?>">
      <?php foreach ($this->lead_items as &$item) : ?>
        <div class="com-content-category-blog__item blog-item bg-primary-light" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
          <div class="blog-item-content"><!-- Double divs required for IE11 grid fallback -->
            <?php
            $this->item = &$item;
            echo $this->loadTemplate('item');
            ?>
          </div>
        </div>
        <?php $leadingcount++; ?>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <?php
  $introcount = count($this->intro_items);
  $counter = 0;
  ?>

  <?php if (!empty($this->intro_items)) : ?>
    <div class="items-intro cols-<?php echo $num_columns; ?>">
      <?php foreach ($this->intro_items as $key => &$item) : ?>
        <?php $rowcount = ((int) $key % (int) $num_columns) + 1; ?>
        <?php if ($rowcount === 1) : ?>
          <?php $row = $counter / $num_columns; ?>
        <?php endif; ?>
        <div class="item-wrap">
          <div class="item bg-primary-light clearfix<?php echo $item->state == 0 ? ' system-unpublished' : null; ?>" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
            <?php
            $this->item = &$item;
            echo $this->loadTemplate('item');
            ?>
          </div><!-- end item -->
          <?php $counter++; ?>
        </div><!-- end span -->
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($this->link_items)) : ?>
    <div class="com-content-category-blog__items-more items-more">
      <?php echo $this->loadTemplate('links'); ?>
    </div>
  <?php endif; ?>

  <?php if ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) : ?>
    <div class="com-content-category-blog__children cat-children">
      <?php if ($this->params->get('show_category_heading_title_text', 1) == 1) : ?>
        <h3> <?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
      <?php endif; ?>
      <?php echo $this->loadTemplate('children'); ?>
    </div>
  <?php endif; ?>
  <?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
    <div class="pagination-wrap">
      <?php echo $this->pagination->getPagesLinks(); ?>
      <?php if ($this->params->def('show_pagination_results', 1)) : ?>
        <p class="counter">
          <?php echo $this->pagination->getPagesCounter(); ?>
        </p>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<script>
  (function($) {
    $(document).ready(function() {
      var $container = $('.items-intro');

      if (!$container.length) return;

      $container.isotope({
        itemSelector: '.item-wrap',
        gutter: 30
      });

      // re-order when images loaded
      $container.imagesLoaded(function() {
        $container.isotope();

        /* fix for IE-8 */
        setTimeout(function() {
          $('.items-intro').isotope();
        }, 8000);
      });
    });
  })(jQuery);
</script>