<?php
// namespace administrator\components\com_gdpr\models;
/**
 *
 * @package GDPR::AJAXSERVER::administrator::components::com_gdpr
 * @subpackage models
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
require_once (JPATH_ROOT . '/plugins/system/gdpr/simplehtmldom.php');

/**
 * Ajax Server model responsibilities
 *
 * @package GDPR::AJAXSERVER::administrator::components::com_gdpr
 * @subpackage models
 * @since 2.4
 */
interface IAjaxserverModel {
	public function loadAjaxEntity($id, $param, $DIModels);
}

/**
 * Classe che gestisce il recupero dei dati per il POST HTTP
 *
 * @package GDPR::AJAXSERVER::administrator::components::com_gdpr
 * @subpackage models
 * @since 2.4
 */
class GdprModelAjaxserver extends GdprModel implements IAjaxserverModel {
	/**
	 * CSV cookie category column
	 *
	 * @access private
	 * @param
	 *        	integer
	 */
	const COOKIECATEGORY = 0;

	/**
	 * CSV cookie name column
	 *
	 * @access private
	 * @param
	 *        	integer
	 */
	const COOKIENAME = 1;

	/**
	 * CSV cookie domain column
	 *
	 * @access private
	 * @param
	 *        	integer
	 */
	const COOKIEDOMAIN = 2;

	/**
	 * CSV cookie description column
	 *
	 * @access private
	 * @param
	 *        	integer
	 */
	const COOKIEDESCRIPTION = 3;

	/**
	 * CSV cookie expiration column
	 *
	 * @access private
	 * @param
	 *        	integer
	 */
	const COOKIEEXPIRATION = 4;

	/**
	 * Mapping for database categories and component parameters
	 *
	 * @access private
	 * @param
	 *        	array
	 */
	private $categoryParameterMapping = array (
			'Strictly Necessary' => 1,
			'Performance' => 2,
			'Functionality' => 2,
			'Targeting/Advertising' => 4,
			'Unknown' => 1,
			'Functional' => 2,
			'Analytics' => 3,
			'Marketing' => 4
	);

	/**
	 * Clean the cache
	 * @param   string   $group      The cache group
	 * @param   integer  $client_id  The ID of the client
	 * @return  void
	 * @since   11.1
	 */
	private function cleanComponentCache($group = null, $client_id = 0) {
		// Initialise variables;
		$conf = JFactory::getConfig();
		$dispatcher = JDispatcher::getInstance();
		
		$options = array(
				'defaultgroup' => ($group) ? $group : $this->app->input->get('option'),
				'cachebase' => ($client_id) ? JPATH_ADMINISTRATOR . '/cache' : $conf->get('cache_path', JPATH_SITE . '/cache'));
		
		$cache = JCache::getInstance('callback', $options);
		$cache->clean();
		
		// Trigger the onContentCleanCache event.
		$dispatcher->trigger('onContentCleanCache', $options);
	}

	/**
	 * Auto configure received cookies/domains to the matching categories, also creating description records
	 *
	 * @access private
	 * @param Object[] $additionalModels
	 *        	Array for additional injected models type hinted by interface
	 * @return Object
	 */
	private function autoConfigurationWizard($params, $additionalModels = null) {
		// Response JSON object
		$response = new stdClass ();
		$cParams = $this->getComponentParams ();
		$auditOverwriteCategories = $cParams->get('audit_overwrite_categories', 0);
		$auditAutoStateCategories = $cParams->get('audit_auto_state_categories', 0);
		$cookieIDCounter = array (
				1 => 0,
				2 => 0,
				3 => 0,
				4 => 0
		);
		$domainIDCounter = array (
				1 => 0,
				2 => 0,
				3 => 0,
				4 => 0
		);

		// Manage frontend translation overrides
		$categoryStrings = array ();
		$language = JFactory::getLanguage ()->getTag ();
		if (method_exists ( 'JLanguageHelper', 'parseIniFile' )) {
			$strings = JLanguageHelper::parseIniFile ( JPATH_ROOT . '/language/overrides/' . $language . '.override.ini' );
		} else {
			$strings = array ();
		}

		$category1Name = $this->componentParams->get ( 'cookie_category1_name', 'Necessary' );
		$categoryStrings [$this->categoryParameterMapping ['Strictly Necessary']] = array_key_exists ( $category1Name, $strings ) ? $strings [$category1Name] : JText::_ ( $category1Name );

		$category2Name = $this->componentParams->get ( 'cookie_category2_name', 'Preferences' );
		$categoryStrings [$this->categoryParameterMapping ['Functional']] = array_key_exists ( $category2Name, $strings ) ? $strings [$category2Name] : JText::_ ( $category2Name );

		$category3Name = $this->componentParams->get ( 'cookie_category3_name', 'Statistics' );
		$categoryStrings [$this->categoryParameterMapping ['Analytics']] = array_key_exists ( $category3Name, $strings ) ? $strings [$category3Name] : JText::_ ( $category3Name );

		$category4Name = $this->componentParams->get ( 'cookie_category4_name', 'Marketing' );
		$categoryStrings [$this->categoryParameterMapping ['Marketing']] = array_key_exists ( $category4Name, $strings ) ? $strings [$category4Name] : JText::_ ( $category4Name );

		try {
			$summary = array ();
			$summary ['foundCookies'] = array ();
			$summary ['foundDomains'] = array ();

			// Deserialize contents
			$csvDatabaseFile = JPATH_ROOT . '/administrator/components/com_gdpr/framework/helpers/open-cookie-database.csv';
			$fileHandle = fopen ( $csvDatabaseFile, "r" );
			if (! is_resource ( $fileHandle )) {
				throw new GdprException ( JText::_ ( 'COM_GDPR_WIZARD_DATA_FILE_NOT_READABLE' ), 'important' );
			}

			// Parse the CSV files dataset into an importable array
			$skip = true;
			$cookieDatabaseCookieIndex = array ();
			$cookieDatabaseDomainIndex = array ();
			while ( $csvRecord = fgetcsv ( $fileHandle, 0, ';', '"' ) ) {
				// Skip prima riga intestazioni
				if ($skip) {
					$skip = false;
					continue;
				}

				// Purify polluted domain field
				$parseDomain = explode ( ' ', $csvRecord [self::COOKIEDOMAIN] );
				if (isset ( $parseDomain [0] ) && JString::strpos ( $parseDomain [0], '.' )) {
					$csvRecord [self::COOKIEDOMAIN] = $parseDomain [0];
					$cookieDatabaseDomainIndex [$parseDomain [0]] = $csvRecord;
				}

				// Insert by array key for fast search
				$cookieDatabaseCookieIndex [$csvRecord [self::COOKIENAME]] = $csvRecord;
			}

			// Check if some valid data to import are available
			if (! count ( $cookieDatabaseCookieIndex )) {
				throw new GdprException ( JText::_ ( 'COM_GDPR_WIZARD_NO_DATA_FOUND' ), 'warning' );
			}

			$cookiesAutoConfiguredAdded = false;
			if ($numCookies = count ( $params->cookies )) {
				// Select the HTTP connector transport
				$httpTransport = $cParams->get ( 'bulk_consent_api_transport', 'curl' ) == 'socket' ? new GdprHttpTransportSocket () : new GdprHttpTransportCurl ();
				$httpTransport->forceFollowRedirect = true;
				$httpConnector = new GdprHttp ( $httpTransport );
				$simpleHtmlDomInstance = new GdprSimpleHtmlDom ();
				for($i = 0; $i < $numCookies; $i ++) {
					// Is the cookie in the Open Cookie Database? If not, try to search it on Cookiepedia
					if (! array_key_exists ( $params->cookies [$i], $cookieDatabaseCookieIndex )) {
						$apiURL = 'https://cookiepedia.co.uk/cookies/' . rawurldecode ( $params->cookies [$i] );
						try {
							$cookiepediaResponse = $httpConnector->get ( $apiURL );

							if ($cookiepediaResponse && $cookiepediaResponse->body) {
								$simpleHtmlDomInstance->load ( $cookiepediaResponse->body );
								// Category
								$domElements = $simpleHtmlDomInstance->find ( '#content-left > p > strong' );
								
								// Cookies not found either in Open Database and Cookiepedia, skip and go on
								if(!count($domElements)) {
									continue;
								}
								
								$element = $domElements [0];
								$cookieCategory = $element->text ();

								// Descriptions
								$domElements = $simpleHtmlDomInstance->find ( '#content-left > p' );
								$element = $domElements [0];
								$cookieDescriptions = $element->text ();
								// If there is no description available, detect and exclude
								if (JString::strpos ( $cookieDescriptions, 'please get in touch' )) {
									$cookieDescriptions = JText::_ ( 'COM_GDPR_WIZARD_COOKIE_DESCRIPTION_DEFAULT' );
								}

								$targetCategoryID = $this->categoryParameterMapping [$cookieCategory];
								$cookieDatabaseCookieIndex [$params->cookies [$i]] = array (
										$targetCategoryID,
										$params->cookies [$i],
										'',
										$cookieDescriptions,
										''
								);
							}
						} catch ( Exception $e ) {
							// No error handling go on with the process for other cookies
							continue;
						}
					}

					// Search for the cookie in the database
					if (array_key_exists ( $params->cookies [$i], $cookieDatabaseCookieIndex )) {
						$cookieDbObject = $cookieDatabaseCookieIndex [$params->cookies [$i]];

						// Retrieve the component parameter matching this category from the mapping
						$foundCategory = $cookieDbObject [self::COOKIECATEGORY];
						$targetCategoryID = isset ( $this->categoryParameterMapping [$foundCategory] ) ? $this->categoryParameterMapping [$foundCategory] : $foundCategory;
						$summary ['foundCookies'] [] = array (
								$cookieDbObject [self::COOKIENAME],
								$categoryStrings [$targetCategoryID]
						);
						$targetParameterCookie = 'cookie_category' . $targetCategoryID . '_list';
						$currentParameterValues = $cParams->get ( $targetParameterCookie );
						$currentParameterValuesArray = explode ( PHP_EOL, $currentParameterValues );
						$cookieIDCounter[$targetCategoryID]++;
						
						if (! in_array ( $cookieDbObject [self::COOKIENAME], $currentParameterValuesArray )) {
							// Reset all previous values in this category if requested, if this is the first iteration for this category and if there is at least one cookie found for this category
							if($auditOverwriteCategories && $cookieIDCounter[$targetCategoryID] == 1) {
								$currentParameterValuesArray = [];
							}
							
							// Add and store the new cookie
							$currentParameterValuesArray [] = $cookieDbObject [self::COOKIENAME];
							$cParams->set ( $targetParameterCookie, implode ( PHP_EOL, $currentParameterValuesArray ) );
							$cookiesAutoConfiguredAdded = true;

							// Create a cookie description
							$table = JTable::getInstance ( 'cookiedescriptions', 'Table' );
							$table->cookie = $cookieDbObject [self::COOKIENAME];
							$table->category = $targetCategoryID;
							$table->descriptionhtml = $cookieDbObject [self::COOKIEDESCRIPTION];
							$table->expiration = $cookieDbObject [self::COOKIEEXPIRATION];
							$table->store ();
						}
					}
				}
			}

			$domainsAutoConfiguredAdded = false;
			if ($numDomains = count ( $params->domains )) {
				for($i = 0; $i < $numDomains; $i ++) {
					// Search for the cookie in the database
					if (array_key_exists ( $params->domains [$i], $cookieDatabaseDomainIndex )) {
						$domainDbObject = $cookieDatabaseDomainIndex [$params->domains [$i]];

						// Retrieve the component parameter matching this category from the mapping
						$foundCategory = $domainDbObject [self::COOKIECATEGORY];
						$targetCategoryID = $this->categoryParameterMapping [$foundCategory];
						$summary ['foundDomains'] [] = array (
								$params->domains [$i],
								$categoryStrings [$targetCategoryID]
						);
						$targetParameterDomains = 'domains_category' . $targetCategoryID . '_list';
						$currentParameterValues = $cParams->get ( $targetParameterDomains );
						$currentParameterValuesArray = explode ( PHP_EOL, $currentParameterValues );
						$domainIDCounter[$targetCategoryID]++;
						
						if (! in_array ( $domainDbObject [self::COOKIEDOMAIN], $currentParameterValuesArray )) {
							// Reset all previous values in this category if requested, if this is the first iteration for this category and if there is at least one domain found for this category
							if($auditOverwriteCategories && $domainIDCounter[$targetCategoryID] == 1) {
								$currentParameterValuesArray = [];
							}
							
							// Add and store the new cookie
							$currentParameterValuesArray [] = $params->domains [$i];
							$cParams->set ( $targetParameterDomains, implode ( PHP_EOL, $currentParameterValuesArray ) );
							$domainsAutoConfiguredAdded = true;

							// Create a domain description
							$table = JTable::getInstance ( 'cookiedescriptions', 'Table' );
							$table->cookie = $domainDbObject [self::COOKIEDOMAIN];
							$table->category = $targetCategoryID;
							$table->descriptionhtml = $domainDbObject [self::COOKIEDESCRIPTION];
							$table->expiration = $domainDbObject [self::COOKIEEXPIRATION];
							$table->store ();
						}
					}
				}
			}

			// Evaluate each category that has been targeted
			if($auditAutoStateCategories) {
				for($cat = 1, $maxCat = 4; $cat <= $maxCat; $cat ++) {
					// Is a cookie or domain found for this category?
					if($cookieIDCounter[$cat] > 0 || $domainIDCounter[$cat] > 0) {
						// Set the category enabled
						$cParams->set('cookie_category' . $cat . '_enable', 1);
					} else {
						// Set this category disabled
						$cParams->set('cookie_category' . $cat . '_enable', 0);
					}
				}
			}

			// Store the db updated fields in the #__extensions table
			if ($cookiesAutoConfiguredAdded || $domainsAutoConfiguredAdded || $auditAutoStateCategories) {
				$table = JTable::getInstance ( 'extension' );
				// Found as installed extension
				if (! $extensionID = $table->find ( array (
						'element' => 'com_gdpr'
				) )) {
					throw new GdprException ( $table->getError (), 'error' );
				}

				$table->load ( $extensionID );
				$table->params = ( string ) $cParams;
				$table->store ();
			}

			// All completed successfully
			$response->result = true;
			$response->summary = $summary;
		} catch ( GdprException $e ) {
			$response->result = false;
			$response->exception_message = $e->getMessage ();
			$response->errorlevel = $e->getErrorLevel ();
			$response->data = $summary;
			return $response;
		} catch ( Exception $e ) {
			$gdprException = new GdprException ( JText::sprintf ( 'COM_GDPR_WIZARD_ERROR_AUTOCONFIGURE', $e->getMessage () ), 'important' );
			$response->result = false;
			$response->exception_message = $gdprException->getMessage ();
			$response->errorlevel = $gdprException->getErrorLevel ();
			$response->data = $summary;
			return $response;
		}
		
		// Clean the cache.
		$this->cleanComponentCache('_system', 0);
		$this->cleanComponentCache('_system', 1);

		return $response;
	}

	/**
	 * Mimic an entities list, as ajax calls arrive are redirected to loadEntity public responsibility to get handled
	 * by specific subtask.
	 * Responses are returned to controller and encoded from view over HTTP to JS client
	 *
	 * @access public
	 * @param string $id
	 *        	Rappresenta l'op da eseguire tra le private properties
	 * @param mixed $param
	 *        	Parametri da passare al private handler
	 * @param Object[]& $DIModels
	 * @return Object& $utenteSelezionato
	 */
	public function loadAjaxEntity($id, $param, $DIModels) {
		// Delega la private functions delegata dalla richiesta sulla entity
		$response = $this->$id ( $param, $DIModels );

		return $response;
	}
}