<?php
/**
 * MalwareScan View para el Componente Securitycheckpro
 * @ author Jose A. Luque
 * @ Copyright (c) 2011 - Jose A. Luque
 *
 * @license GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
// Chequeamos si el archivo est incluido en Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.view');
jimport('joomla.plugin.helper');

/**
 * FilesIntegrity View
 */
class SecuritycheckprosViewMalwareScan extends JViewLegacy
{

    protected $state;

    function display($tpl = null)
    {
        JToolBarHelper::title(JText::_('Securitycheck Pro').' | ' .JText::_('COM_SECURITYCHECKPRO_MALWARESCAN'), 'securitycheckpro');

        // Obtenemos los datos del modelo
        $model = $this->getModel("filemanager");
        $last_check_malwarescan = $model->loadStack("malwarescan_resume", "last_check_malwarescan");
        $files_scanned_malwarescan = $model->loadStack("malwarescan_resume", "files_scanned_malwarescan");
        $suspicious_files = $model->loadStack("malwarescan_resume", "suspicious_files");
		$time_taken = $model->loadStack("malwarescan_resume", "time_taken");
        $this->log_filename = $model->get_log_filename("filemalware_log", true);

        $task_ended = $model->get_campo_filemanager("estado_malwarescan");

        // Establecemos el tamao mximo de memoria que el script puede consumir
        $params = JComponentHelper::getParams('com_securitycheckpro');
        $deep_scan_status = $params->get('deep_scan', 0);
        $online_submission_type = $params->get('online_submission_type', 'Hashes');
        $timeline = $params->get('timeline', 7);
		$this->file_manager_include_exceptions_in_database = $params->get('file_manager_include_exceptions_in_database', 0);
		// Consultamos dnde han de ir los 'checkboxes'
		$this->checkbox_position = $params->get('checkbox_position','0');

        if ($deep_scan_status) {
            $deep_scan_status = JText::_('COM_SECURITYCHECKPRO_PLUGIN_ENABLED');
        } else
        {
            $deep_scan_status = JText::_('COM_SECURITYCHECKPRO_PLUGIN_DISABLED');
        }


        // Ponemos los datos en el template
        $this->last_check_malwarescan = $last_check_malwarescan;
        $this->files_scanned_malwarescan = $files_scanned_malwarescan;
        $this->suspicious_files =  $suspicious_files; 
        $this->deep_scan_status = $deep_scan_status;
        $this->online_submission_type = $online_submission_type;
        $this->timeline = $timeline;
		$this->time_taken = $time_taken;

        // Informacin para la barra de navegacin
        $logs_pending = $model->LogsPending();
        $trackactions_plugin_exists = $model->PluginStatus(8);
        $this->logs_pending = $logs_pending;
        $this->trackactions_plugin_exists = $trackactions_plugin_exists;

        // Malwarescanstatus

        // Filtro por tipo de extensin
        $this->state= $model->getState();
        $malwarescan_search = $this->state->get('filter.malwarescan_search');
        $filter_malwarescan_status = $this->state->get('filter.malwarescan_status');

        // Establecemos el valor del filtro 'malwarescan_status' a cero para que muestre slo los archivos sospechosos
        if ($filter_malwarescan_status == '') {
            $this->state->set('filter.malwarescan_status', 0);
        }

        $items = $model->loadStack("malwarescan", "malwarescan");
        $online_checked_files = $model->get_campo_filemanager("online_checked_files");
        $online_checked_hashes = $model->get_campo_filemanager("online_checked_hashes");
        $show_all = $this->state->get('showall', 0);
        $database_error = $model->get_campo_filemanager("estado_malwarescan");

        // Consultamos los valores de configuracin
        $params = JComponentHelper::getParams('com_securitycheckpro');
        $opswat_key = $params->get('opswat_key', '');
        $online_submission_type = $params->get('online_submission_type', 'Hashes');
        // Ponemos los datos en el template
        $this->items = $items;
        $this->online_checked_files = $online_checked_files;
        $this->online_checked_hashes = $online_checked_hashes;
        $this->show_all = $show_all;
        $this->database_error = $database_error;
        $this->opswat_key = $opswat_key;
        $this->online_submission_type = $online_submission_type;

        if (!empty($items)) {
            $pagination = $model->getPagination();
            $this->pagination = $pagination;
            JToolBarHelper::custom('manage_online_logs', 'folder-2 ', 'folder-2 ', 'COM_SECURITYCHECKPRO_MANAGE_ONLINE_LOGS', false);
            JToolBarHelper::custom('csv_export_malware', 'out-2', 'out-2', 'COM_SECURITYCHECKPRO_EXPORT_INFO_CSV', false);
            JToolBarHelper::custom('delete_file', 'delete', 'delete', 'COM_SECURITYCHECKPRO_DELETE');
            JToolBarHelper::custom('view_file', 'eye-open', 'eye-open', 'COM_SECURITYCHECKPRO_VIEW_FILE');
        }

        parent::display($tpl);
    }
}
