<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die ;

jimport('joomla.form.formfield');

/**
 *
 * @author Olivier Buisard
 *
 * for Joomla 3+ ONLY
 *
 */
class JFormFieldSYWColorPicker extends JFormField
{
	public $type = 'SYWColorPicker';

	protected $use_global;
	protected $allow_transparency;
	protected $icon;
	protected $help;
	protected $rgba;

	protected function getInput()
	{
		$doc = JFactory::getDocument();

		$lang = JFactory::getLanguage();
		$lang->load('lib_syw.sys', JPATH_SITE);

		JHtml::_('bootstrap.tooltip');

		$html = '';

		$color = strtolower($this->value);

		if (!$color || in_array($color, array('none', 'transparent'))) {
			$color = '';
		} else if (!$this->rgba && $color['0'] != '#') {
			$color = '#'.$color;
		}

		$direction = $lang->isRtl() ? ' dir="ltr" style="text-align:right"' : '';

		if (version_compare(JVERSION, '3.7.0', 'lt')) {
			JHtml::_('behavior.colorpicker');
		} else {
			JHtml::_('jquery.framework');
			JHtml::_('script', 'system/html5fallback.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
			JHtml::_('script', 'jui/jquery.minicolors.min.js', array('version' => 'auto', 'relative' => true));
			JHtml::_('stylesheet', 'jui/jquery.minicolors.css', array('version' => 'auto', 'relative' => true));
			JHtml::_('script', 'system/color-field-adv-init.min.js', array('version' => 'auto', 'relative' => true));
		}

		$icon = isset($this->icon) ? $this->icon : '';
		if (!empty($icon)) {
			JHtml::_('stylesheet', 'syw/fonts-min.css', false, true);
		}

		$overall_class = empty($icon) ? '' : ' input-prepend';
		$overall_class .= ($this->allow_transparency || $this->use_global) ? ' input-append' : '';

		$html .= '<div class="colorpicker'.$overall_class.'">';

		if (!empty($icon)) {
			$html .= '<div class="add-on"><i class="'.$icon.'"></i></div>';
		}

		$data_rgba = '';
		if ($this->rgba) {
		    $data_rgba = ' data-format="rgba" style="width: auto"';
		}

		if (!$this->allow_transparency && !$this->use_global) {
		    $html .= '<input type="text" name="'.$this->name.'" id="'.$this->id.'"'.' value="'.htmlspecialchars($color, ENT_COMPAT, 'UTF-8').'"'.' class="minicolors"'.$direction.$data_rgba.' />';
		} else {
			$disabled = '';
			if (empty($this->value) && $this->use_global) {
				$disabled = ' disabled';
			}

			$html .= '<input type="hidden" name="'.$this->name.'" id="'.$this->id.'"'.' data-name="input-color" value="'.htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8').'" />';
			$html .= '<input style="height:auto" type="text" name="visible_'.$this->name.'" id="visible_'.$this->id.'"'.' data-name="visible-input-color" value="'.htmlspecialchars($color, ENT_COMPAT, 'UTF-8').'"'.' class="minicolors"'.$direction.$data_rgba.$disabled.' />';
		}

		if ($this->use_global) {
			$class = 'btn hasTooltip';
			if (empty($this->value)) {
				$class .= ' btn-primary active';
			}
			$html .= '<a id="global_'.$this->id.'" data-name="global" class="'.$class.'" title="'.JText::_('JGLOBAL_USE_GLOBAL').'" href="#" onclick="return false;">';
			$html .= '<span>'.JText::_('JGLOBAL_USE_GLOBAL').'</span>';
			$html .= '</a>';
		}

		if ($this->allow_transparency) {
			$html .= '<a id="a_'.$this->id.'" data-name="clear" class="btn hasTooltip" title="'.JText::_('JCLEAR').'" href="#" aria-label="' . JText::_('JCLEAR') . '" onclick="return false;">';
			$html .= '<i class="icon-remove"></i>';
			$html .= '</a>';
		}

		$html .= '</div>';

		if ($this->help) {
			$html .= '<span class="help-block">'.JText::_($this->help).'</span>';
		}

		if ($this->allow_transparency || $this->use_global) {
			$script = 'jQuery(document).ready(function (){';

			$script .= 'jQuery("#visible_'.$this->id.'").change(function() { jQuery("#'.$this->id.'").val(jQuery("#visible_'.$this->id.'").val()) });';
			$script .= 'jQuery("#visible_'.$this->id.'").parent().find("span").first().children(".minicolors-panel").click(function() { jQuery("#visible_'.$this->id.'").change() });';
			$script .= 'jQuery("#visible_'.$this->id.'").next(".minicolors-panel").mouseup(function() { setTimeout(function(){ jQuery("#'.$this->id.'").val(jQuery("#visible_'.$this->id.'").val());}, 500); });';

			if ($this->use_global) {
				$script .= 'jQuery("#global_'.$this->id.'").click(function() {';
				$script .= 'jQuery("#visible_'.$this->id.'").parent().find("span").first().children().css("background-color","transparent");';
				$script .= 'if (jQuery("#global_'.$this->id.'").hasClass("btn-primary")) { jQuery("#global_'.$this->id.'").removeClass("btn-primary") } else { jQuery("#global_'.$this->id.'").addClass("btn-primary"); }';
				$script .= 'if (jQuery("#global_'.$this->id.'").hasClass("active")) { jQuery("#global_'.$this->id.'").removeClass("active") } else { jQuery("#global_'.$this->id.'").addClass("active"); }';
				if ($this->allow_transparency) {
					$script .= 'if (jQuery("#global_'.$this->id.'").hasClass("btn-primary")) { jQuery("#visible_'.$this->id.'").val(""); jQuery("#'.$this->id.'").val(""); jQuery("#visible_'.$this->id.'").prop("disabled", true) } else { jQuery("#'.$this->id.'").val("transparent"); jQuery("#visible_'.$this->id.'").prop("disabled", false) }';
				} else {
					$script .= 'if (jQuery("#global_'.$this->id.'").hasClass("btn-primary")) { jQuery("#visible_'.$this->id.'").val(""); jQuery("#'.$this->id.'").val(""); jQuery("#visible_'.$this->id.'").prop("disabled", true) } else { jQuery("#visible_'.$this->id.'").val("#ffffff"); jQuery("#'.$this->id.'").val("#ffffff"); jQuery("#visible_'.$this->id.'").parent().find("span").first().children().css("background-color","#ffffff"); jQuery("#visible_'.$this->id.'").prop("disabled", false) }';
				}
				$script .= '});';
			}

			if ($this->allow_transparency) {
				$script .= 'jQuery("#a_'.$this->id.'").click(function() {';
					$script .= 'jQuery("#visible_'.$this->id.'").parent().find("span").first().children().css("background-color","transparent");';
					$script .= 'jQuery("#visible_'.$this->id.'").val("");';
					$script .= 'jQuery("#'.$this->id.'").val("transparent");';
				$script .= '});';
			}
			
			// for inclusion in subforms
			
			$script .= 'jQuery(document).on("subform-row-add", function(event, row) { ';
			
			$script .= 'var visible = jQuery(row).find(".colorpicker input[data-name=visible-input-color]");';
			$script .= 'var invisible = jQuery(row).find(".colorpicker input[data-name=input-color]");';
			
			$script .= 'visible.change(function() { invisible.val(visible.val()) });';
			$script .= 'visible.parent().find("span").first().children(".minicolors-panel").click(function() { visible.change() });';
			$script .= 'visible.next(".minicolors-panel").mouseup(function() { setTimeout(function(){ invisible.val(visible.val());}, 500); });';
			
			// no need to add code for global button, it is an unused use case
			
			if ($this->allow_transparency) {
				$script .= 'jQuery(row).find(".colorpicker a[data-name=clear]").click(function() {';
					$script .= 'jQuery(row).find(".colorpicker input[data-name=visible-input-color]").parent().find("span").first().children().css("background-color","transparent");';
					$script .= 'jQuery(row).find(".colorpicker input[data-name=visible-input-color]").val("");';
					$script .= 'jQuery(row).find(".colorpicker input[data-name=input-color]").val("transparent");';
				$script .= '});';
			}
			
			$script .= '}); ';

			$script .= '});';

			$doc->addScriptDeclaration($script);
		}

		return $html;
	}

	public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		$return = parent::setup($element, $value, $group);

		if ($return) {
			$this->use_global = ((string)$this->element['global'] == "true" || (string)$this->element['useglobal'] == "true") ? true : false;
			$this->allow_transparency = isset($this->element['transparency']) ? filter_var($this->element['transparency'], FILTER_VALIDATE_BOOLEAN) : false;
			$this->icon = isset($this->element['icon']) ? (string)$this->element['icon'] : null;
			$this->help = isset($this->element['help']) ? (string)$this->element['help'] : '';
			$this->rgba = ((string)$this->element['rgba'] == "true") ? true : false;
		}

		return $return;
	}

}
?>
