<?php
/*
* @ author Jose A. Luque
* @ Copyright (c) 2011 - Jose A. Luque
* @license GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
*/
defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Plugin\CMSPlugin as JPlugin;
use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;

class plgSystemSecuritycheckpro_update_database extends JPlugin{

// Variable que contendr el tipo de componente de securitycheck instalado 
private $securitycheck_type = 'Not_defined';
// Variable que almacena la tabla en la que insertar las nuevas vulnerabilidades
private $vuln_table = 'Not_defined';

/* Chequea qu tipo de componente de securitycheck est instalado */
function check_securitycheck_type() {

	$db = JFactory::getDbo();
	
	// Consultamos si est instalada la versin Pro
	$query = $db->getQuery(true)
		->select('COUNT(*)')
		->from($db->quoteName('#__extensions'))
		->where($db->quoteName('name').' = '.$db->quote('System - Securitycheck pro'));
	$db->setQuery($query);
	$result = $db->loadResult();
	
	// La extensin Pro est instalada; actualizamos la variable $securitycheck_type y $table
	if ( !(empty($result)) && ($result == '1') ) {
		$this->securitycheck_type = 'com_securitycheckpro';
		$this->vuln_table = '#__securitycheckpro_db';
	} else {
		
		// Consultamos si est instalada la versin free
		$query = $db->getQuery(true)
			->select('COUNT(*)')
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('name').' = '.$db->quote('System - Securitycheck'));
		$db->setQuery($query);
		$result = $db->loadResult();
		
		// La extensin free est instalada; actualizamos la variable $securitycheck_type y $table
		if ( !(empty($result)) && ($result == '1') ) {
			$this->securitycheck_type = 'com_securitycheck';
			$this->vuln_table = '#__securitycheck_db';
		}	
	}
	
	// Si hay algn componente instalado, chequeamos su versin. Este plugin slo funciona a partir de la versin 2.7.3
	if ( $this->securitycheck_type != 'Not_defined' ) {
		// Obtenemos el nombre del fichero xml a partir de la variable 'securitycheck_type'
		$filename = substr($this->securitycheck_type,4);
		$version = '0.0.0';
		
		$xmlfile = JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . $this->securitycheck_type . DIRECTORY_SEPARATOR . $filename . '.xml';
		$xml = simplexml_load_file($xmlfile);
				
		foreach ($xml as $key => $value) {
			if ($key == 'version') {
				// Convertimos el par clave - valor en un string para poder manejarlo...
				(string) $valores = $key . "#" . $value;
				$valores = explode("#",$valores);
					
				// ... y lo asignamos a la variable
				$version = $valores[1];
			}	
		}
			
		// Si la versin instalada no cumple los requisitos, mostramos un mensaje de error y actualizamos la variable 'securitycheck_type'
		// A eliminar en un futuro
			
		/* Cargamos el lenguaje de plugin */
		$lang = JFactory::getLanguage();
		$lang->load('plg_system_securitycheckpro_update_database',JPATH_ADMINISTRATOR);
			
		if ( version_compare($version, '2.7.3', 'lt') ) {
			$application = JFactory::getApplication();
			$application->enqueueMessage($lang->_('COM_SECURITYCHECKPRO_VERSION_NOT_VALID'), 'error');
			$this->securitycheck_type = 'Not_defined';				
		} 		
	}
	
	
}

function onUserLogin(){
	
	// Chequeamos el tipo de componente instalado
	$this->check_securitycheck_type();
	
	// Importamos las libreras necesarias
	JLoader::import('joomla.application.component.model');
	
	// Segn el tipo de instalacin, la ubicacin de la librera vara
	if ( $this->securitycheck_type == 'com_securitycheckpro' ) {
		JLoader::import('databaseupdates', JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR. 'com_securitycheckpro' . DIRECTORY_SEPARATOR . 'helpers');
		if ( version_compare(JVERSION, '3.0', 'ge') ) {
			$update_model = JModelLegacy::getInstance( 'databaseupdates', 'SecuritycheckprosModel');
		} else {
			$update_model = JModel::getInstance( 'databaseupdates', 'SecuritycheckprosModel');
		}
	} else if ( $this->securitycheck_type == 'com_securitycheck' ) {
		JLoader::import('databaseupdates', JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR. 'com_securitycheck' . DIRECTORY_SEPARATOR . 'helpers');
		if ( version_compare(JVERSION, '3.0', 'ge') ) {
			$update_model = JModelLegacy::getInstance( 'databaseupdates', 'SecuritychecksModel');
		} else {
			$update_model = JModel::getInstance( 'databaseupdates', 'SecuritychecksModel');
		}
	} else {
		// Si no hay ningn componente instalado terminamos el script
		return;
	}
	
		
	// Comprobamos si existen nuevas actualizaciones
	$update_model->check_for_updates();
			
}

}