<?php
/**
 * @package DJ-Tabs
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email: contact@dj-extensions.com
 */

defined('_JEXEC') or die();
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
class JFormFieldDJType extends FormField
{
    protected $type = 'DJType';

    protected function getInput()
    {
        $types[] = HTMLHelper::_('select.option', 2, Text::_('COM_DJTABS_TYPE_SINGLE_ARTICLE'));
        $types[] = HTMLHelper::_('select.option', 1, Text::_('COM_DJTABS_TYPE_ARTICLE_CATEGORY'));
        $types[] = HTMLHelper::_('select.option', 3, Text::_('COM_DJTABS_TYPE_MODULE_POSITION'));
        $types[] = HTMLHelper::_('select.option', 4, Text::_('COM_DJTABS_TYPE_VIDEO_LINK'));

        if(ComponentHelper::isInstalled('com_k2'))
        {
            $types[] = HTMLHelper::_('select.option', 6, Text::_('COM_DJTABS_TYPE_K2_SINGLE_ARTICLE'));
            $types[] = HTMLHelper::_('select.option', 5, Text::_('COM_DJTABS_TYPE_K2_ARTICLE_CATEGORY'));
        }

        $types[] = HTMLHelper::_('select.option', 7, Text::_('COM_DJTABS_TYPE_CUSTOM'));

        $html = HTMLHelper::_('select.genericlist', $types, $this->name, 'class="inputbox form-select"', 'value', 'text', $this->value);

        return $html;
    }

}
?>