<?php

/**
 * @copyright
 * @package    EJB PRO - Easy Joomla Backup PRO for Joomla! 5.x
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.0.1.0-PRO - 2024-01-29
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\{HTML\HTMLHelper, Router\Route, Language\Text, Uri\Uri};
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Helper\EasyJoomlaBackupHelper;

HTMLHelper::_('jquery.framework');
HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('behavior.multiselect');
$this->document->getWebAssetManager()->useScript('table.columns');
?>
<script type="text/javascript">
    jQuery(document).ready(function() {
        jQuery('a.uploadArchive').click(function(e) {
            e.preventDefault();
            jQuery('#loadingUpload').fadeIn('slow', 'linear');

            if (jQuery(this).attr('href') === undefined) {
                return;
            }

            let requestUrl = jQuery(this).attr('href') + '&format=json';
            jQuery('a.uploadArchive').removeAttr('href');
            jQuery.getJSON(requestUrl + '&format=json')
                .done(function(data) {
                    window.location.href = data.data.redirectUrl;
                })
        });
    });
</script>
<form action="<?php echo Route::_('index.php?option=com_easyjoomlabackup'); ?>" method="post" name="adminForm" id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <div class="js-stools-container-bar">
                    <div class="js-stools" role="search">
                        <div id="filter-bar" class="btn-toolbar">
                            <div class="filter-search btn-group">
                                <div class="input-group">
                                    <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="form-control hasTooltip" title="<?php echo Text::_('JSEARCH_FILTER'); ?>"/>
                                    <span class="visually-hidden">
                                    <label for="filter_search" class="element-invisible">
                                        <?php echo Text::_('JSEARCH_FILTER'); ?>
                                    </label>
                                    </span>
                                    <button type="submit" class="btn btn-primary" aria-label="<?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>">
                                        <span class="icon-search" aria-hidden="true"></span>
                                    </button>
                                </div>
                            </div>
                            <div class="btn-group">
                                <button type="button" class="btn btn-primary js-stools-btn-clear" onclick="document.getElementById('filter_search').value = ''; this.form.submit();">
                                    <?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?>
                                </button>
                            </div>
                            <div class="btn-group pull-right hidden-phone">
                                <label for="limit" class="element-invisible">
                                    <?php echo Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?>
                                </label>
                                <?php echo $this->pagination->getLimitBox(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <p id="loadingUpload" style="display: none; text-align: center;">
                    <img src="<?php echo Uri::base(); ?>components/com_easyjoomlabackup/src/Assets/Images/loading.gif" style="float: none;" alt="Loading..."/><br/><br/>
                    <?php echo Text::_('COM_EASYJOOMLABACKUP_CHECKPROCESSWAIT_UPLOAD'); ?>
                </p>
                <table id="easyJoomlaBackupList" class="table itemList">
                    <thead>
                    <tr>
                        <th>
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)"/>
                        </th>
                        <th scope="col" class="w-20">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_DATE'); ?>
                        </th>
                        <th scope="col" class="w-25">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_COMMENT'); ?>
                        </th>
                        <th scope="col" class="w-10 text-center">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_TYPE'); ?>
                        </th>
                        <th scope="col" class="w-10 text-center">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_SIZE'); ?>
                        </th>
                        <th scope="col" class="w-7 text-center">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_DURATION'); ?>
                        </th>
                        <th scope="col" class="w-25">
                            <?php echo Text::_('COM_EASYJOOMLABACKUP_DOWNLOAD'); ?>
                        </th>
                        <?php if (in_array(true, $this->uploadAllowed, true)) : ?>
                            <th scope="col">
                                <?php echo Text::_('COM_EASYJOOMLABACKUP_UPLOAD'); ?>
                            </th>
                        <?php endif; ?>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $k = 0; ?>
                    <?php $n = count($this->items); ?>
                    <?php for ($i = 0; $i < $n; $i++) : ?>
                        <?php $row = $this->items[$i]; ?>
                        <?php $checked = HTMLHelper::_('grid.id', $i, $row->id, false, 'id'); ?>
                        <?php $download = Route::_('index.php?option=com_easyjoomlabackup&controller=Create&task=download&id=' . $row->id); ?>
                        <tr class="<?php echo 'row' . $k; ?>">
                            <td class="small text-center">
                                <?php echo $checked; ?>
                            </td>
                            <td class="small">
                                <span class="hasTooltip" title="<?php echo $row->date; ?>">
                                    <?php echo HTMLHelper::_('date', $row->date, Text::_('DATE_FORMAT_LC2')); ?>
                                </span>
                            </td>
                            <td class="small">
                                <span class="hasTooltip" title="<?php echo htmlspecialchars($row->comment); ?>">
                                    <?php if (strlen($row->comment) > 200) : ?>
                                        <?php echo mb_substr($row->comment, 0, 200) . '...'; ?>
                                    <?php else : ?>
                                        <?php echo $row->comment; ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td class="small text-center">
                                <span class="hasTooltip" title="<?php echo htmlspecialchars($row->type); ?>">
                                    <?php if ($row->type === 'fullbackup') : ?>
                                        <?php echo Text::_('COM_EASYJOOMLABACKUP_FULLBACKUP'); ?>
                                    <?php elseif ($row->type === 'databasebackup') : ?>
                                        <?php echo Text::_('COM_EASYJOOMLABACKUP_DATABASEBACKUP'); ?>
                                    <?php elseif ($row->type === 'filebackup') : ?>
                                        <?php echo Text::_('COM_EASYJOOMLABACKUP_FILEBACKUP'); ?>
                                    <?php elseif ($row->type === 'discovered') : ?>
                                        <?php echo Text::_('COM_EASYJOOMLABACKUP_DISCOVERED_ARCHIVE'); ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td class="small text-center">
                                <span class="hasTooltip" title="<?php echo htmlspecialchars($row->size); ?>">
                                    <?php if ($row->size > 1048576) : ?>
                                        <?php echo number_format($row->size / 1048576, 2, ',', '.') . ' MB'; ?>
                                    <?php else : ?>
                                        <?php echo number_format($row->size / 1024, 2, ',', '.') . ' KB'; ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td class="small text-center">
                                <span class="hasTooltip" title="<?php echo htmlspecialchars($row->duration); ?>">
                                    <?php if ($row->duration > 60) : ?>
                                        <?php echo floor((int)$row->duration / 60) . ' m ' . ((int)$row->duration % 60) . ' s'; ?>
                                    <?php elseif ((int)$row->duration > 0) : ?>
                                        <?php echo $row->duration . ' s'; ?>
                                    <?php else : ?>
                                        <?php echo Text::_('COM_EASYJOOMLABACKUP_UNKNOWN'); ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td class="small">
                                <span class="hasTooltip" title="<?php echo htmlspecialchars($row->name); ?>">
                                    <?php if ($this->downloadAllowed === true) : ?>
                                        <a href="<?php echo $download; ?>">
                                            <span class="icon-download"></span>
                                            <?php if (strlen($row->name) > 100) : ?>
                                                <?php echo substr($row->name, 0, 100) . '...'; ?>
                                            <?php else : ?>
                                                <?php echo $row->name; ?>
                                            <?php endif; ?>
                                        </a>
                                    <?php else : ?>
                                        <?php echo $row->name; ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <?php if (in_array(true, $this->uploadAllowed, true)) : ?>
                                <td class="small upload">
                                    <?php if ($this->uploadAllowed['dropbox']) : ?>
                                        <?php $dropboxUpload = Route::_('index.php?option=com_easyjoomlabackup&controller=Create&task=dropboxUpload&id=' . $row->id); ?>
                                        <span class="hasTooltip" title="<?php echo Text::_('COM_EASYJOOMLABACKUP_UPLOAD_DROPBOX'); ?>">
                                            <a class="uploadArchive" href="<?php echo $dropboxUpload; ?>">
                                            <?php if (in_array($row->id, $this->uploadStatus['dropbox'], true)) : ?>
                                                <span class="icon-ok"></span>
                                            <?php else: ?>
                                                <span class="icon-upload"></span>
                                            <?php endif; ?>
                                                <?php echo Text::_('COM_EASYJOOMLABACKUP_DROPBOX'); ?>
                                            </a>
                                        </span>
                                    <?php endif; ?>
                                    <?php if ($this->uploadAllowed['dropbox'] && $this->uploadAllowed['sftp']) : ?>
                                        <br/>
                                    <?php endif; ?>
                                    <?php if ($this->uploadAllowed['sftp']) : ?>
                                        <?php $sftpUpload = Route::_('index.php?option=com_easyjoomlabackup&controller=Create&task=sftpUpload&id=' . $row->id); ?>
                                        <span class="hasTooltip" title="<?php echo Text::_('COM_EASYJOOMLABACKUP_UPLOAD_SFTP'); ?>">
                                            <a class="uploadArchive" href="<?php echo $sftpUpload; ?>">
                                                <?php if (in_array($row->id, $this->uploadStatus['sftp'], true)) : ?>
                                                    <span class="icon-ok"></span>
                                                <?php else: ?>
                                                    <span class="icon-upload"></span>
                                                <?php endif; ?>
                                                <?php echo Text::_('COM_EASYJOOMLABACKUP_SFTP'); ?>
                                            </a>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                        </tr>
                        <?php $k = 1 - $k; ?>
                    <?php endfor; ?>
                    </tbody>
                </table>
                <input type="hidden" name="option" value="com_easyjoomlabackup"/>
                <input type="hidden" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
</form>
<div class="footerCenter">
    <?php if (class_exists('ZipArchive')) : ?>
        <span class="text-success">
            <span class="icon-publish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_ZIPARCHIVE_ACTIVATED'); ?>
        </span>
    <?php else : ?>
        <span class="text-error">
            <span class="icon-unpublish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_ZIPARCHIVE_DEACTIVATED'); ?>
        </span>
    <?php endif; ?>
    <?php if ($this->dbType === 'mysqli') : ?>
        <span class="text-success">
            <span class="icon-publish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_DBTYPE_MYSQLI'); ?>
        </span>
    <?php else : ?>
        <span class="text-info">
            <span class="icon-unpublish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_DBTYPE_NOT_MYSQLI'); ?>
        </span>
    <?php endif; ?>
    <?php if ($this->sessionHandler === 'none' || $this->sessionHandler === 'filesystem') : ?>
        <span class="text-success">
            <span class="icon-publish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_SESSIONHANDLER_FILESYSTEM'); ?>
        </span>
    <?php else : ?>
        <span class="text-info">
            <span class="icon-unpublish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_SESSIONHANDLER_FILESYSTEM_NOT'); ?>
        </span>
    <?php endif; ?>
    <?php if ($this->backupStorageLocationWritable) : ?>
        <span class="text-success">
            <span class="icon-publish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_BACKUPSTORAGELOCATION_WRITABLE'); ?>
        </span>
    <?php else : ?>
        <span class="text-info">
            <span class="icon-unpublish"></span>
            <?php echo Text::_('COM_EASYJOOMLABACKUP_BACKUPSTORAGELOCATION_WRITABLE_NOT'); ?>
        </span>
    <?php endif; ?>
</div>
<div class="footerCenter">
    <?php if (isset($this->pluginCronjobState['enabled'], $this->pluginCronjobState['url_settings'])) : ?>
        <?php if ($this->pluginCronjobState['enabled'] === true) : ?>
            <span class="text-success">
				<span class="icon-publish"></span>
                <?php echo Text::sprintf('COM_EASYJOOMLABACKUP_PLUGIN_CRONJOB_ENABLED', $this->pluginCronjobState['url_settings']); ?>
            </span>
        <?php else : ?>
            <span class="text-info">
                <span class="icon-unpublish"></span>
                <?php echo Text::sprintf('COM_EASYJOOMLABACKUP_PLUGIN_CRONJOB_DISABLED', $this->pluginCronjobState['url_settings']); ?>
            </span>
        <?php endif; ?>
    <?php endif; ?>
    <?php if (isset($this->pluginCliState['enabled'], $this->pluginCliState['url_settings'])) : ?>
        <?php if ($this->pluginCliState['enabled'] === true) : ?>
            <span class="text-success">
				<span class="icon-publish"></span>
                <?php echo Text::sprintf('COM_EASYJOOMLABACKUP_PLUGIN_CLI_ENABLED', $this->pluginCliState['url_settings']); ?>
            </span>
        <?php else : ?>
            <span class="text-info">
                <span class="icon-unpublish"></span>
                <?php echo Text::sprintf('COM_EASYJOOMLABACKUP_PLUGIN_CLI_DISABLED', $this->pluginCliState['url_settings']); ?>
            </span>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php echo EasyJoomlaBackupHelper::getFooter(); ?>
