<?php
namespace JExtstore\Component\Gdpr\Administrator\Table;
/**
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage tables
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Filter\OutputFilter;
use Joomla\String\StringHelper;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception\Exceptions;

/**
 * Tracking of links redirected by the plugin
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage tables
 * @since 1.6
 */
class CheckboxTable extends Table {
	use Exceptions;
	
	/**
	 * @public int Primary key
	 */
	public $id = null;
	
	/**
	 * @public string
	 */
	public $placeholder = null;
	
	/**
	 * @public string
	 */
	public $name = null;
	
	/**
	 * @public string
	 */
	public $descriptionhtml = null;
	
	/**
	 * @public string
	 */
	public $formselector = null;
	
	/**
	 * @var int
	 */
	public $required = 0;
	
	/**
	 * @var int
	 */
	public $checked_out = null;
	
	/**
	 * @var datetime
	 */
	public $checked_out_time = null;
	
	/**
	 * @var int
	 */
	public $published = 1;
	
	/**
	 * @var int
	 */
	public $access = 1;
	
	/**
	 * Store Table override
	 * @override
	 *
	 * @see JTable::store()
	 */
	public function store($updateNulls = false) {
		// Name required
		if (! $this->name) {
			$this->setException ( Text::_('COM_GDPR_VALIDATION_ERROR' ) );
			return false;
		}
		
		if(StringHelper::strpos($this->descriptionhtml, 'COM_GDPR_') !== false) {
			$this->descriptionhtml = strip_tags($this->descriptionhtml);
		}
		
		$result = parent::store($updateNulls);
	
		// If store sucessful go on to popuplate relations table for sources/datasets
		if($result) {
			// Manage multiple tuples to be inserted using single query
			$queryPlaceholder = "UPDATE" .
							    "\n " . $this->_db->quoteName('#__gdpr_checkbox') .
							    "\n SET " . $this->_db->quoteName('placeholder') . " = " .
								$this->_db->quote('{' . OutputFilter::stringUrlUnicodeSlug($this->name) . '-' . $this->id . '}') .
								"\n WHERE " . $this->_db->quoteName('id') . " = " . (int)$this->id;
			if(!$this->_db->setQuery($queryPlaceholder)->execute()) {
				$this->setException( Text::_('COM_GDPR_ERROR_SAVING' ) );
				return false;
			}
		}
	
		return $result;
	}
	
	/**
	 * Class constructor
	 * @param DatabaseDriver $db DatabaseDriver object.
	 * @param DispatcherInterface  $dispatcher  Event dispatcher for this table
	 *
	 * return Object&
	 */
	public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null) {
		parent::__construct ( '#__gdpr_checkbox', 'id', $db, $dispatcher );
		
		// Support null values for datetime field
		$this->_supportNullValue = true;
	}
}