<?php
namespace JExtstore\Component\Gdpr\Administrator\Table;
/**
 *
 * @package GDPR::CONSENTS::administrator::components::com_gdpr
 * @subpackage tables
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Table\Table;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception\Exceptions;

/**
 * Tracking of links redirected by the plugin
 *
 * @package GDPR::CONSENTS::administrator::components::com_gdpr
 * @subpackage tables
 * @since 1.6
 */
class ConsentsTable extends Table {
	use Exceptions;
	
	/**
	 * @public int Primary key
	 */
	public $id = null;
	
	/**
	 * @public string
	 */
	public $url = null;
	
	/**
	 * @public string
	 */
	public $formid = null;
	
	/**
	 * @public string
	 */
	public $formname = null;
	
	/**
	 * @public int
	 */
	public $user_id = 0;
	
	/**
	 * @public string
	 */
	public $session_id = null;
	
	/**
	 * @public string
	 */
	public $consent_date = null;
	
	/**
	 * @public string
	 */
	public $formfields = null;

	/**
	 * Class constructor
	 * @param DatabaseDriver $db DatabaseDriver object.
	 * @param DispatcherInterface  $dispatcher  Event dispatcher for this table
	 *
	 * return Object&
	 */
	public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null) {
		parent::__construct ( '#__gdpr_consent_registry', 'id', $db, $dispatcher );
	}
}