<?php
namespace JExtstore\Component\Gdpr\Administrator\View\Cookiedescriptions;
/**
 * @package GDPR::CHECKBOX::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage checkbox
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
use Joomla\CMS\Pagination\Pagination;
use Joomla\Filter\OutputFilter;
use JExtstore\Component\Gdpr\Administrator\Framework\View as GdprView;
use JExtstore\Component\Gdpr\Administrator\Framework\Helpers\Toolbars as ToolbarHelper;

/**
 * @package GDPR::CHECKBOX::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage checkbox
 * @since 1.9.2
 */
class HtmlView extends GdprView {
	// Template view variables
	protected $pagination;
	protected $searchword;
	protected $search_editorword;
	protected $orders;
	protected $dates;
	protected $lists;
	protected $items;
	protected $componentConfig;
	protected $record;
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addDisplayToolbar() {
		$user = $this->app->getIdentity();
		ToolbarHelper::title( Text::_('COM_GDPR_COOKIEDESCRIPTIONS_TITLE' ), 'gdpr' );
	
		// Access check.
		if ($user->authorise('core.create', 'com_gdpr')) {
			ToolbarHelper::addNew('cookiedescriptions.editEntity', 'COM_GDPR_NEW_COOKIEDESCRIPTIONS');
		}
		
		if ($user->authorise('core.edit', 'com_gdpr')) {
			ToolbarHelper::editList('cookiedescriptions.editEntity', 'COM_GDPR_EDIT_COOKIEDESCRIPTIONS');
		}
	
		if ($user->authorise('core.delete', 'com_gdpr') && $user->authorise('core.edit', 'com_gdpr')) {
			ToolbarHelper::deleteList('COM_GDPR_DELETE_ENTITY', 'cookiedescriptions.deleteEntity');
		}
		
		if ($user->authorise('core.edit', 'com_gdpr')) {
			ToolBarHelper::custom('cookiedescriptions.exportConfig', 'download', 'download', 'COM_GDPR_EXPORT_COOKIE_CONFIG', false);
			ToolBarHelper::custom('cookiedescriptions.importConfig', 'upload', 'upload', 'COM_GDPR_IMPORT_COOKIE_CONFIG', false);
			ToolBarHelper::custom('cookiedescriptions.importDefaultConfig', 'file', 'file', 'COM_GDPR_IMPORT_DEFAULT_COOKIE_CONFIG', false);
		}
			
		ToolbarHelper::custom('cpanel.display', 'home', 'home', 'COM_GDPR_CPANEL', false);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addEditEntityToolbar() {
		$user		= $this->app->getIdentity();
		$userId		= $user->id;
		$isNew		= ($this->record->id == 0);
		$checkedOut	= !($this->record->checked_out == 0 || $this->record->checked_out == $userId);
		$toolbarHelperTitle = $isNew ? 'COM_GDPR_COOKIEDESCRIPTIONS_NEW' : 'COM_GDPR_COOKIEDESCRIPTIONS_EDIT';
	
		$doc = $this->app->getDocument();
		ToolbarHelper::title( Text::_( $toolbarHelperTitle ), 'gdpr' );
	
		if ($isNew)  {
			// For new records, check the create permission.
			if ($isNew && ($user->authorise('core.create', 'com_gdpr'))) {
				ToolbarHelper::apply( 'cookiedescriptions.applyEntity', 'JAPPLY');
				ToolbarHelper::save( 'cookiedescriptions.saveEntity', 'JSAVE');
			}
		} else {
			// Can't save the record if it's checked out.
			if (!$checkedOut) {
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($user->authorise('core.edit', 'com_gdpr')) {
					ToolbarHelper::apply( 'cookiedescriptions.applyEntity', 'JAPPLY');
					ToolbarHelper::save( 'cookiedescriptions.saveEntity', 'JSAVE');
				}
			}
		}
			
		ToolbarHelper::custom('cookiedescriptions.cancelEntity', 'cancel', 'cancel', 'JCANCEL', false);
	}
	
	/**
	 * Default display listEntities
	 *        	
	 * @access public
	 * @param string $tpl
	 * @return void
	 */
	public function display($tpl = 'list') {
		// Get main records
		$rows = $this->get ( 'Data' );
		$total = $this->get ( 'Total' );
		$lists = $this->get ( 'Filters' );
		
		$doc = $this->app->getDocument();
		$this->loadJQuery($doc);
		$this->loadBootstrap($doc);
		$doc->getWebAssetManager()->registerAndUseScript('gdpr.fileconfig', 'administrator/components/com_gdpr/js/fileconfig.js', [], [], ['jquery']);
		
		// Load specific JS App
		$doc->getWebAssetManager()->addInlineScript("
				Joomla.submitbutton = function(pressbutton) {
					Joomla.submitform( pressbutton );
					if (pressbutton == 'cookiedescriptions.exportConfig') {
						jQuery('#adminForm input[name=task]').val('cookiedescriptions.display');
					}
					return true;
				};
			");
		
		// Inject js translations
		$translations = array(
				'COM_GDPR_REQUIRED',
				'COM_GDPR_PICKFILE',
				'COM_GDPR_STARTIMPORT',
				'COM_GDPR_CANCELIMPORT'
		);
		$this->injectJsTranslations($translations, $doc);
		
		$orders = array ();
		$orders ['order'] = $this->getModel ()->getState ( 'order' );
		$orders ['order_Dir'] = $this->getModel ()->getState ( 'order_dir' );
		// Pagination view object model state populated
		$pagination = new Pagination( $total, $this->getModel ()->getState ( 'limitstart' ), $this->getModel ()->getState ( 'limit' ) );
		$dates = array('start'=>$this->getModel()->getState('fromPeriod'), 'to'=>$this->getModel()->getState('toPeriod'));
		
		$this->user = $this->app->getIdentity ();
		$this->pagination = $pagination;
		$this->searchword = $this->getModel ()->getState ( 'searchword' );
		$this->search_editorword = $this->getModel ()->getState ( 'search_editorword' );
		$this->option = $this->getModel ()->getState ( 'option' );
		$this->orders = $orders;
		$this->dates = $dates;
		$this->lists = $lists;
		$this->items = $rows;
		$this->componentConfig = $this->getModel()->getComponentParams();
		
		// Aggiunta toolbar
		$this->addDisplayToolbar();
			
		parent::display ( $tpl );
	}
	
	/**
	 * Mostra la visualizzazione dettaglio del record singolo
	 * @param Object& $row
	 * @access public
	 */
	public function editEntity($row) {
		// Sanitize HTML Object2Form
		OutputFilter::objectHTMLSafe( $row );
	
		$doc = $this->app->getDocument();
		$this->loadJQuery($doc);
		$this->loadBootstrap($doc);
		$this->loadValidation($doc);
		
		$doc->getWebAssetManager()->addInlineScript("
					Joomla.submitbutton = function(pressbutton) {
						if(!jQuery.fn.validation) {
							jQuery.extend(jQuery.fn, gdprjQueryBackup.fn);
						}
		
						jQuery('#adminForm').validation();
		
						if (pressbutton == 'cookiedescriptions.cancelEntity') {
							jQuery('#adminForm').off();
							Joomla.submitform( pressbutton );
							return true;
						}
		
						if(jQuery('#adminForm').validate()) {
							Joomla.submitform( pressbutton );
							return true;
						}
						return false;
					};
				");
		
		$lists = $this->getModel()->getLists($row);
		$this->lists = $lists;
		$this->option = $this->getModel()->getState('option');
		$this->record = $row;
	
		// Add toolbar
		$this->addEditEntityToolbar();
		
		parent::display('edit');
	}
}