<?php
/**
 * @Securitycheckpro component
 * @copyright Copyright (c) 2011 - Jose A. Luque / Securitycheck Extensions
 * @license   GNU General Public License version 3, or later
 */
 
namespace SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\Model;

// Chequeamos si el archivo est includo en Joomla!
defined('_JEXEC') or die();

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Pagination\Pagination;
use SecuritycheckExtensions\Component\SecuritycheckPro\Administrator\Model\BaseModel;

/**
 * Modelo Securitycheck
 */
class RulesModel extends BaseModel
{

    /**
     * Objeto Pagination * @var object 
     */
    var $_pagination = null;

    /**
     * @var array Group list 
     */
    private $groups = array();

    /**
     * @var int Total number of files of Pagination 
     */
    var $total = 0;
	
    function __construct()
    {
        parent::__construct();
    
    
        $mainframe = Factory::getApplication();	
		    
        // Obtenemos las variables de paginacin de la peticin
        $limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $limitstart = $mainframe->input->get('limitstart', 0, 'int');

        // En el caso de que los lmites hayan cambiado, los volvemos a ajustar
        $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);
    }

    protected function populateState()
    {
        // Inicializamos las variables
        $app        = Factory::getApplication();
    
        $search = $app->getUserStateFromRequest('filter.acl_search', 'filter_acl_search');
        $this->setState('filter.acl_search', $search);
    
        parent::populateState();
    }

    /*  Funcin para la paginacin */
    function getPagination()
    {
        // Cargamos el contenido si es que no existe todava
        if (empty($this->_pagination)) {            
            $this->_pagination = new Pagination($this->total, $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_pagination;
    }

    /* Funcin para cargar los grupos del sistema */
    function load($data = null)
    {
        // Creamos un nuevo objeto query
        $db = $this->getDbo();
        $query = $db->getQuery(true);

        // Obtenemos los grupos de Joomla
        $query_groups = "SELECT * FROM #__usergroups";
        $db->setQuery($query_groups);
        $joomla_groups = $db->loadObjectList();
    
        // Actualizamos el nmero total de grupos
        $this->total = count($joomla_groups);
    
        // Timestamp
        $timestamp = $this->get_Joomla_timestamp();
    
        // Comprobamos si hay que aadir algn grupo a la tabla '#__securitycheckpro_rules'
        foreach ($joomla_groups as $element)
        {
            $array_val = get_object_vars($element);
            $group_id = (int) $array_val["id"];
            $title = $array_val["title"];
            $rules_applied = (int) 1;
                
            $query_rules = "SELECT * FROM #__securitycheckpro_rules WHERE group_id = " . $db->escape($group_id);
        
            $db->setQuery($query_rules);
            $element_exists = $db->loadObjectList();
        
            // Si no existe, lo aadimos
            if (empty($element_exists)) {
                  $valor = (object) array(
                 'group_id' => $group_id,
                 'rules_applied' => $rules_applied,
                 'last_change' =>  $timestamp,
                  );
                  $insert_result = $db->insertObject('#__securitycheckpro_rules', $valor, 'id');
            }
        }
    
        // Volvemos a construir la consulta
        $query->select('a.id, a.lft, a.rgt, a.parent_id, a.title, b.rules_applied, b.last_change');
        $query->from($db->quoteName('#__usergroups') . ' AS a');
        
        // Aadimos los niveles de cada grupo...
        $query->select('COUNT(DISTINCT c2.id) AS level')
            ->join('LEFT OUTER', $db->quoteName('#__usergroups') . ' AS c2 ON a.lft > c2.lft AND a.rgt < c2.rgt')
            ->group('a.id, b.group_id, a.lft, a.rgt, a.parent_id, a.title, b.rules_applied, b.last_change');
    
        // ... y si las reglas han de aplicarse
        $query->select('b.group_id, b.rules_applied, b.last_change')
            ->join('LEFT OUTER', $db->quoteName('#__securitycheckpro_rules') . ' AS b ON a.id = b.group_id');
        
        // Filtramos los comentarios de las bsquedas si existen
        $search = $this->getState('filter.acl_search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('a.id = ' . (int) substr($search, 3));
            }
            else
            {
                $search = $db->quote('%' . $db->escape($search, true) . '%');
                $query->where('a.title LIKE ' . $search);
            }
        }
    
        // Ordenamos la consulta
        $query->order($db->escape($this->getState('list.ordering', 'a.lft')) . ' ' . $db->escape($this->getState('list.direction', 'ASC')));
		$db->setQuery($query);
        $groups = $db->loadObjectList();
        
        //Obtenemos el nmero de registros del array que hemos de mostrar. Si el lmite superior es '0', entonces devolvemos todo el array
        $upper_limit = $this->getState('limitstart');
        $lower_limit = $this->getState('limit');
    
        // Devolvemos slo el contenido delimitado por la paginacin 
        $groups = array_splice($groups, $upper_limit, $lower_limit);
    
        return $groups;
    }


    /*  Funcin que cambia el estado de los grupos pasados como argumento. A dichos grupos se les aplicarn las reglas del Firewall. */
    function apply_rules()
    {
        $resultado = true;
    
        $jinput = Factory::getApplication()->input;
        $uids = $jinput->getVar('cid', '', 'array');
    
        // Timestamp
        $timestamp = $this->get_Joomla_timestamp();
    
        ArrayHelper::toInteger($uids, array());
        
        $db = $this->getDbo();
        foreach($uids as $uid) 
        {
            try 
            {
                  $sql = "UPDATE #__securitycheckpro_rules SET rules_applied=1,last_change='" .$timestamp ."' WHERE group_id='{$uid}'";
                  $db->setQuery($sql);
                  $db->execute();    
            } catch (Exception $e)
            {
                $resultado = false;
                break(1);
            }
        
        }

    
        return $resultado;
    }

    /*  Funcin que cambia el estado de los grupos pasados como argumento. A dichos grupos NO se les aplicarn las reglas del Firewall. */
    function not_apply_rules()
    {
        $resultado = true;
    
        $jinput = Factory::getApplication()->input;
        $uids = $jinput->getVar('cid', '', 'array');
    
        // Timestamp
        $timestamp = $this->get_Joomla_timestamp();
    
        ArrayHelper::toInteger($uids, array());
        
        $db = $this->getDbo();
        foreach($uids as $uid)
        {
            try 
            {
                  $sql = "UPDATE #__securitycheckpro_rules SET rules_applied=0,last_change='" .$timestamp ."' WHERE group_id='{$uid}'";
                  $db->setQuery($sql);
                  $db->execute();
            }    catch (Exception $e)
            {
                $resultado = false;
                break(1);
            }
        
        
        }

    
        return $resultado;
    }

}
