<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Categories\Categories;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\TagsHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Database\Exception\ExecutionFailureException;
use Joomla\Registry\Registry;
use SYW\Component\WeblinkLogosPro\Site\Helper\Helper;
use SYW\Library\Tags as SYWTags;
use SYW\Library\Text as SYWText;

/**
 * Weblinklogospro model: retrieving a list of weblinks
 */
class DirectoryModel extends ListModel
{
	protected $categories_string;
	protected $categories_list;

	protected $tags_selection;
	protected $tags_list;

	protected $field_filter_ids;

	//private $_total;

	/**
	 * Method to auto-populate the model state
	 *
	 * Note: calling getState in this method will result in recursion
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 * @return void
	 * @throws \Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = Factory::getApplication();

		// load the parameters
		$params = $app->getParams();

		// pagination request variables

		$pagination_limit_count = intVal($params->get('pag_l_c', ''));
		if ($pagination_limit_count > 0/* && !$params->get('s_pag_l', 1)*/) {
			$limit = $app->input->get('limit', $pagination_limit_count, 'uint');
		} else {
			$limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
		}

		$this->setState('list.limit', $limit);

		$firstuse = false;
		if ($app->input->getInt('limitstart') === null) {
			$firstuse = true;
		}

		//$limitstart = $app->getUserStateFromRequest('limitstart', 'limitstart', 0); // will keep the pagination page value when coming back from another page

		$limitstart = $app->input->getInt('limitstart', 0);

		// in case limit has been changed, adjust it
		//$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('list.start', $limitstart);

// 		if ($list = $app->getUserStateFromRequest($this->context . '.list', 'list', array(), 'array'))
// 		{
// 			foreach ($list as $name => $value)
// 			{
// 				// Extra validations
// 				switch ($name)
// 				{
// 					case 'fullordering':
// 						$orderingParts = explode(' ', $value);

// 						if (count($orderingParts) >= 2)
// 						{
// 							// Latest part will be considered the direction
// 							$fullDirection = end($orderingParts);

// 							if (in_array(strtoupper($fullDirection), array('ASC', 'DESC', '')))
// 							{
// 								$this->setState('list.direction', $fullDirection);
// 							}

// 							unset($orderingParts[count($orderingParts) - 1]);

// 							// The rest will be the ordering
// 							$fullOrdering = implode(' ', $orderingParts);

// 							if (in_array($fullOrdering, $this->filter_fields))
// 							{
// 								$this->setState('list.ordering', $fullOrdering);
// 							}
// 						}
// 						else
// 						{
// 							$this->setState('list.ordering', $ordering);
// 							$this->setState('list.direction', $direction);
// 						}
// 						break;

// 					case 'ordering':
// 						if (!in_array($value, $this->filter_fields))
// 						{
// 							$value = $ordering;
// 						}
// 						break;

// 					case 'direction':
// 						if (!in_array(strtoupper($value), array('ASC', 'DESC', '')))
// 						{
// 							$value = $direction;
// 						}
// 						break;

// 					case 'limit':
// 						$limit = $value;
// 						break;

// 						// Just to keep the default case
// 					default:
// 						$value = $value;
// 						break;
// 				}

// 				$this->setState('list.' . $name, $value);
// 			}
// 		}

		// Receive & set filters
// 		if ($filters = $app->getUserStateFromRequest($this->context . '.filter', 'filter', array(), 'array'))
// 		{
// 			foreach ($filters as $name => $value)
// 			{
// 				$this->setState('filter.' . $name, $value);
// 			}
// 		}

// 		$ordering = $app->input->get('filter_order');

// 		if (!empty($ordering))
// 		{
// 			$list             = $app->getUserState($this->context . '.list');
// 			$list['ordering'] = $app->input->get('filter_order');
// 			$app->setUserState($this->context . '.list', $list);
// 		}

// 		$orderingDirection = $app->input->get('filter_order_Dir');

// 		if (!empty($orderingDirection))
// 		{
// 			$list              = $app->getUserState($this->context . '.list');
// 			$list['direction'] = $app->input->get('filter_order_Dir');
// 			$app->setUserState($this->context . '.list', $list);
// 		}

// 		$list = $app->getUserState($this->context . '.list');

// 		if (empty($list['ordering']))
// 		{
// 			$list['ordering'] = 'ordering';
// 		}

// 		if (empty($list['direction']))
// 		{
// 			$list['direction'] = 'asc';
// 		}

// 		if (isset($list['ordering']))
// 		{
// 			$this->setState('list.ordering', $list['ordering']);
// 		}

// 		if (isset($list['direction']))
// 		{
// 			$this->setState('list.direction', $list['direction']);
// 		}

		// use the pre selected category only if we show a category index

        $field_index_array = array();
		$pre_selected_category = 'none';

		$filters = $params->get('top_filters', null);
		if (!empty($filters) && is_array($filters)) {
			foreach ($filters as $filter) {
			    switch ($filter['formfilter']) {
			        case 'a': case 't': break;
			        case 'c': $pre_selected_category = $params->get('preselect_cat', 'none'); break;
			        default:
			            $field_temp = explode(':', $filter['formfilter']);
			            $field_index_array[] = $field_temp[2];
			    }
			}
		}

		$filters = $params->get('bot_filters', null);
		if (!empty($filters) && is_array($filters)) {
			foreach ($filters as  $filter) {
			    switch ($filter['formfilter']) {
			        case 'a': case 't': break;
			        case 'c': $pre_selected_category = $params->get('preselect_cat', 'none'); break;
			        default:
			            $field_temp = explode(':', $filter['formfilter']);
			            $field_index_array[] = $field_temp[2];
			    }
			}
		}

		foreach (array_unique($field_index_array) as $field_index) {
		    $field = $app->input->getString('field_' . $field_index, '');
		    $this->setState('field_' . $field_index, $field);
		}

		//$pre_selected_category = $params->get('preselect_cat', 'none');
		if ($firstuse && $pre_selected_category != 'none') {
			$this->setState('category', $pre_selected_category);
			$app->input->set('category', $pre_selected_category);
		} else {
			$category = $app->input->getString('category', '');
			$this->setState('category', $category);
		}

		$tag = $app->input->getString('tag', '');
		$this->setState('tag', $tag);

		$search = $app->input->getString('filter-search', '');
		$this->setState('filter-search', $search);

		$match = $app->input->getString('filter-match', $params->get('search_default', 'any'));
		$this->setState('filter-match', $match);

		$this->setState('filter.language', Multilanguage::isEnabled() && $params->get('filter_lang', 1));

		$this->setState('params', $params);
	}

	/**
	 * Get all ids of the custom fields used as index filters
	 * @return array of ids
	 */
	protected function getFieldFilterIds()
	{
	    if (!isset($this->field_filter_ids)) {

	        $this->field_filter_ids = array();

	        $params = $this->getState('params');

	        $index_filters = array();

	        $filters = $params->get('top_filters', null);
	        if (!empty($filters) && is_array($filters)) {
	            foreach ($filters as $filter) {
	                $index_filters[] = $filter['formfilter'];
	            }
	        }

	        $filters = $params->get('bot_filters', null);
	        if (!empty($filters) && is_array($filters)) {
	            foreach ($filters as  $filter) {
	                $index_filters[] = $filter['formfilter'];
	            }
	        }

	        $index_filters = array_unique($index_filters);

	        foreach ($index_filters as $index_filter) {
	            if (strpos($index_filter, 'field') !== false) {
	                $field_temp = explode(':', $index_filter);
	                $this->field_filter_ids[] = $field_temp[2];
	            }
	        }
	    }
	    return $this->field_filter_ids;
	}

	/**
	 *
	 * {@inheritDoc}
	 * @see \Joomla\CMS\MVC\Model\ListModel::getListQuery()
	 */
	protected function getListQuery()
	{
		if ($this->getTagsSelection() === false) {
			return ''; // case where there are no weblink associated tags and 'all' tags was selected
		}

		$app = Factory::getApplication();

		// Create a new query object
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$user = Factory::getUser();
		$groups = implode(',', $user->getAuthorisedViewLevels());

		$params = $this->getState('params');

		// START OF DATABASE QUERY

		$case_when1 = ' CASE WHEN ';
		$case_when1 .= $query->charLength('a.alias', '!=', '0');
		$case_when1 .= ' THEN ';
		$a_id = $query->castAsChar('a.id');
		$case_when1 .= $query->concatenate(array($a_id, 'a.alias'), ':');
		$case_when1 .= ' ELSE ';
		$case_when1 .= $a_id . ' END as slug';

		$case_when2 = ' CASE WHEN ';
		$case_when2 .= $query->charLength('c.alias', '!=', '0');
		$case_when2 .= ' THEN ';
		$c_id = $query->castAsChar('c.id');
		$case_when2 .= $query->concatenate(array($c_id, 'c.alias'), ':');
		$case_when2 .= ' ELSE ';
		$case_when2 .= $c_id . ' END as catslug';

		$query->select('a.*,'.$case_when1.','.$case_when2);
		$query->select('c.title AS category_title, c.path AS category_route, c.access AS category_access, c.alias AS category_alias');
		$query->from($db->quoteName('#__weblinks', 'a'));
		$query->where($db->quoteName('a.access').' IN ('.$groups.')');

		// search filter

		$search_weblinks = $app->input->getString('filter-search', '') ? urldecode($app->input->getString('filter-search')) : $this->getState('filter-search');
		$search_weblinks = trim($search_weblinks);
		if ($search_weblinks) {

			$match = $app->input->getString('filter-match', 'any') ? $app->input->getString('filter-match') : $this->getState('filter-match');

			$search_weblinks_array = array();
			if ($match !== 'exact') {
				$search_weblinks_array = array_unique(explode(" ", $db->escape($search_weblinks)));
			} else {
				$search_weblinks_array[] = $db->escape($search_weblinks);
			}

			$match_condition = 'OR';
			if ($match === 'all') {
				$match_condition = 'AND';
			}

			$query_search = '(';
			$query_search .= '(a.title LIKE "%'.implode('%" ' . $match_condition . ' a.title LIKE "%', $search_weblinks_array).'%")';
			$query_search .= ' OR ';
			$query_search .= '(a.description LIKE "%'.implode('%" ' . $match_condition . ' a.description LIKE "%', $search_weblinks_array).'%")';
			$query_search .= ')';

			$query->where($query_search);

			$this->setState('filter-search', $search_weblinks);
		}

		// custom field filters

		$weblink_id_arrays_from_cfields = array(); // array of ids that have been found through the database requests
		$customfield_filters_arrays = array(); // custom fields to check

		// (through index)

		$field_index_array = $this->getFieldFilterIds(); // gets all ids of the custom fields used as index filters

		if (!empty($field_index_array)) {

		    foreach ($field_index_array as $field_index) {

		        if ($this->getState('field_' . $field_index)) {
		            $customfield_filters_arrays[] = array('id' => $field_index, 'values' => array($this->getState('field_' . $field_index)), 'inex' => 1);
		        }
		    }
		}

		// (through pre-selection)

		$customfield_filters = $params->get('customfieldsfilter'); // string (if default), array or object

		if (!empty($customfield_filters) && !is_string($customfield_filters)) {

		    foreach ($customfield_filters as $customfield_filter) {

		        $customfield_filter = (array)$customfield_filter;

		        if ($customfield_filter['field'] !== 'none') {

		            $values = explode(',', $customfield_filter['values']);
		            foreach ($values as $key => $value) {
		                $value = trim($value);
		                if (empty($value)) {
		                    unset($values[$key]);
		                }
		            }

		            if (!empty($values)) {
		                $customfield_filters_arrays[] = array('id' => $customfield_filter['field'], 'values' => $values, 'inex' => $customfield_filter['inex']);
		            }
		        }
		    }
		}

		if (!empty($customfield_filters_arrays)) {

		    foreach ($customfield_filters_arrays as $customfield_filter) {

		        $subQuery = $db->getQuery(true);

		        $subQuery->select("DISTINCT cfv.item_id"); // no unique results when joining with categories
		        $subQuery->from("#__fields_values AS cfv");
		        $subQuery->join('LEFT', '#__fields AS f ON f.id = cfv.field_id');
		        $subQuery->where('(f.context IS NULL OR f.context = ' . $db->quote('com_weblinks.weblink') . ')');
		        $subQuery->where('(f.state IS NULL OR f.state = 1)');
		        $subQuery->where('(f.access IS NULL OR f.access IN (' . $groups . '))');
		        $subQuery->where($db->quoteName('cfv.field_id').' = ' . $db->quote($customfield_filter['id']));

		        // any category for the field? if so, join with categories. If not, do not join
// 		        if (!empty(FieldsHelper::getAssignedCategoriesTitles($customfield_filter['id']))) {
// 		            $subQuery->join('LEFT', '#__fields_categories AS cfc ON cfc.field_id = cfv.field_id');
// 				if ($this->getState('category')) {
// 		                $subQuery->where($db->quoteName('cfc.category_id') . ' = ' . $this->getState('category'));
// 		            } else if ($this->getCategoriesString() != '') {
// 		                $subQuery->where($db->quoteName('cfc.category_id') . ' ' . ($params->get('cat_inex', 1) ? 'IN' : 'NOT IN') . ' (' . $this->getCategoriesString() . ')');
// 		            }
// 		        }

		        if ($customfield_filter['inex']) {
		            $subQuery->where($db->quoteName('cfv.value') . " = '" . implode("' OR " . $db->quoteName('cfv.value') . " = '", $customfield_filter['values']) . "'");
		        } else {
		            $subQuery->where($db->quoteName('cfv.value') . " <> '" . implode("' AND " . $db->quoteName('cfv.value') . " <> '", $customfield_filter['values']) . "'");
		        }

		        if ($this->getState('filter.language')) {
		            $subQuery->where('(f.language IS NULL OR f.language in (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . '))');
		        }

		        $db->setQuery($subQuery);

		        try {
		            $weblink_id_arrays_from_cfields[] = $db->loadColumn();
		        } catch (ExecutionFailureException $e) {
		            Factory::getApplication()->enqueueMessage(Text::_('JERROR_AN_ERROR_HAS_OCCURRED'), 'error');
		        }
		    }
		}

		if (!empty($weblink_id_arrays_from_cfields)) {

		    // keep only the ids found in all the arrays
		    if (count($weblink_id_arrays_from_cfields) > 1) {
		        $weblink_ids = call_user_func_array('array_intersect', $weblink_id_arrays_from_cfields);
		    } else {
		        $weblink_ids = $weblink_id_arrays_from_cfields[0];
		    }

		    if (!empty($weblink_ids)) {
		        $query->where('a.id IN (' . implode(",", $weblink_ids) . ')'); // include all weblinks that have custom field value(s) that correspond to the custom field value
		    } else {
		        $query->where('a.id = 0'); // no weblink having all values selected
		    }
		}

		if ($this->getState('category')) {
			$query->where('a.catid ='.$this->getState('category'));
		} else {
			if ($this->getCategoriesString() != '') {
				$test_type = $params->get('cat_inex', 1) ? 'IN' : 'NOT IN';
				$query->where($db->quoteName('a.catid').' '.$test_type.' ('.$this->getCategoriesString().')');
			}
		}

		// join over the users for the author

		$query->select("ua.email AS author_email");
		$query->select("CASE WHEN a.created_by_alias > ' ' THEN a.created_by_alias ELSE ua.name END AS author");
		$query->join('LEFT', '#__users AS ua ON ua.id = a.created_by');

		// join over the categories

		$query->join('LEFT', $db->quoteName('#__categories', 'c').' ON '.$db->quoteName('c.id').' = '.$db->quoteName('a.catid'));
		$query->where($db->quoteName('c.access').' IN ('.$groups.')');
		$query->where($db->quoteName('c.published').' = 1');

		// filter by metakeys

		if (!empty($item_on_page_keys)) {
			$concat_string = $query->concatenate(array('","', ' REPLACE(a.metakey, ", ", ",")', ' ","')); // remove single space after commas in keywords
			$query->where('('.$concat_string.' LIKE "%'.implode('%" OR '.$concat_string.' LIKE "%', $item_on_page_keys).'%")');
		}

		if ($this->getTagsSelection() || $this->getState('tag')) {

			$query->select('COUNT(t.id) AS tags_count');
			$query->join('INNER', $db->quoteName('#__contentitem_tag_map', 'm').' ON '.$db->quoteName('m.content_item_id').' = '.$db->quoteName('a.id').' AND '.$db->quoteName('m.type_alias').' = '.$db->quote('com_weblinks.weblink'));
			$query->join('INNER', $db->quoteName('#__tags', 't') . ' ON '.$db->quoteName('m.tag_id').' = '.$db->quoteName('t.id'));

			$query->where($db->quoteName('t.access').' IN ('.$groups.')');
			$query->where($db->quoteName('t.published').' = 1');

			if ($this->getState('tag')) {
				$query->where($db->quoteName('t.id').' = '.$this->getState('tag'));
			} else {
				$tags_to_match = implode(',', $this->getTagsSelection());
				$test_type = $params->get('tags_inex', 1) ? 'IN' : 'NOT IN';
				$query->where($db->quoteName('t.id').' '.$test_type.' ('.$tags_to_match.')');

				if (!$params->get('tags_inex', 1)) { // EXCLUDE TAGS
					$query->select('tags_per_items.tag_count_per_item');

					// subquery gets all the tags for all items
					$subquery = 'SELECT mm.content_item_id AS content_id, COUNT(tt.id) AS tag_count_per_item FROM #__contentitem_tag_map AS mm INNER JOIN #__tags AS tt ON mm.tag_id = tt.id WHERE tt.access IN ('.$groups.') AND tt.published = 1 AND mm.type_alias = \'com_weblinks.weblink\' GROUP BY content_id';
					$query->join('INNER', '(' . $subquery . ') AS tags_per_items ON tags_per_items.content_id = a.id');

					//if ($params->get('tags_match', 'any') == 'all') {
					// TODO incomplete: if an item has one of the tags and that is the only tag, it won't show (COUNT(t.id) is never 0)
					//$query->having('COUNT('.$db->quoteName('t.id').') + '.count($tags).' <> tags_per_items.tag_count_per_item');
					//} else {
					// we keep items that have the same amount of tags before and after removals
					$query->having('COUNT('.$db->quoteName('t.id').') = tags_per_items.tag_count_per_item');
					//}
				} else { // INCLUDE TAGS
					if ($params->get('tags_match', 'any') == 'all') {
						$query->having('COUNT('.$db->quoteName('t.id').') = '.count($this->getTagsSelection()));
					}
				}
			}

			$query->group($db->quoteName('a.id'));
		}

		// filter by state

		$query->where($db->quoteName('a.state').' = 1');

		// filter by start and end dates

		//$nullDate = $db->quote($db->getNullDate());
		$nowDate = $db->quote(Factory::getDate()->toSql());

		$query->where('('.$db->quoteName('a.publish_up').' IS NULL OR '.$db->quoteName('a.publish_up').' <= '.$nowDate.')');
		$query->where('('.$db->quoteName('a.publish_down').' IS NULL OR '.$db->quoteName('a.publish_down').' >= '.$nowDate.')');

		// filter by language

		if ($this->getState('filter.language')) {
			$query->where($db->quoteName('a.language').' IN ('.$db->quote(Factory::getLanguage()->getTag()).','.$db->quote('*').')');
		}

		// ordering

		$ordering = '';

		// category order

		if ($this->getCategoryOrderQuery() != '') {
			$query->order($this->getCategoryOrderQuery());
		}

		// items order

		switch ($params->get('ordering', 'title'))
		{
		    case 'title': $ordering .= 'a.title '.$params->get('direction', 'asc'); break;
			case 'order': $ordering .= 'a.ordering '.$params->get('direction', 'asc'); break;
			case 'random': $ordering .= 'rand()'; break;
			case 'hits': $ordering .= 'a.hits '.$params->get('direction', 'asc'); break;

			case 'created': $ordering .= 'a.created '.$params->get('direction', 'asc'); break;
			case 'modified': $ordering .= 'a.modified '.$params->get('direction', 'asc'); break;
			case 'published': $ordering .= 'a.publish_up '.$params->get('direction', 'asc'); break;

			case 'manual':
			    $weblinks_to_include = array_filter(explode(',', trim($params->get('in', ''), ' ,')));
			    if (!empty($weblinks_to_include)) {
			        $ordering .= 'CASE a.id';
			        foreach ($weblinks_to_include as $key => $id) {
			            $ordering .= ' WHEN ' . $id . ' THEN ' . $key;
			        }
			        $ordering .= ' ELSE 999 END, a.id'; // 'FIELD(a.id, ' . $weblinks_to_include . ')' is MySQL specific
			    }
			    
			default: $ordering = rtrim($ordering, ',');
		}

		if ($ordering) {
			$query->order($ordering);
		}

		// include only

		$weblinks_to_include = array_filter(explode(',', trim($params->get('in', ''), ' ,')));
		if (!empty($weblinks_to_include)) {
			$query->where('a.id IN (' . implode(',', $weblinks_to_include) . ')');
		}

		// exclude

		$weblinks_to_exclude = array_filter(explode(',', trim($params->get('ex', ''), ' ,')));
		if (!empty($weblinks_to_exclude)) {
			$query->where('a.id NOT IN (' . implode(',', $weblinks_to_exclude) . ')');
		}

		return $query;
	}

	/**
	 * Method to get an array of data items
	 *
	 * @return  mixed An array of data on success, false on failure
	 */
	public function getItems()
	{
		// Get a storage key
		$store = $this->getStoreId();

		// Try to load the data from internal storage
		if (isset($this->cache[$store]))
		{
			return $this->cache[$store];
		}

		$items = null;
		try {
			$items_query = $this->_getListQuery();

			if (empty($items_query)) {
				$items = array();
			} else {
				$items = $this->_getList($items_query, $this->getStart(), $this->getState('list.limit'));
			}
		} catch (ExecutionFailureException $e) {
			Factory::getApplication()->enqueueMessage(Text::_('JERROR_AN_ERROR_HAS_OCCURRED'), 'error');
			return null;
		}

		if (!empty($items)) {

			$params = $this->getState('params');

			foreach ($items as $i => $item) {

				// images

				$images = json_decode($item->images);
				$item->image_first = '';
				$item->image_second = '';
				$item->alt_first = ''; //$item->title;
				$item->caption_first = $item->title;
				$item->alt_second = ''; // $item->title;
				$item->caption_second = $item->title;
				if (isset($images->image_first)) {

				    $image_object = HTMLHelper::cleanImageURL($images->image_first);
				    $item->image_first = $image_object->url;

					if (!empty($images->image_first_alt)) {
						$item->alt_first = $images->image_first_alt;
					}
					if (!empty($images->image_first_caption)) {
						$item->caption_first = $images->image_first_caption;
					}
				}
				if (isset($images->image_second)) {

				    $image_object = HTMLHelper::cleanImageURL($images->image_second);
				    $item->image_second = $image_object->url;

					if (!empty($images->image_second_alt)) {
						$item->alt_second = $images->image_second_alt;
					}
					if (!empty($images->image_second_caption)) {
						$item->caption_second = $images->image_second_caption;
					}
				}

				if (empty($item->image_first)) {
					if ($params->get('d_logo', '') != '') {
						$default_image_object = HTMLHelper::cleanImageURL($params->get('d_logo', ''));
						$item->image_first = $default_image_object->url;
					} else {

						$show_errors = Helper::isShowErrors($params);

						if (!$show_errors) {
							unset($items[$i]);
							continue;
						}
					}
				}

				$weblink_params = json_decode($item->params);

				// link

				$count_clicks = $params->get('count_clicks', 0);
				if ($count_clicks == 'link') {
					$count_clicks = false;
					if (isset($weblink_params->count_clicks)) {
						if ($weblink_params->count_clicks == '') {
							$count_clicks = Helper::getWeblinksConfig()->get('count_clicks');
						} else {
							$count_clicks = $weblink_params->count_clicks;
						}
					}
				}

				if ($count_clicks) {
					$item->link	= Route::_('index.php?option=com_weblinks&task=weblink.go&catid=' . $item->catslug . '&id=' . $item->slug);
				} else {
					$item->link = $item->url;
				}

				// target

				$item->target = $params->get('target', 1);
				if ($item->target == 'link') {
					$item->target = 1;
					if (isset($weblink_params->target)) {
						if ($weblink_params->target == '') {
							$item->target = Helper::getWeblinksConfig()->get('target');
						} else {
							$item->target = $weblink_params->target;
							//$item->popup_width = $weblink_params->width;
							//$item->popup_height = $weblink_params->height;
						}
					}
				}

				// text

				if ($params->get('description', 0)) {

					$letter_count = trim($params->get('l_count', ''));
					if (empty($letter_count)) {
						$letter_count = -1;
					} else {
						$letter_count = (int)($letter_count);
					}

					$strip_tags = $params->get('strip_tags', 1);
					$keep_tags = trim($params->get('keep_tags', ''));
					$trigger_events = $params->get('trigger_events', false);
					$truncate_last_word = $params->get('trunc_l_w', 0);

					if ($trigger_events) {
						$item->text = $item->description;
						Factory::getApplication()->triggerEvent('onContentPrepare', array('com_weblinks.weblink', &$item, &$params, 0));
						$item->description = SYWText::getText($item->text, 'html', $letter_count, $strip_tags, $keep_tags, true, $truncate_last_word);
					} else {
						$item->description = SYWText::getText($item->description, 'html', $letter_count, $strip_tags, $keep_tags, true, $truncate_last_word);
					}
				} else {
					$item->description = '';
				}
			}
		}

		//$this->_total = count($items);

		// Add the items to the internal cache
		$this->cache[$store] = $items;

		return $this->cache[$store];
	}

// 	public function getTotal()
// 	{
// 		// Get a storage key.
// 		$store = $this->getStoreId('getTotal');

// 		// Try to load the data from internal storage.
// 		if (isset($this->cache[$store]))
// 		{
// 			return $this->cache[$store];
// 		}

// 		$this->cache[$store] = $this->_total;

// 		return $this->cache[$store];
// 	}

	/**
	 * Get the tags as an array of ids
	 */
	protected function getTagsSelection()
	{
		if (!isset($this->tags_selection))
		{
			$this->tags_selection = $this->getState('params')->get('tags', array());

			if (!empty($this->tags_selection)) {

				// if all selected, get all available tags
				$array_of_tag_values = array_count_values($this->tags_selection);
				if (isset($array_of_tag_values['all']) && $array_of_tag_values['all'] > 0) { // 'all' was selected
					$tags = array();
					$tag_objects = SYWTags::getTags('com_weblinks.weblink');
					if ($tag_objects !== false) {
						foreach ($tag_objects as $tag_object) {
							$tags[] = $tag_object->id;
						}
					}

					if (empty($tags) && $this->getState('params')->get('tags_inex', 1)) { // won't return any weblink if no weblink has been associated to any tag (when include tags only)
						return false;
					} else {
						$this->tags_selection = $tags;
					}
				} else if ($this->getState('params')->get('include_tag_children', 0)) { // get tag children

					$tagTreeArray = array();
					$helper_tags = new TagsHelper();

					foreach ($this->tags_selection as $tag) {
						$helper_tags->getTagTreeArray($tag, $tagTreeArray);
					}

					$this->tags_selection = array_unique(array_merge($this->tags_selection, $tagTreeArray));
				}
			}
		}

		return $this->tags_selection;
	}

	/**
	 * Get the tags as an array of tag objects
	 */
	public function getTagsList()
	{
		if (!isset($this->tags_list))
		{
			$this->tags_list = null;

			$order = 'lft';
			$order_dir = 'ASC';
			$tag_order = $this->getState('params')->get('tag_index_order', '');
			if ($tag_order) {
			    switch ($tag_order)
			    {
			        case 'o_asc': $order = 'lft'; $order_dir = 'ASC'; break;
			        case 'o_dsc': $order = 'lft'; $order_dir = 'DESC'; break;
			        case 't_asc': $order = 'title'; $order_dir = 'ASC'; break;
			        case 't_dsc': $order = 'title'; $order_dir = 'DESC'; break;
			    }
			}

			if ($this->getTagsSelection()) {
				 // get full objects of the selected tags
			    $tag_objects = SYWTags::getTags('com_weblinks.weblink', true, $this->getTagsSelection(), $this->getState('params')->get('tags_inex', 1), $order, $order_dir);
				if ($tag_objects !== false) {
					$this->tags_list = $tag_objects;
				}
			} else {
				// get all tags associated to weblinks
			    $tag_objects = SYWTags::getTags('com_weblinks.weblink', true, array(), true, $order, $order_dir);
				if ($tag_objects !== false) {
					$this->tags_list = $tag_objects;
				}
			}

			if (!is_null($this->tags_list)) {
				foreach($this->tags_list as $tag_item) {

					if (Factory::getLanguage()->hasKey($tag_item->title)) {
						$tag_item->title = Text::_($tag_item->title);
					}

					$params = json_decode($tag_item->images);
					$tag_item->image = empty($params->image_intro) ? '' : HTMLHelper::cleanImageURL($params->image_intro)->url;
					$tag_item->image_alt = empty($params->image_intro_alt) ? $tag_item->title : $params->image_intro_alt;

					$params = new Registry($tag_item->params);
					$tag_item->link_class = $params->get('tag_link_class', 'label label-info');
				}
			}
		}

		return $this->tags_list;
	}

	/**
	 * Get the categories as a string
	 */
	protected function getCategoriesString()
	{
		if (!isset($this->categories_string))
		{
			$this->categories_string = '';

			$params = $this->getState('params');

			$categories_array = $params->get('category', array());

			$array_of_category_values = array_count_values($categories_array);
			if (isset($array_of_category_values['all']) && $array_of_category_values['all'] > 0) { // 'all' was selected
				return $this->categories_string;
			} else {

				if (!empty($categories_array)) {

					// sub-category inclusion
					$get_sub_categories = $params->get('includesubcategories', 'no');
					if ($get_sub_categories != 'no') {

						$levels = $params->get('levelsubcategories', 1);

						$categories_object = Categories::getInstance('Weblinks');
						foreach ($categories_array as $category) {
							$category_object = $categories_object->get($category); // if category unpublished, unset
							if (isset($category_object) && $category_object->hasChildren()) {

								$sub_categories_array = $category_object->getChildren(true); // get all levels recursively
								foreach ($sub_categories_array as $subcategory_object) {
									$condition = ($get_sub_categories == 'all' || ($subcategory_object->level - $category_object->level) <= $levels);
									if ($condition) {
										$categories_array[] = $subcategory_object->id;
									}
								}
							}
						}
						$categories_array = array_unique($categories_array);
					}

					if (!empty($categories_array)) {
						$this->categories_string = implode(',', $categories_array);
					}
				}
			}
		}

		return $this->categories_string;
	}

	/**
	 * Get the categories as an array of title, image ...
	 */
	public function getCategoriesList()
	{
		if (!isset($this->categories_list))
		{
			$this->categories_list = null;

			$user = Factory::getUser();
			$groups	= implode(',', $user->getAuthorisedViewLevels());

			$db = $this->getDbo();
			$query = $db->getQuery(true);

			$query->select('c.id, c.title, c.params, c.description, c.level, c.parent_id');
			$query->from($db->quoteName('#__categories', 'c'));

			if ($this->getCategoriesString() != '') {
				$test_type = $this->getState('params')->get('cat_inex', 1) ? 'IN' : 'NOT IN';
				$query->where('c.id '.$test_type.' ('.$this->getCategoriesString().')');
			}
			$query->where($db->quoteName('c.extension').' = '.$db->quote('com_weblinks'));
			$query->where($db->quoteName('c.access').' IN ('.$groups.')');
			$query->where($db->quoteName('c.published').' = 1');

			$order = $this->getState('params')->get('cat_index_order', '');
			if ($order) {
			    switch ($order)
			    {
			        case 'selection':
						if ($this->getCategoryOrderQuery() != '') {
							$query->order($this->getCategoryOrderQuery());
						}
			            break;
			        case 'o_asc': $query->order('c.lft ASC'); break;
			        case 'o_dsc': $query->order('c.lft DESC'); break;
			        case 't_asc': $query->order('c.title ASC'); break;
			        case 't_dsc': $query->order('c.title DESC'); break;
			    }
			}

			$db->setQuery($query);

			try {
				$this->categories_list = $db->loadObjectList('id');
			} catch (ExecutionFailureException $e) {
				Factory::getApplication()->enqueueMessage(Text::_('JERROR_AN_ERROR_HAS_OCCURRED'), 'error');
				return null;
			}

			foreach($this->categories_list as $category_item) {
				$params = json_decode($category_item->params);
				$category_item->image = empty($params->image) ? '' : HTMLHelper::cleanImageURL($params->image)->url;
				$category_item->image_alt = empty($params->image_alt) ? $category_item->title : $params->image_alt;
			}
		}

		return $this->categories_list;
	}

	/**
	 * Get the category order query
	 */
	public function getCategoryOrderQuery()
	{
		switch ($this->getState('params')->get('cat_order', '')) {
			case 'o_asc': return "c.lft ASC"; break;
			case 'o_dsc': return "c.lft DESC"; break;
			case 'n_asc': return "c.title ASC"; break;
			case 'n_dsc': return "c.title DESC"; break;
		}

		return "";
	}

	public function getTextArticleBefore()
	{
		$article_id = $this->getState('params')->get('a_before_id', '');

		if ($article_id) {
			return $this->getTextArticle($article_id);
		}

		return '';
	}

	public function getTextArticleAfter()
	{
		$article_id = $this->getState('params')->get('a_after_id', '');

		if ($article_id) {
			return $this->getTextArticle($article_id);
		}

		return '';
	}

	protected function getTextArticle($article_id)
	{
		BaseDatabaseModel::addIncludePath(JPATH_SITE . '/components/com_content/models', 'ContentModel');
		$content_model = BaseDatabaseModel::getInstance('Article', 'ContentModel', array('ignore_request' => true));

		$app = Factory::getApplication();
		$content_model->setState('params', $app->getParams('com_content'));

		$article = $content_model->getItem($article_id);

		if ($article->params->get('show_intro', '1') == '1') {
			$article->text = $article->introtext.' '.$article->fulltext;
		} elseif ($article->fulltext) {
			$article->text = $article->fulltext;
		} else {
			$article->text = $article->introtext;
		}

		if (!isset($article->tags)) { // should not be necessary
			$article->tags = new TagsHelper();
			$article->tags->getItemTags('com_content.article', $article_id);
		}

		if ($this->getState('params')->get('allow_plugins', 0)) {
			PluginHelper::importPlugin('content');
			Factory::getApplication()->triggerEvent('onContentPrepare', array('com_content.article', &$article, &$article->params, 0));
		}

		// Note: the article is not merged with the general params,
		// therefore, all options need to be specifically set in the article
		// in order to work with the plugin 'Article Details'

		return $article->text;
	}

}
