<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

/**
 * Methods supporting a list of weblink records associated to a user
 */
class WeblinksModel extends ListModel
{
	/**
	 * Constructor
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.id',
				'title', 'a.title'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws \Exception
	 *
	 * @since    1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
        // List state information.
        parent::populateState('a.ordering', 'asc');

        $app = Factory::getApplication();
        $limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
        $this->setState('list.limit', $limit);

        $context = $this->getUserStateFromRequest($this->context . '.context', 'context', 'com_weblinks.weblink', 'CMD');
        $this->setState('filter.context', $context);

        // Split context into component and optional section
        $parts = FieldsHelper::extract($context);

        if ($parts)
        {
            $this->setState('filter.component', $parts[0]);
            $this->setState('filter.section', $parts[1]);
        }

        $limitstart = $app->input->getInt('limitstart', 0);
        $this->setState('list.start', $limitstart);

        $search = $app->input->getString('filter-search', '');
        $this->setState('filter-search', $search);
	}

	/**
	 *
	 * {@inheritDoc}
	 * @see \Joomla\CMS\MVC\Model\ListModel::getListQuery()
	 */
	protected function getListQuery()
	{
        $db = $this->getDbo();
        $query = $db->getQuery(true);

        $query->select(
            $this->getState(
                'list.select', 'DISTINCT a.*'
            )
        );

        $query->from($db->quoteName('#__weblinks', 'a'));

        $user = Factory::getUser();
        if ($user->id != 0) {
            if ($user->authorise('core.edit.own', 'com_weblinklogospro')) {
                $query->where($db->quoteName('created_by') . ' = ' . $db->quote($user->id));
            }
        }

        // Join over the categories
        $query->select($db->quoteName('c.title', 'category_title'))
        ->join(
            'LEFT',
            $db->quoteName('#__categories', 'c') . ' ON ' . $db->quoteName('c.id') . ' = ' . $db->quoteName('a.catid')
            );

        // Join over the language
        $query->select($db->quoteName('l.title', 'language_title'))
        ->select($db->quoteName('l.image', 'language_image'))
        ->join(
            'LEFT',
            $db->quoteName('#__languages', 'l') . ' ON ' . $db->quoteName('l.lang_code') . ' = ' . $db->quoteName('a.language')
            );

        // Join over the users for the checked out user
        $query->select($db->quoteName('uc.name', 'editor'))
        ->join(
            'LEFT',
            $db->quoteName('#__users', 'uc') . ' ON ' . $db->quoteName('uc.id') . ' = ' . $db->quoteName('a.checked_out')
            );

        //$search = $this->getState('filter-search');
        //$search = JFactory::getApplication()->input->getString('filter-search', '');
        //$this->setState('filter-search', $search);
        $search = $this->state->get('filter-search', '');

        if (!empty($search))
        {
            $search = $db->quote('%' . $db->escape($search, true) . '%');
            $query->andWhere('a.title LIKE ' . $search);
        }

//         $orderCol = $this->state->get('list.ordering', 'a.name');
//         $orderDirn = $this->state->get('list.direction', 'ASC');

//         if ($orderCol && $orderDirn)
//         {
//             $query->order($db->escape($orderCol . ' ' . $orderDirn));
//         }

        $query->order($db->escape('a.title ASC' ));

        return $query;
	}

	/**
	 * Method to get an array of data items
	 *
	 * @return  mixed An array of data on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();

		foreach ($items as $item)
		{
		    $images = json_decode($item->images);

		    $item->image_first = '';
		    if (isset($images->image_first)) {
		        $image_object = HTMLHelper::cleanImageURL($images->image_first);
		        $item->image_first = $image_object->url;
		    }

		    $item->image_first_alt = '';
		    if (isset($images->image_first_alt)) {
		        $item->image_first_alt = $images->image_first_alt;
		    }

		    $item->image_second = '';
		    if (isset($images->image_second)) {
		        $image_object = HTMLHelper::cleanImageURL($images->image_second);
		        $item->image_second = $image_object->url;
		    }

		    $item->image_second_alt = '';
		    if (isset($images->image_second_alt)) {
		        $item->image_second_alt = $images->image_second_alt;
		    }
		}

		return $items;
	}

}
