<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Multilanguage;
use SYW\Library\Utilities as SYWUtilities;

/** @var \SYW\Component\WeblinkLogosPro\Site\View\Weblinks\HtmlView $this */

if ($this->load_bootstrap) {
    HTMLHelper::_('bootstrap.framework');
    HTMLHelper::_('bootstrap.tooltip', '.hasTooltip');
}

if ($this->load_chosen_script) {
    HTMLHelper::_('formbehavior.chosen', 'select');
}

if ($this->remove_whitespaces) {
    ob_start(function($buffer) { return preg_replace('/\s+/', ' ', $buffer); });
}

$user = Factory::getUser();

$canCreate  = $user->authorise('core.create', 'com_weblinklogospro') && file_exists(JPATH_COMPONENT . '/forms/weblink.xml');
$canEdit    = $user->authorise('core.edit', 'com_weblinklogospro');
$canCheckin = $user->authorise('core.manage', 'com_weblinklogospro');
//$canChange  = $user->authorise('core.edit.state', 'com_weblinklogospro');
$canDelete  = $user->authorise('core.delete', 'com_weblinklogospro');
?>
<div class="wlp_weblinks<?php echo $this->isMobile ? ' mobile' : ''; ?>">

	<?php if ($this->page_heading) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->page_heading); ?></h1>
		</div>
	<?php endif; ?>

	<?php if ($this->show_print) : ?>
		<?php
            $layout = new FileLayout('content.wlpicons');

            $data = array('view' => 'weblinks', 'style' => $this->actions_style, 'classes' => $this->actions_classes, 'print' => $this->print, 'show_print' => $this->show_print);
            $data['search'] = $this->search_request;
			$data['bootstrap_version'] = $this->bootstrap_version;
			$data['load_bootstrap'] = $this->load_bootstrap;

			echo $layout->render($data);
		?>
	<?php endif; ?>

    <form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm">

		<?php if (!$this->print) : ?>
			<div class="pagination_cards top">

				<?php if ($this->show_search) : ?>
    				<?php
						$layout = new FileLayout('pagination.wlpsearch');

						$data = array('search' => $this->search_request);
						$data['show_search'] = true;
						$data['search_value'] = $this->escape($this->get('state')->get('filter-search'));
						$data['bootstrap_version'] = $this->bootstrap_version;
						$data['load_bootstrap'] = $this->load_bootstrap;

						echo $layout->render($data);
					?>
				<?php endif; ?>
				
				<?php
           			$layout = new FileLayout('pagination.wlpdisplay');
           			$data = array('options' => $this->limits, 'selected' => $this->state->get('list.limit'));
           			$data['bootstrap_version'] = $this->bootstrap_version;
           			$data['load_bootstrap'] = $this->load_bootstrap;
           			echo $layout->render($data);
           		?>
		    </div>
	    <?php endif; ?>

		<div class="table-responsive">
	    	<table class="table table-striped" id="weblinksList">
	    		<thead>
	    			<tr>
	    				<th scope="col" class="<?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">&nbsp;</th>
	    				<th scope="col" class="<?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">&nbsp;</th>
	    				<th scope="col" class="nowrap"><?php echo Text::_('COM_WEBLINKLOGOSPRO_LABEL_TITLE'); ?></th>
	    				<th scope="col" class="nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>"><?php echo Text::_('JCATEGORY'); ?></th>
	    				<th scope="col" class="nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>"><?php echo Text::_('COM_WEBLINKLOGOSPRO_LABEL_STATUS'); ?></th>
	    				<?php if (Multilanguage::isEnabled()): ?>
	    					<th scope="col" class="nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>"><?php echo Text::_('COM_WEBLINKLOGOSPRO_LABEL_LANGUAGE'); ?></th>
	    				<?php endif; ?>
	    				<?php if (!$this->print && ($canEdit || $canDelete)): ?>
	    					<th scope="col" class="center">&nbsp;</th>
	    				<?php endif; ?>
	    			</tr>
	    		</thead>
	    		<tbody>
	    			<?php foreach ($this->items as $i => $item) : ?>

	    				<?php $canEdit = $user->authorise('core.edit', 'com_weblinklogospro'); ?>
	    				<?php if (!$canEdit && $user->authorise('core.edit.own', 'com_weblinklogospro')): ?>
	    					<?php $canEdit = $user->id == $item->created_by; ?>
	    				<?php endif; ?>

	    				<tr class="row<?php echo $i % 2; ?>">

	    					<td class="col_picture <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">
	    						<?php if ($item->image_first): ?>
	    							<?php echo SYWUtilities::getImageElement($item->image_first, $item->image_first_alt, null, true); ?>
	    						<?php endif; ?>
	    					</td>

	    					<td class="col_picture <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">
	    						<?php if ($item->image_second): ?>
	    							<?php echo SYWUtilities::getImageElement($item->image_second, $item->image_second_alt, null, true); ?>
	    						<?php endif; ?>
	    					</td>

	    					<td class="col_name">
	        					<?php if (isset($item->checked_out) && $item->checked_out && !$this->print) : ?>
	        						<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'weblinks.', false); ?>
	        					<?php endif; ?>
	        					<?php if ($canEdit && !$this->print): ?>
	        						<a href="<?php echo Route::_('index.php?option=com_weblinklogospro&task=weblink.edit&id='.(int) $item->id . '&return=' . base64_encode(Uri::getInstance())); ?>"><?php echo $this->escape($item->title); ?></a>
	        					<?php else : ?>
	        						<?php echo $this->escape($item->title); ?>
	        					<?php endif; ?>
	        					<span class="alias">
	    							<?php echo Text::sprintf('COM_WEBLINKLOGOSPRO_LIST_ALIAS', $this->escape($item->alias)); ?>
	    						</span>
	        				</td>

	        				<td class="col_category nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">
	        					<?php echo $this->escape($item->category_title); ?>
	        				</td>

	        				<td class="col_status nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>">
	        					<?php if ($item->state == 0): ?>
	        						<span class="icon-unpublish hasTooltip" title="<?php echo Text::_('JUNPUBLISHED'); ?>" aria-label="<?php echo Text::_('JUNPUBLISHED'); ?>" aria-hidden="true"></span>
	        					<?php elseif ($item->state == 1) : ?>
	        						<span class="icon-publish hasTooltip" title="<?php echo Text::_('JPUBLISHED'); ?>" aria-label="<?php echo Text::_('JPUBLISHED'); ?>" aria-hidden="true"></span>
	        					<?php elseif ($item->state == 2) : ?>
	        						<span class="icon-archive hasTooltip" title="<?php echo Text::_('JARCHIVED'); ?>" aria-label="<?php echo Text::_('JARCHIVED'); ?>" aria-hidden="true"></span>
	        					<?php elseif ($item->state == -2) : ?>
	        						<span class="icon-trash hasTooltip" title="<?php echo Text::_('JTRASHED'); ?>" aria-label="<?php echo Text::_('JTRASHED'); ?>" aria-hidden="true"></span>
	        					<?php endif; ?>
	        				</td>

	        				<?php if (Multilanguage::isEnabled()): ?>
	        					<td class="col_language nowrap <?php echo SYWUtilities::getBootstrapProperty('hidden-phone', $this->bootstrap_version); ?>"><?php echo LayoutHelper::render('joomla.content.language', $item); ?></td>
	        				<?php endif; ?>

	    					<?php if (!$this->print && ($canEdit || $canDelete)): ?>
	        					<td class="center">
	        						<?php if ($canEdit): ?>
	        							<a href="<?php echo Route::_('index.php?option=com_weblinklogospro&task=weblink.edit&id=' . $item->id . '&return=' . base64_encode(Uri::getInstance()), false, 2); ?>" class="<?php echo SYWUtilities::getBootstrapProperty('btn btn-mini', $this->bootstrap_version); ?> hasTooltip" type="button" title="<?php echo Text::_('JACTION_EDIT'); ?>" aria-label="<?php echo Text::_('JACTION_EDIT'); ?>"><i class="icon-edit" aria-hidden="true"></i></a>
	        						<?php endif; ?>
	        						<?php if ($canDelete): ?>
	        							<a href="<?php echo Route::_('index.php?option=com_weblinklogospro&task=weblink.remove&id=' . $item->id . '&return=' . base64_encode(Uri::getInstance()), false, 2); ?>" class="delete-button <?php echo SYWUtilities::getBootstrapProperty('btn btn-mini', $this->bootstrap_version); ?> hasTooltip" type="button" title="<?php echo Text::_('JACTION_DELETE'); ?>" aria-label="<?php echo Text::_('JACTION_DELETE'); ?>"><i class="icon-trash" aria-hidden="true"></i></a>
	        						<?php endif; ?>
	        					</td>
	        				<?php endif; ?>
	    				</tr>
	    			<?php endforeach; ?>
	    		</tbody>
	    	</table>
	    </div>

		<?php if (!$this->print) : ?>
  	  	<?php if (!empty($this->items)) : ?>
    			<div class="pagination_cards bottom">
        			<div class="counterpagination<?php echo intval($this->bootstrap_version) == 2 ? ' pagination' : '' ?>">
        				<?php echo $this->pagination->getPagesLinks(); ?>
        			</div>
	        	</div>
    		<?php endif; ?>

    		<?php if ($canCreate) : ?>
    			<a href="<?php echo Route::_('index.php?option=com_weblinklogospro&task=weblink.edit&id=0' . '&return=' . base64_encode(Uri::getInstance()), false, 0); ?>" class="<?php echo SYWUtilities::getBootstrapProperty('btn btn-success', $this->bootstrap_version); ?> <?php echo SYWUtilities::getBootstrapProperty('btn-small', $this->bootstrap_version); ?>"><i class="icon-plus" aria-hidden="true"></i> <?php echo Text::_('COM_WEBLINKLOGOSPRO_ADD_WEBLINK'); ?></a>
    		<?php endif; ?>
	    <?php endif; ?>

    	<input type="hidden" name="task" value=""/>
    	<!-- <input type="hidden" name="boxchecked" value="0"/> -->
    	<input type="hidden" name="limitstart" value="<?php echo $this->limitstart_request_value; ?>" />
    	<?php echo HTMLHelper::_('form.token'); ?>
    </form>
</div>

<?php if ($canDelete) : ?>
    <script type="text/javascript">
	    document.addEventListener("readystatechange", function(event) {
			if (event.target.readyState === "complete") {
				var all_delete = document.querySelectorAll(".delete-button");
				for (var i = 0; i < all_delete.length; i++) {
					all_delete[i].addEventListener("click", function(e) {
						if (!confirm("<?php echo Text::_('COM_WEBLINKLOGOSPRO_DELETE_WEBLINK_MESSAGE'); ?>")) {
							e.preventDefault();
			    			return false;
			    		}
					});
				}
			}
		});
    </script>
<?php endif; ?>

<?php if ($this->remove_whitespaces) : ?>
	<?php ob_get_flush(); ?>
<?php endif; ?>