<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5.x
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.0.1.0-PRO - 2024-01-29
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

namespace KubikRubik\Plugin\System\EasyJoomlaBackupCli\Helper;

defined('_JEXEC') || die('Restricted access');

use Joomla\CMS\Console\Loader\WritableLoaderInterface;
use Joomla\CMS\Factory;
use KubikRubik\Plugin\System\EasyJoomlaBackupCli\Console\DatabaseCommand;
use KubikRubik\Plugin\System\EasyJoomlaBackupCli\Console\FileCommand;
use KubikRubik\Plugin\System\EasyJoomlaBackupCli\Console\FullCommand;
use Psr\Container\ContainerInterface;

use function defined;

/**
 * Registers the commands for the console execution
 *
 * @since 5.0.0.0-PRO
 */
class ConsoleHelper
{
    /**
     * Registers CLI commands
     *
     * @since 5.0.0.0-PRO
     */
    public static function registerCommands(): void
    {
        Factory::getContainer()->share(
            'backup.full',
            function (ContainerInterface $container) {
                return new FullCommand();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add('backup:full', 'backup.full');

        Factory::getContainer()->share(
            'backup.database',
            function (ContainerInterface $container) {
                return new DatabaseCommand();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add('backup:database', 'backup.database');

        Factory::getContainer()->share(
            'backup.file',
            function (ContainerInterface $container) {
                return new FileCommand();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add('backup:file', 'backup.file');
    }
}
