<?php
/*
* @ author Jose A. Luque
* @ Copyright (c) 2011 - Jose A. Luque
* @license GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
*/
namespace Joomla\Plugin\System\Securitycheck_spam_protection\Extension;

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\User\User;
use Joomla\Registry\Registry;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Plugin\System\Securitycheckpro\Extension\Securitycheckpro;
use Joomla\Plugin\System\Securitycheck\Extension\Securitycheck;

class Securitycheck_spam_protection extends CMSPlugin{
	
private $exists_pro_version = false;
private $exists_free_version = false;
private $parameters = null;
private $objeto = null;
private $reason = null;
private $lang = null;
private $lang_firewall = null;
private $forms = [];
private $include_urls_spam_protection = [];
private $plugin_enabled = false;

private $logs_attacks = null;
private $check_if_user_is_spammer = null;
private $spammer_action = null;
private $spammer_write_log = null;

private $field_name = null;

function __construct( &$subject, $config ){
	parent::__construct( $subject, $config );
	
	$first_part_generated = 0;
	
	/* Cargamos el lenguaje de plugin */
	$lang = Factory::getLanguage();
	$lang->load('plg_system_securitycheck_spam_protection',JPATH_ADMINISTRATOR);
	
	if (file_exists(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_securitycheckpro' . DIRECTORY_SEPARATOR . 'services' . DIRECTORY_SEPARATOR . 'provider.php'))
	{
		$this->exists_pro_version = true;
		$this->parameters = $this->load('pro_plugin');
		// Creamos un nuevo objeto para utilizar las funciones 
		$this->objeto = new Securitycheckpro($subject, $config);
		/* Cargamos el lenguaje del sitio */
		$this->lang_firewall = Factory::getLanguage();
		$this->lang_firewall->load('com_securitycheckpro',JPATH_ADMINISTRATOR);
		
	} else if ( file_exists(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_securitycheck' . DIRECTORY_SEPARATOR . 'services' . DIRECTORY_SEPARATOR . 'provider.php') ) {
		$this->exists_free_version = true;
		// Creamos un nuevo objeto para utilizar las funciones 		
		$this->objeto = new Securitycheck($subject, $config);
		/* Cargamos el lenguaje del sitio */
		$this->lang_firewall = Factory::getLanguage();
		$this->lang_firewall->load('com_securitycheck',JPATH_ADMINISTRATOR);
	}
	    
	$db = Factory::getDBO();
		
	$this->plugin_enabled = PluginHelper::isEnabled('system','securitycheck_spam_protection');
		
	// A way to randomly generate the name of the field
	try 
	{
		$query = "SELECT count(*) from `#__extensions`" ;            
		$db->setQuery($query);
		$first_part_generated = $db->loadResult();
	} catch (Exception $e)
	{
	}
	
	if ( (!is_null($this->parameters)) && (array_key_exists('logs_attacks',$this->parameters)) ) {
		$this->logs_attacks = $this->parameters['logs_attacks'];
	} else {
		$this->logs_attacks = '1';
	}
	if ( (!is_null($this->parameters)) && (array_key_exists('check_if_user_is_spammer',$this->parameters)) ) {
		$this->check_if_user_is_spammer = $this->parameters['check_if_user_is_spammer'];
	} else {
		$this->check_if_user_is_spammer = '1';
	}
	if ( (!is_null($this->parameters)) && (array_key_exists('spammer_action',$this->parameters)) ) {
		$this->spammer_action = $this->parameters['spammer_action'];
	} else {
		$this->spammer_action = '0';
	}
	if ( (!is_null($this->parameters)) && (array_key_exists('spammer_write_log',$this->parameters)) ) {
		$this->spammer_write_log = $this->parameters['spammer_write_log'];
	} else {
		$this->spammer_write_log = '1';
	}
	
	if ( (!is_null($this->parameters)) && (array_key_exists('forms_to_include_honeypot_in',$this->parameters)) ) {
		$this->forms = $name_to_array = explode(",",$this->parameters['forms_to_include_honeypot_in']);
	} 
	
	// Generate a pseudo-random name for the honeypot fields
	$this->field_name = $first_part_generated;
	$this->field_name .= "_" ;	
			
}

/* Consulta la versin de Securitycheck instalada */
public function getVersion($component_name) {
	$xml_path = JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_' . $component_name . DIRECTORY_SEPARATOR . $component_name . '.xml';
	$xml_obj = new \SimpleXMLElement(file_get_contents($xml_path));
	
	return strval($xml_obj->version);
	
}
/* Hace una consulta a la tabla especificada como parmetro */
public function load($key_name)
	{
		// Sanitize params
		$key_name = htmlspecialchars($key_name, ENT_QUOTES);
			
		$db = Factory::getDBO();
		$query = $db->getQuery(true);
		$query 
			->select($db->quoteName('storage_value'))
			->from($db->quoteName('#__securitycheckpro_storage'))
			->where($db->quoteName('storage_key').' = '.$db->quote($key_name));
		$db->setQuery($query);
		$res = $db->loadResult();
				
		if(!empty($res)) {
			$res = json_decode($res, true);
			return $res;
		}
}
	
/* Funcin que controla si un usuario est catalogado como spammer. Si es as, prohibe el registro */
	public function onUserBeforeSave($oldUser, $isnew, $new) {	
						
		// Is the plugin enabled?
        if ($this->plugin_enabled)
		{
		
			// Inicializamos variables
			$username = '';
			$ip='';
			$email='';
			$name = '';
			
			if (is_null($this->objeto)) {
				if (file_exists(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_securitycheckpro' . DIRECTORY_SEPARATOR . 'services' . DIRECTORY_SEPARATOR . 'provider.php'))
				{
					$this->exists_pro_version = true;
					$this->parameters = $this->load('pro_plugin');
					// Creamos un nuevo objeto para utilizar las funciones 
					$this->objeto = new Securitycheckpro($subject, $config);
					/* Cargamos el lenguaje del sitio */
					$this->lang_firewall = Factory::getLanguage();
					$this->lang_firewall->load('com_securitycheckpro',JPATH_ADMINISTRATOR);
					
				} else if ( file_exists(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_securitycheck' . DIRECTORY_SEPARATOR . 'services' . DIRECTORY_SEPARATOR . 'provider.php') ) {
					$this->exists_free_version = true;
					// Creamos un nuevo objeto para utilizar las funciones 		
					$this->objeto = new Securitycheck($subject, $config);
					/* Cargamos el lenguaje del sitio */
					$this->lang_firewall = Factory::getLanguage();
					$this->lang_firewall->load('com_securitycheck',JPATH_ADMINISTRATOR);
				}
			}
						
			$attack_ip = $this->objeto->get_ip();			
			
			if ( (!is_null($this->parameters)) && (array_key_exists('spammer_what_to_check',$this->parameters)) ) {
				$spammer_what_to_check = $this->parameters['spammer_what_to_check'];
			} else {
				$spammer_what_to_check = array('0' => 'Email','1' => 'IP','3' => 'Username');
			}
			if ( (!is_null($this->parameters)) && (array_key_exists('spammer_limit',$this->parameters)) ) {
				$spammer_limit = $this->parameters['spammer_limit'];
			} else {
				$spammer_limit = '3';
			}
			
			if ( (!is_null($this->parameters)) && (array_key_exists('include_urls_spam_protection',$this->parameters)) ) {
				$this->include_urls_spam_protection = explode(",",$this->parameters['include_urls_spam_protection']);
			} 
			
			// Extraemos los valores que han de ser consultados
			if ( in_array("Email",$spammer_what_to_check) ) {
				$email = $new['email'];
			}
			
			if ( in_array("IP",$spammer_what_to_check) ) {
				$ip = $attack_ip;
			}
			
			if ( in_array("Username",$spammer_what_to_check) ) {
				$username = $new['username'];
			}
						
			if ( array_key_exists("name",$new) ) {
				$name = $new['name'];
			}
										
			$request_uri = $_SERVER['REQUEST_URI'];
			
			// Sanitize params
			$request_uri = htmlspecialchars($request_uri, ENT_QUOTES);
			
			// Check if the url has been included in this protection
			foreach($this->include_urls_spam_protection as $url_to_be_included){ 			
				if ( !strstr($request_uri,$url_to_be_included) ) {				
					return;
				}
			}			
				
			// Chequeamos si el usuario est en la bbdd de spammers
			$spammer = $this->check_spammer($username,$ip,$email,$spammer_limit);
						
			if ( !$spammer ) {
				// Chequeamos si el nombre est mal formado
				$spammer = $this->check_name($name,$username);
			}
			
			// If the registration does not come from Joomla, the 'isnew' value is false although the user is new. In that case, the $oldUser id value is not zero
			if (!$isnew) {
				if ( ($oldUser['id'] > 0) && ($spammer) ) {
					$isnew = true;
					$user   = User::getInstance($oldUser['id']);
					// Delete the user.
					$user->delete();
				}
			}
			
			if ( $this->exists_pro_version ) {				
				if ( ($isnew) && ($this->check_if_user_is_spammer) ) {					
					if ( $spammer ) {								
						if ( $this->spammer_write_log == 1 ) {
							$spam_protection_description = $this->lang_firewall->_('COM_SECURITYCHECKPRO_SPAM_PROTECTION_DESCRIPTION');
							// Grabamos el log correspondiente...
							$this->objeto->grabar_log($this->logs_attacks,$attack_ip,'SPAM_PROTECTION',$spam_protection_description,'SPAM_PROTECTION',$request_uri,$this->reason,$new['username'],'---');
						}
											
						// Si est marcada la opcin, aadimos la IP a la lista negra dinmica
						if ( $this->spammer_action == 1 ){
							$this->objeto->actualizar_lista_dinamica($attack_ip);					
						}
						
						// ... y redirigimos la peticin para realizar las acciones correspondientes
						$you_are_spammer = Text::_('PLG_SECURITYCHECKPRO_YOU_ARE_SPAMMER');
						$this->objeto->redirection(403,$you_are_spammer);
						
						// Tenemos que devolver 'false' para que el proceso de registro del nuevo usuario no termine
						return false;
					}
					
				}
			}else if ( $this->exists_free_version ) {	
				if ( ($isnew) && ($this->check_if_user_is_spammer) ) {					
					if ( $spammer ) {	
						$spam_protection_description = $this->lang_firewall->_('COM_SECURITYCHECKPRO_SPAM_PROTECTION_DESCRIPTION');
						// Grabamos el log correspondiente...
						$this->objeto->grabar_log($attack_ip,'SPAM_PROTECTION',$spam_protection_description,'SPAM_PROTECTION',$request_uri,$this->reason,'---');
						
						$you_are_spammer = Text::_('PLG_SECURITYCHECKPRO_YOU_ARE_SPAMMER');
						Factory::getApplication()->enqueueMessage($you_are_spammer, 'error');
						// Tenemos que devolver 'false' para que el proceso de registro del nuevo usuario no termine
						return false;
					}
				}
			} else {
				// No existe ninguna versin de Securitycheck instalada
				
				// El usuario es nuevo y est marcado como spammer
				if ( ($isnew) && ($spammer) ) {	
					$you_are_spammer = Text::_('PLG_SECURITYCHECKPRO_YOU_ARE_SPAMMER');
					Factory::getApplication()->enqueueMessage($you_are_spammer, 'error');
					// Tenemos que devolver 'false' para que el proceso de registro del nuevo usuario no termine
					return false;
				}		
			}
		}
	}
	
	/* Funcin que controla el nombre es de ciertos tipos */
	private function check_name($name,$username){
		
		$name_to_array = explode(" ",$name);
		
		// $name_to_array[0] will contain the first name and $name_to_array[1] the last name
		
		if ( (is_array($name_to_array)) && (count($name_to_array)>1) ){
			// tipo 'Aarondox AarondoxJW'
			if (stristr($name_to_array[1],$name_to_array[0])) {			
				$this->reason .= Text::_('PLG_SECURITYCHECKPRO_NAME_MALFORMED') .$name;
				return true;
			}
			
			// tipo 'HXGrIcgvt oFcsEdBAMhYW'
			$mixed_case = $name;
			$lower_case = strtolower($mixed_case);
			$similar = similar_text($mixed_case, $lower_case);
			
			$number_of_capital_letters = strlen($mixed_case) - $similar;
						
			if ( ($similar >=10) && ($number_of_capital_letters > 4) ) {
				$this->reason .= Text::_('PLG_SECURITYCHECKPRO_NAME_MALFORMED') .$name;
				return true;
			}
		} else {			
			if (!empty($username)) {
				// tipo nombre 'CrguURskTHMEmSGf', username 'jhKCVsoPfRWqSY'
				$mixed_case = $name;
				$lower_case = strtolower($mixed_case);
				$similar = similar_text($mixed_case, $lower_case);
				
				$number_of_capital_letters = strlen($mixed_case) - $similar;		
				
				if ( ($similar >=5) && ($number_of_capital_letters > 4) ) {
					$this->reason .= Text::_('PLG_SECURITYCHECKPRO_NAME_MALFORMED') .$name;
					return true;
				}
			} else {
				// We are not checking the username, tipo nombre 'CrguURskTHMEmSGf'
				$mixed_case = $name;
				$lower_case = strtolower($mixed_case);
				$similar = similar_text($mixed_case, $lower_case);
				
				$number_of_capital_letters = strlen($mixed_case) - $similar;
				// El nombre tiene nmeros, como '2009NETWORK'. En este caso no debemos marcarlo como spam
				$number_of_numbers = preg_match_all( "/[0-9]/", $name );
								
				if ( (strlen($name) > 8) && ( ($number_of_capital_letters < strlen($name)) && ($number_of_capital_letters > 3) && ($number_of_numbers == 0) ) ) {
					$this->reason .= Text::_('PLG_SECURITYCHECKPRO_NAME_MALFORMED') .$name;
					return true;
				}
			}
			
		}
		
		return false;
		
	}
	
	/* Funcin que controla si un usuario, ip o email estn catalogados como spammer en STOPFORUMSPAM */
	private function check_spammer($username, $ip, $email, $spammer_limit) {
		// Inicializamos las variables
		$is_spammer = false;
		$parsedResponse = '';
		
				
		$URL = 'http://www.stopforumspam.com/api?';
		if (!$email=='') { $URL .= 'email='.$email;  }
		if (!$ip=='')   { $URL .= '&ip='.$ip; 	   }
		if (!$username=='') { $URL .= '&username='.$username; }
		
		if ( function_exists('curl_init') ) {
			$curl = @curl_init();
			curl_setopt($curl, CURLOPT_URL, $URL);
			curl_setopt($curl, CURLOPT_VERBOSE, 1);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_HEADER, 0);
			
			$response = @curl_exec($curl);
			curl_close($curl);
		} else {
			return $is_spammer;
		}
		
		if(strpos($response, 'rate limit exceeded') !== FALSE) {
			return $is_spammer;
		} else {			
			if(strpos($response, '<') === 0) {
				// Read the result into a SimpleXML
				$element = new \SimpleXMLElement($response);				
					
				// At least one issues (email, ip, username) should be reported
				$frequency_array = array();
				foreach($element->frequency as $frequency){ 
					$frequency_array[] = (int)$frequency;
				}
					
				// Only data that reachs the 'spammer_limit' will be consider as spammer
				if (max($frequency_array) >= $spammer_limit) {
					$cnt = 0;
					foreach($element->type as $type)
					{
						switch((string)$type) {
							case "email":
								if ($element->appears[$cnt] == "yes") {
									$is_spammer = TRUE;
									$this->reason .= Text::_('PLG_SECURITYCHECKPRO_EMAIL_FREQUENCY') .$element->frequency[$cnt] .Text::_('PLG_SECURITYCHECKPRO_LAST_SEEN') .$element->lastseen[$cnt] .'; ';
								}
								break;
							case "ip":
								if ($element->appears[$cnt] == "yes") {
									$is_spammer = TRUE;
									$this->reason .= Text::_('PLG_SECURITYCHECKPRO_IP_FREQUENCY') .$element->frequency[$cnt] .Text::_('PLG_SECURITYCHECKPRO_LAST_SEEN') .$element->lastseen[$cnt] .'; ';									
								}
								break;
							case "username":
								if ($element->appears[$cnt] == "yes") {
									$is_spammer = TRUE;
									$this->reason .= Text::_('PLG_SECURITYCHECKPRO_USERNAME_FREQUENCY') .$element->frequency[$cnt] .Text::_('PLG_SECURITYCHECKPRO_LAST_SEEN') .$element->lastseen[$cnt] .'; ';
								}
								break;
						}
						$cnt = $cnt + 1;
					} 
					
					return $is_spammer;				
					
				} 
					
			} 
		} 
		
	}
	
	public function onContentPrepareForm($form,$data) {
		
		$app = Factory::getApplication();
		$is_frontend = $app->isClient('site');
				
		// Is the plugin enabled? And are we in frontend?
        if ( ($this->plugin_enabled) && ($is_frontend) )
		{
			$document = Factory::getDocument();
			
			if (!($document instanceof \Joomla\CMS\Document\HtmlDocument))
			{
				return;
			}
			
			$style = ".my-own-class {opacity: 0; position: absolute; top: 0; left: 0; height: 0; width: 0; z-index: -1;}";
			$document->addStyleDeclaration($style);
			
											
			foreach ($this->forms as $form)
			{
				$field_name =  $this->field_name . $form;
				
				$document->addScriptDeclaration("
					document.addEventListener(\"DOMContentLoaded\", function(event) {
												
						const form = document.getElementById(\"{$form}\");
						if(form === null || form === undefined) {							
						} else {															
							const el = document.createElement(\"input\");
							el.className = \"my-own-class\";
							el.id = \"{$field_name}\";
							el.name = \"{$field_name}\";
						
							form.appendChild(el);						
							document.getElementById(\"{$field_name}\").tabIndex = \"-1\";
						}
						
					});						
				");	
			}			
		}
		
	}
	
	
	
	public function onContentPrepare($context, &$article, &$params, $page) {
		
		$app = Factory::getApplication();
		$is_frontend = $app->isClient('site');
				
		// Is the plugin enabled? And are we in frontend?
        if ( ($this->plugin_enabled) && ($is_frontend) )
		{
			$document = Factory::getDocument();
			
			if (!($document instanceof \Joomla\CMS\Document\HtmlDocument))
			{
				return;
			}
						
			$style = ".my-own-class {opacity: 0; position: absolute; top: 0; left: 0; height: 0; width: 0; z-index: -1;}";
			$document->addStyleDeclaration($style);
									
			foreach ($this->forms as $form)
			{
				$field_name =  $this->field_name . $form;
				
				$document->addScriptDeclaration("
					document.addEventListener(\"DOMContentLoaded\", function(event) {
												
						const form = document.getElementById(\"{$form}\");
						if(form === null || form === undefined) {							
						} else {															
							const el = document.createElement(\"input\");
							el.className = \"my-own-class\";
							el.id = \"{$field_name}\";
							el.name = \"{$field_name}\";
						
							form.appendChild(el);						
							document.getElementById(\"{$field_name}\").tabIndex = \"-1\";
						}
						
					});						
				");	
			}			
		}
	}
	
	function onAfterInitialise()
	{
		// Is the plugin enabled?
        if ($this->plugin_enabled)
		{
			$object = Factory::getApplication()->input;
								
			foreach ($this->forms as $form)
			{
				$name_fake_var = $this->field_name . $form;
				$name_fake = $object->getString($name_fake_var);
							
				if (!empty($name_fake)) {
								
					// Grabamos el log correspondiente...
					if ( $this->spammer_write_log == 1 ) {						

						$attack_ip = $this->objeto->get_ip();
						$request_uri = $_SERVER['REQUEST_URI'];			
						// Sanitize params
						$request_uri = htmlspecialchars($request_uri, ENT_QUOTES);
						
						$user = Factory::getUser();
														
						$this->reason = Text::_('PLG_SECURITYCHECKPRO_FIELD_NAME') .$name_fake_var;
						
						$honyepot_protection_description = Text::_('PLG_SECURITYCHECKPRO_HONEYPOT_PROTECTION_DESCRIPTION');
						$this->objeto->grabar_log($this->logs_attacks,$attack_ip,'SPAM_PROTECTION',$honyepot_protection_description,'SPAM_PROTECTION',$request_uri,$this->reason,$user->username,'---');
					}
					
					// Si est marcada la opcin, aadimos la IP a la lista negra dinmica
					if ( $this->spammer_action == 1 ){
						$this->objeto->actualizar_lista_dinamica($attack_ip);					
					}
					
					header('HTTP/1.1 403 Forbidden');
					die();
					
				}
			}
		}
		
	}

}