<?php
/**
 * @package DJ-Tabs
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email: contact@dj-extensions.com
 */

defined('_JEXEC') or die( 'Restricted access' );
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
class DJTabsViewThemes extends HtmlView
{
	protected $items;
	protected $pagination;
	protected $state;
	
	public function display($tpl = null)
	{
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		$this->items = $this->items ? $this->items : array();

		$this->filterForm = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
	
		$this->addToolbar();
		if (class_exists('Sidebar') && version_compare(JVERSION, '4', '<')){
			$this->sidebar = Sidebar::render();
		}
		$this->bs_cl = DJTabsAdminHelper::getBSClasses();
		
		parent::display($tpl);
	}
	
	protected function addToolbar()
	{
		ToolbarHelper::title(Text::_('COM_DJTABS').' · '.Text::_('COM_DJTABS_THEMES'), 'themes');
		$doc = Factory::getDocument();
		$doc->addStyleDeclaration('.icon-48-themes { background-image: url(components/com_djtabs/assets/icon-48-themes.png); }');
		
		ToolbarHelper::addNew('theme.add','JTOOLBAR_NEW');
		ToolbarHelper::editList('theme.edit','JTOOLBAR_EDIT');
		ToolbarHelper::deleteList('', 'themes.delete','JTOOLBAR_DELETE');
		ToolbarHelper::divider();
		ToolbarHelper::custom('themes.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
		ToolbarHelper::custom('themes.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
		ToolbarHelper::divider();
		ToolbarHelper::preferences('com_djtabs', 550, 500);
		
	}
}