<?php

/**
 * @copyright
 * @package    Easy Joomla Backup Pro - EJB for Joomla! 5.x
 * @author     Viktor Vogel <admin@kubik-rubik.de>
 * @version    5.0.1.0-PRO - 2024-01-29
 * @link       https://kubik-rubik.de/ejb-easy-joomla-backup
 *
 * @license    GNU/GPL
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace KubikRubik\Component\EasyJoomlaBackup\Administrator\View\Create;

defined('_JEXEC') || die('Restricted access');

use Exception;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\{Factory, Language\Text, Toolbar\Toolbar, HTML\HTMLHelper, Toolbar\ToolbarHelper, Component\ComponentHelper};
use KubikRubik\Component\EasyJoomlaBackup\Administrator\Helper\EasyJoomlaBackupHelper;

use function defined;

/**
 * Class HtmlView
 *
 * @version 5.0.0.1-PRO
 * @since   5.0.0.0-PRO
 */
class HtmlView extends BaseHtmlView
{
    /**
     * @var string $backupTask
     * @since 5.0.0.0-PRO
     */
    protected string $backupTask = '';

    /**
     * @var bool $encryptBackupArchive
     * @since 5.0.0.0-PRO
     */
    protected bool $encryptBackupArchive = false;

    /**
     * @var bool $encryptBackupArchiveAllowed
     * @since 5.0.0.0-PRO
     */
    protected bool $encryptBackupArchiveAllowed = false;

    /**
     * @param null|string $tpl
     *
     * @return void
     * @throws Exception
     * @since   5.0.0.0-PRO
     */
    public function display($tpl = null): void
    {
        $task = Factory::getApplication()->input->get('task');

        if ($task === 'fullbackup') {
            ToolbarHelper::title(Text::_('COM_EASYJOOMLABACKUP') . ' - ' . Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUP_FULLBACKUP'), 'cube');
        } elseif ($task === 'databasebackup') {
            ToolbarHelper::title(Text::_('COM_EASYJOOMLABACKUP') . ' - ' . Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUP_DATABASEBACKUP'), 'cube');
        } elseif ($task === 'filebackup') {
            ToolbarHelper::title(Text::_('COM_EASYJOOMLABACKUP') . ' - ' . Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUP_FILEBACKUP'), 'cube');
        }

        $bar = Toolbar::getInstance();
        $buttonText = '<span class="icon-new icon-white"></span> ' . Text::_('COM_EASYJOOMLABACKUP_CREATEBACKUP_BUTTON');
        $buttonModal = HTMLHelper::_('link', '#create-backup-modal', $buttonText, ['id' => 'create-backup', 'class' => 'btn btn-small button-new btn-success', 'data-bs-toggle' => 'modal', 'data-bs-target' => '#create-backup-modal']);
        $bar->customButton('customButtonModal')->html($buttonModal);

        ToolbarHelper::cancel();

        $this->backupTask = 'backupCreate' . ucwords($task);
        $this->encryptBackupArchive = (bool)ComponentHelper::getParams('com_easyjoomlabackup')->get('encryptBackupArchive', false);
        $this->encryptBackupArchiveAllowed = EasyJoomlaBackupHelper::checkEncryptArchive();
        $this->loadEncryptionJavaScript();

        Factory::getApplication()->getDocument()->addStyleSheet('components/com_easyjoomlabackup/src/Assets/Css/easyjoomlabackup.min.css');
        EasyJoomlaBackupHelper::showMessages();

        parent::display($tpl);
    }

    /**
     * Loads the JavaScript for the encryption validation
     *
     * @throws Exception
     * @since 5.0.0.0-PRO
     */
    private function loadEncryptionJavaScript(): void
    {
        if (!$this->encryptBackupArchive || !$this->encryptBackupArchiveAllowed) {
            return;
        }

        $js = "jQuery(document).ready(function() {
            const buttonBackup = jQuery('a#create-backup');
    
            const passwordCheck = setInterval(function() {
                let password = jQuery('#password').val();
                let password2 = jQuery('#password2').val();
    
                if (password !== password2) {
                    buttonBackup.attr('href', '#');
                    buttonBackup.attr('data-bs-target', '#');
                } else {
                    buttonBackup.attr('href', '#create-backup-modal');
                    buttonBackup.attr('data-bs-target', '#create-backup-modal');
                }
            }, 1000);
    
            buttonBackup.click(function() {
                let password = jQuery('#password').val();
                let password2 = jQuery('#password2').val();
    
                if (password === password2) {
                    clearInterval(passwordCheck);
                } else {
                    alert('" . $this->escape(Text::_('COM_EASYJOOMLABACKUP_ARCHIVEPASSWORD_VALIDATION_ERROR')) . "');
                }
            });
        });";

        Factory::getApplication()->getDocument()->addScriptDeclaration($js);
    }
}
