<?php
namespace JExtstore\Component\Gdpr\Administrator\Field;
/**  
 * @package GDPR::CONFIG::administrator::components::com_gdpr 
 * @subpackage Field
 * @author Joomla! Extensions Store
 * @Copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */ 
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

/**
 * Form Field for ACL Groups
 * @package GDPR::CONFIG::administrator::components::com_gdpr 
 * @subpackage Field
 * @since 1.0
 */
class AclgroupsmultiselectField extends ListField {
	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 * @since  11.1
	 */
	protected $type = 'aclgroupsmultiselect';
	
	/**
	 * Method to get the field input markup for a generic list.
	 * Use the multiple attribute to enable multiselect.
	 *
	 * @return string The field input markup.
	 *        
	 * @since 11.1
	 */
	protected function getInput() {
		// Initialize variables.
		$html = array ();
		$attr = '';
		
		// Default option translation
		$defaultTranslation = $this->element ['translation'] ? Text::_($this->element ['translation']) : Text::_('COM_GDPR_ALLGROUPS');
		
		// Initialize some field attributes.
		$attr .= $this->element ['class'] ? ' class="form-select ' . ( string ) $this->element ['class'] . '"' : ' class="form-select"';
		
		// To avoid user's confusion, readonly="true" should imply
		// disabled="true".
		if (( string ) $this->element ['readonly'] == 'true' || ( string ) $this->element ['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}
		
		$attr .= $this->element ['size'] ? ' size="' . ( int ) $this->element ['size'] . '"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';
		
		// Initialize JavaScript field attributes.
		$attr .= $this->element ['onchange'] ? ' onchange="' . ( string ) $this->element ['onchange'] . '"' : '';
		
		// Get the field options.
		$options = ( array ) $this->getOptions ($defaultTranslation);
		
		$html = HTMLHelper::_ ( 'select.genericlist', $options, $this->name, trim ( $attr ), 'value', 'text', $this->value, $this->id );
		
		return $html;
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   11.1
	 */
	protected function getOptions($defaultTranslation = null) {
		$db = Factory::getContainer()->get('DatabaseDriver');
		$db->setQuery ( 'SELECT a.id AS value, a.title AS text, COUNT(DISTINCT b.id) AS level' . 
						' FROM ' . $db->quoteName ( '#__usergroups' ) . ' AS a' . 
						' LEFT JOIN ' . $db->quoteName ( '#__usergroups' ) . ' AS b' .
						' ON a.lft > b.lft AND a.rgt < b.rgt' . 
						' WHERE a.parent_id > 0' .
						' GROUP BY a.id, a.title, a.lft, a.rgt' . 
						' ORDER BY a.lft ASC' );
		try {
			$options = $db->loadObjectList ();
		} catch(\Exception $e) {
			return array();
		}
		
		$noActiveOption = HTMLHelper::_('select.option', '0', $defaultTranslation);
		$noActiveOption->level = 0;
		array_unshift($options, $noActiveOption);
		
		foreach ( $options as &$option ) {
			$option->text = str_repeat ( '- ', $option->level ) . $option->text;
		}
		
		return $options;
	}
}
