<?php
namespace JExtstore\Component\Gdpr\Administrator\Framework;

/**
 *
 * @package GDPR::administrator::components::com_gdpr
 * @subpackage framework
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

use Joomla\CMS\Document\FactoryInterface as DocumentFactoryInterface;
use Joomla\CMS\Language\LanguageFactoryInterface;
use Joomla\CMS\Version;
use Joomla\CMS\Factory as JFactory;

/**
 * Framework autoloader based on camel case and prefix namespacing
 *
 * @package GDPR::administrator::components::com_gdpr
 * @subpackage framework
 * @since 2.0
 */
abstract class Factory {
	/**
	 * Global language object
	 *
	 * @var Language
	 * @since 1.7.0
	 * @deprecated 5.0 Use the language service in the DI container
	 */
	public static $language = null;
	
	/**
	 * Global document object
	 *
	 * @var Document
	 * @since 1.7.0
	 * @deprecated 5.0 Use the document service in the DI container
	 */
	public static $document = null;
	
	/**
	 * Get a language object.
	 *
	 * Returns the global {@link Language} object, only creating it if it doesn't already exist.
	 *
	 * @return Language object
	 */
	public static function getLanguage() {
		$container = JFactory::getContainer();
		$app = JFactory::getApplication();
		if (! self::$language) {
			$conf = $app->getConfig ();
			$locale = $conf->get ( 'language' );
			$debug = $conf->get ( 'debug_lang' );
			self::$language = $container->get ( LanguageFactoryInterface::class )->createLanguage ( $locale, $debug );
		}
		
		return self::$language;
	}
	
	/**
	 * Get a document object.
	 *
	 * Returns the global {@link \Joomla\CMS\Document\Document} object, only creating it if it doesn't already exist.
	 *
	 * @return Document object
	 */
	public static function createDocument() {
		$container = JFactory::getContainer();
		$app = JFactory::getApplication();
		if (! self::$document) {
			$lang = self::getLanguage ();
			
			$input = $app->getInput();
			$type = $input->get ( 'format', 'html', 'cmd' );
			
			$version = new Version ();
			
			$attributes = array (
					'charset' => 'utf-8',
					'lineend' => 'unix',
					'tab' => "\t",
					'language' => $lang->getTag (),
					'direction' => $lang->isRtl () ? 'rtl' : 'ltr',
					'mediaversion' => $version->getMediaVersion ()
			);
			
			self::$document = $container->get ( DocumentFactoryInterface::class )->createDocument ( $type, $attributes );
		}
		
		return self::$document;
	}
}
