<?php
namespace JExtstore\Component\Gdpr\Administrator\Framework;
/**
 * @package GDPR::FRAMEWORK::administrator::components::com_gdpr
 * @subpackage framework
 * @subpackage view
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;

/**
 * Base view for all display core
 * 
 * @package GDPR::FRAMEWORK::administrator::components::com_gdpr
 * @subpackage framework
 * @subpackage view
 * @since 2.0
 */
class View extends HtmlView {
	/**
	 * User object for ACL authorise check
	 *
	 * @access protected
	 * @var Object
	 */
	protected $user;
	
	/**
	 * Reference to application
	 *
	 * @access public
	 * @var Object
	 */
	public $app;
	
	/**
	 * Document object, needed by views to inject
	 * CSS/JS tags into document output
	 *
	 * @access public
	 * @var Object
	 */
	public $doc;
	
	/**
	 * Reference to option executed
	 *
	 * @access public
	 * @var string
	 */
	public $option;
	
	/**
	 * Inject language constant into JS Domain maintaining same name mapping
	 *
	 * @access protected
	 * @param $translations array
	 * @param $document Object&
	 * @return void
	 */
	protected function injectJsTranslations($translations, $document): void {
		$jsInject = null;
		// Do translations
		foreach ( $translations as $translation ) {
			$jsTranslation = strtoupper ( $translation );
			$translated = Text::_( $jsTranslation, true );
			$jsInject .= <<<JS
			var $translation = '{$translated}';
JS;
		}
		$document->getWebAssetManager()->addInlineScript($jsInject);
	}
	
	/**
	 * Manage injecting jQuery framework into document with class inheritance support
	 *
	 * @access protected
	 * @param Object& $doc
	 * @return void
	 */
	protected function loadJQuery($document, $fullStack = true): void {
		$wa = $document->getWebAssetManager();
		if($fullStack) {
			$wa->useScript('jquery');
			$wa->useScript('jquery-noconflict');
			array_map ( function ($script) use ($wa) {
				$wa->useScript ( 'bootstrap.' . $script );
			}, [
					'collapse',
					'modal',
					'popover',
					'tab'
			] );
		} else {
			$wa->useScript('jquery');
			$wa->useScript('jquery-noconflict');
		}
		
		$wa->useScript('core');
		
		// jQuery foundation framework
		$wa->registerAndUseScript('gdpr.jstorage', 'administrator/components/com_gdpr/js/jstorage.min.js', [], [], ['jquery']);
	}
	
	/**
	 * Manage injecting Bootstrap framework into document
	 *
	 * @access protected 
	 * @param Object& $doc
	 * @return void
	 */
	protected function loadBootstrap($document): void {
		// Main styles for admin interface
		$document->getWebAssetManager()->registerAndUseStyle('gdpr.boostrap-interface', 'administrator/components/com_gdpr/css/bootstrap-interface.css');
	
		if(version_compare(JVERSION, '5', '>=')) {
			$document->getWebAssetManager()->registerAndUseStyle ( 'gdpr.dark-theme', 'administrator/components/com_gdpr/css/dark-theme.css');
		}
		
		// Main JS file for admin interface
		$document->getWebAssetManager()->registerAndUseScript ( 'gdpr.boostrap-interface', 'administrator/components/com_gdpr/js/bootstrap-interface.js', [], [], ['jquery']);
	}
	
	/**
	 * Manage injecting valildation plugin into document
	 *
	 * @access protected
	 * @param Object& $doc
	 * @return void
	 */
	protected function loadValidation($document): void {
		$document->getWebAssetManager()->registerAndUseStyle('gdpr.simplevalidation', 'administrator/components/com_gdpr/css/simplevalidation.css');

		$document->getWebAssetManager()->registerAndUseScript ( 'gdpr.simplevalidation', 'administrator/components/com_gdpr/js/jquery.simplevalidation.js', [], [], ['jquery']);
	}
	
	/**
	 * Manage injecting jQuery UI framework into document
	 *
	 * @access protected
	 * @param Object& $doc
	 * @return void
	 */
	protected function loadJQueryUI($document): void {
		$document->getWebAssetManager()->registerAndUseStyle('gdpr.jquery-ui', 'administrator/components/com_gdpr/css/jqueryui/jquery-ui.custom.min.css');

		$document->getWebAssetManager()->registerAndUseScript ( 'gdpr.jqueryui', 'administrator/components/com_gdpr/js/jquery-ui.min.js', [], [], ['jquery']);
	}
	
	/**
	 * Class constructor
	 *
	 * @param array $config
	 *        	return Object
	 */
	public function __construct($config = array()) {
		parent::__construct ( $config );
		
		$this->app = Factory::getApplication ();
		$this->option = $this->app->getInput()->get ( 'option' );
		$this->user = $this->app->getIdentity();
		$this->doc = $this->app->getDocument();
	}
}