<?php
namespace JExtstore\Component\Gdpr\Administrator\Table;
/**
 * @package GDPR::COOKIEDESCRIPTIONS::administrator::components::com_gdpr
 * @subpackage tables
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Table\Table;
use JExtstore\Component\Gdpr\Administrator\Framework\Exception\Exceptions;

/**
 * Cookie descriptions ORM
 *
 * @package GDPR::RECORD::administrator::components::com_gdpr
 * @subpackage tables
 * @since 1.9.4
 */
class CookiedescriptionsTable extends Table {
	use Exceptions;
	
	/**
	 * @public int Primary key
	 */
	public $id = null;
	
	/**
	 * @public string
	 */
	public $cookie = null;
	
	/**
	 * @var int
	 */
	public $category = null;
	
	/**
	 * @public string
	 */
	public $descriptionhtml = null;
	
	/**
	 * @public string
	 */
	public $expiration = null;
	
	/**
	 * @public string
	 */
	public $alias = null;
	
	/**
	 * @var int
	 */
	public $checked_out = null;
	
	/**
	 * @var datetime
	 */
	public $checked_out_time = null;
	
	/**
	 * @var int
	 */
	public $published = 1;
	
	/**
	 * Class constructor
	 * @param DatabaseDriver $db DatabaseDriver object.
	 * @param DispatcherInterface  $dispatcher  Event dispatcher for this table
	 *
	 * return Object&
	 */
	public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null) {
		parent::__construct ( '#__gdpr_cookie_descriptions', 'id', $db, $dispatcher );
		
		// Support null values for datetime field
		$this->_supportNullValue = true;
	}
}