<?php 
/** 
 * @package GDPR::CPANEL::administrator::components::com_gdpr
 * @subpackage views
 * @subpackage cpanel
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2018 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html 
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Language\LanguageHelper;
$gdprCategoryEnabled = false;

// Manage frontend translation overrides
$language = Factory::getLanguage()->getTag();
$strings = LanguageHelper::parseIniFile(JPATH_ROOT . '/language/overrides/' . $language . '.override.ini');

$category1Name = $this->componentParams->get('cookie_category1_name', 'Necessary');
$category1String = array_key_exists($category1Name, $strings) ? $strings[$category1Name] : Text::_($category1Name);

$category2Name = $this->componentParams->get('cookie_category2_name', 'Preferences');
$category2String = array_key_exists($category2Name, $strings) ? $strings[$category2Name] : Text::_($category2Name);

$category3Name = $this->componentParams->get('cookie_category3_name', 'Statistics');
$category3String = array_key_exists($category3Name, $strings) ? $strings[$category3Name] : Text::_($category3Name);

$category4Name = $this->componentParams->get('cookie_category4_name', 'Marketing');
$category4String = array_key_exists($category4Name, $strings) ? $strings[$category4Name] : Text::_($category4Name);
?>
<!-- CPANEL ICONS -->
<div class="row no-margin">
	<div class="card card-default accordion-group col-lg-5 p-0 span5 gdpr_accordion_cpanel_btns">
		<div class="card-header accordion-toggle accordion_lightblue p-3 noaccordion">
			<h4 class="card-title m-0"><span class="icon-pencil" aria-hidden="true"></span><?php echo Text::_('COM_GDPR_CPANEL_TASKS' ); ?></h4>
		</div>
		<div id="placeholder_cpanelicons" class="card-body card-block card-block-whitebg accordion-body">
			<div id="cpanel" class="ps-2 pt-2">
				<?php echo $this->icons; ?>
			
				<div id="updatestatus">
					<?php 
					if(is_object($this->updatesData)) {
						if(version_compare($this->updatesData->latest, $this->currentVersion, '>')) { ?>
							<a href="https://storejextensions.org/extensions/gdpr.html" target="_blank" alt="storejoomla link">
								<label data-bs-content="<?php echo Text::sprintf('COM_GDPR_GET_LATEST', $this->currentVersion, $this->updatesData->latest, $this->updatesData->relevance);?>" class="badge bg-danger hasPopover">
									<span class="icon-warning" aria-hidden="true"></span>
									<?php echo Text::sprintf('COM_GDPR_OUTDATED', $this->updatesData->latest);?>
								</label>
							</a>
						<?php } else { ?>
							<label data-bs-content="<?php echo Text::sprintf('COM_GDPR_YOUHAVE_LATEST', $this->currentVersion);?>" class="badge bg-success hasPopover">
								<span class="icon-checkmark" aria-hidden="true"></span>
								<?php echo Text::sprintf('COM_GDPR_UPTODATE', $this->updatesData->latest);?>
							</label>	
						<?php }
					}
					?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="col-lg-7 span7 accordion" id="gdpr_accordion_cpanel">
		<div class="card card-default accordion-group">
	    	<div class="card-header p-0 accordion-heading">
	    		<div class="accordion-toggle" data-bs-toggle="collapse" data-bs-target="#gdpr_stats">
		      		<h4 class="card-title m-3 accordion-title">
		      			<span class="icon-chart" aria-hidden="true"></span>
		      			<?php echo Text::_('COM_GDPR_CPANEL_STATS');?>
	      			</h4>
	      		</div>
	    	</div>
	    	
	    	 <div id="gdpr_stats" data-bs-parent="#gdpr_accordion_cpanel" class="card-body card-block card-block-whitebg accordion-body accordion-chart collapse">
				<div class="accordion-inner">
					<?php if($this->componentParams->get('enable_log_cookie_consent', 1)):?>
						<?php if($this->componentParams->get('cookie_category1_enable', 0)):?>
							<div class="single_stat_container">
								<div class="statcircle">
									<span class="icon-users icon-large" aria-hidden="true"></span>
								</div>
								<ul class="subdescription_stats">
									<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_cookies_canvas']['category1']; ?>%</li>
									<li class="es-stat-title" data-bind="cat1" data-name="  <?php echo $category1String;?>"><?php echo Text::sprintf('COM_GDPR_COOKIE_CATEGORY_CHART', $category1String);?></li>
								</ul>
							</div>
						<?php 
							$gdprCategoryEnabled = true;
							endif;
						?>
						<?php if($this->componentParams->get('cookie_category2_enable', 0)):?>
							<div class="single_stat_container">
								<div class="statcircle">
									<span class="icon-users icon-large" aria-hidden="true"></span>
								</div>
								<ul class="subdescription_stats">
									<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_cookies_canvas']['category2']; ?>%</li>
									<li class="es-stat-title" data-bind="cat2" data-name="<?php echo $category2String;?>"><?php echo Text::sprintf('COM_GDPR_COOKIE_CATEGORY_CHART', $category2String);?></li>
								</ul>
							</div>
						<?php 
							$gdprCategoryEnabled = true;
							endif;
						?>
						<?php if($this->componentParams->get('cookie_category3_enable', 0)):?>
							<div class="single_stat_container">
								<div class="statcircle">
									<span class="icon-users icon-large" aria-hidden="true"></span>
								</div>
								<ul class="subdescription_stats">
									<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_cookies_canvas']['category3']; ?>%</li>
									<li class="es-stat-title" data-bind="cat3" data-name="<?php echo $category3String;?>"><?php echo Text::sprintf('COM_GDPR_COOKIE_CATEGORY_CHART', $category3String);?></li>
								</ul>
							</div>
						<?php 
							$gdprCategoryEnabled = true;
							endif;
						?>
						<?php if($this->componentParams->get('cookie_category4_enable', 0)):?>
							<div class="single_stat_container">
								<div class="statcircle">
									<span class="icon-users icon-large" aria-hidden="true"></span>
								</div>
								<ul class="subdescription_stats">
									<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_cookies_canvas']['category4']; ?>%</li>
									<li class="es-stat-title" data-bind="cat4" data-name="<?php echo $category4String;?>"><?php echo Text::sprintf('COM_GDPR_COOKIE_CATEGORY_CHART', $category4String);?></li>
								</ul>
							</div>
						<?php 
							$gdprCategoryEnabled = true;
							endif;
						?>
						
						<div class="single_stat_container <?php echo $gdprCategoryEnabled ? 'divisor' : '';?>">
							<div class="statcircle">
								<span class="icon-users icon-large" aria-hidden="true"></span>
							</div>
							<ul class="subdescription_stats">
								<li class="es-stat-no"><?php echo $this->infodata['off_canvas']['all_cookies_categories_accepted']; ?></li>
								<li class="es-stat-title"><?php echo Text::_('COM_GDPR_ALL_COOKIES_CATEGORIES_ACCEPTED');?></li>
							</ul>
						</div>
						
						<div class="single_stat_container">
							<div class="statcircle">
								<span class="icon-pie icon-large" aria-hidden="true"></span>
							</div>
							<ul class="subdescription_stats">
								<li class="es-stat-no"><?php echo $this->infodata['off_canvas']['total_cookie_percentage']; ?></li>
								<li class="es-stat-title"><?php echo Text::_('COM_GDPR_TOTAL_COOKIE_PERCENTAGE');?></li>
							</ul>
						</div>
						
						<?php if($gdprCategoryEnabled):?>
							<div class="chart_container">
								<canvas id="chart_gdpr_cookies_canvas"></canvas>
							</div>
							<hr/>
						<?php endif;?>
					<?php endif;?>
					
					<div class="single_stat_container">
						<div class="statcircle">
							<span class="icon-users icon-large" aria-hidden="true"></span>
						</div>
						<ul class="subdescription_stats">
							<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_canvas']['new']; ?></li>
							<li class="es-stat-title"><?php echo Text::_('COM_GDPR_NEW_CHART');?></li>
						</ul>
					</div>
					
					<div class="single_stat_container">
						<div class="statcircle">
							<span class="icon-users icon-large" aria-hidden="true"></span>
						</div>
						<ul class="subdescription_stats">
							<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_canvas']['deleted']; ?></li>
							<li class="es-stat-title"><?php echo Text::_('COM_GDPR_DELETED_CHART');?></li>
						</ul>
					</div>
					
					<div class="single_stat_container">
						<div class="statcircle">
							<span class="icon-users icon-large" aria-hidden="true"></span>
						</div>
						<ul class="subdescription_stats">
							<li class="es-stat-no"><?php echo $this->infodata['chart_gdpr_canvas']['breached']; ?></li>
							<li class="es-stat-title"><?php echo Text::_('COM_GDPR_BREACHED_CHART');?></li>
						</ul>
					</div>
					
					<div class="chart_container">
						<canvas id="chart_gdpr_canvas"></canvas>
					</div>
				</div>
			</div>
		</div>
		
		<div class="card card-default accordion-group">
		    <div class="card-header p-0 accordion-heading">
				<div class="accordion-toggle" data-bs-toggle="collapse" data-bs-target="#gdpr_status">
					<h4 class="card-title m-3 accordion-title">
						<span class="icon-help" aria-hidden="true"></span>
						<?php echo Text::_('COM_GDPR_ABOUT');?>
					</h4>
		      	</div>
	    	</div>
		    <div id="gdpr_status" data-bs-parent="#gdpr_accordion_cpanel" class="card-body card-block accordion-body collapse">
		 		<div class="accordion-inner">
					<div class="single_container">
				 		<label class="badge bg-warning"><?php echo Text::_('COM_GDPR_CURRENT_VERSION') . $this->currentVersion;?></label>
			 		</div>
			 		<div class="single_container">
				 		<label class="badge bg-warning"><?php echo Text::_('COM_GDPR_CHANGELOG');?></label>
			 		</div>
			 		
			 		<div class="single_container">
				 		<label class="badge bg-primary"><?php echo Text::_('COM_GDPR_AUTHOR_COMPONENT');?></label>
			 		</div>
			 		
			 		<div class="single_container">
				 		<label class="badge bg-primary"><?php echo Text::_('COM_GDPR_SUPPORTLINK');?></label>
			 		</div>
			 		
			 		<div class="single_container">
				 		<label class="badge bg-primary"><?php echo Text::_('COM_GDPR_DEMOLINK');?></label>
			 		</div>
				</div>
		    </div>
	 	</div>
	</div>
</div>
<form name="adminForm" id="adminForm" action="index.php">
	<input type="hidden" name="option" value="<?php echo $this->option;?>"/>
	<input type="hidden" name="task" value=""/>
</form>