<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Http\Http;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\Registry\Registry;
use Exception;

define ('SERVER_REMOTE_URI', 'https://updates.simplifyyourweb.com/pro/weblinklogospro/');
define ('SERVER_REMOTE_URI_LICENSE', 'https://simplifyyourweb.com/autoupdates/');

class InfoModel extends BaseDatabaseModel
{
	protected $extensionVersion;

	/**
	 * Get by remote server informations for new updates of this extension
	 *
	 * @access public
	 * @return mixed An object json decoded from server if update information retrieved correctly otherwise false
	 */
	public function getUpdates(Http $httpClient)
	{
		$option = $this->getState('option');
		if (!$option) {
			return false;
		}

		try {
		    $response = $httpClient->get(SERVER_REMOTE_URI . $option . '-j4.json');
		    if ($response->getStatusCode() == 200) {
		        $decodedUpdateInfos = json_decode($response->getBody(), true);
		        return $decodedUpdateInfos;
		    }
		} catch (Exception $e) {
		    return false;
		}

		return false;
	}

	/**
	 * Get by remote server informations for the license state for the extension
	 *
	 * @access public
	 * @return mixed An object json decoded from server if update information retrieved correctly otherwise false
	 */
	public function getLicenseState(Http $httpClient)
	{
	    // get the download id, if any

	    if (!PluginHelper::isEnabled('installer', 'wlpinstaller')) { // the plugin does not exist
	        return array('download_id' => '');
	    }

	    $installer_plugin = PluginHelper::getPlugin('installer', 'wlpinstaller');

	    $params = new Registry();
	    $params->loadString($installer_plugin->params);

	    $downloadId = $params->get('download_id', '');

	    if (empty($downloadId)) {
	        return array('download_id' => '');
	    }

	    // get the license info

	    $url = SERVER_REMOTE_URI_LICENSE.'check.php?dlid='.$downloadId;

	    $license_status = array('download_id' => $downloadId);

	    try {
	        $response = $httpClient->get($url)->body;
	        if ($response) {
	            $status = json_decode($response, true);
	            if (!empty($status)) {
	                $license_status = array_merge($license_status, $status);
	            }
	        }
	    } catch(\Exception $e) {
	        return $license_status;
	    }

	    return $license_status;
	}

}
