<?php
/**
 * @copyright	Copyright (C) 2011 Simplify Your Web, Inc. All rights reserved.
 * @license		GNU General Public License version 3 or later; see LICENSE.txt
 */

namespace SYW\Component\WeblinkLogosPro\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Helper\TagsHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\MVC\Model\FormModel;
use Joomla\CMS\Table\Table;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;
use SYW\Library\Cache as SYWCache;

/**
 * Weblink model
 */
class WeblinkModel extends FormModel
{
    private $item = null;

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @return void
     *
     * @since  1.6
     */
    protected function populateState()
    {
        $app = Factory::getApplication('com_weblinklogospro');

        // Load state from the request userState on edit or from the passed variable on default
        if (Factory::getApplication()->input->get('layout') == 'edit') {
            $id = Factory::getApplication()->getUserState('com_weblinklogospro.edit.weblink.id');
        } else {
            $id = Factory::getApplication()->input->get('id');
            Factory::getApplication()->setUserState('com_weblinklogospro.edit.weblink.id', $id);
        }

        $this->setState('weblink.id', $id);

        $return = Factory::getApplication()->input->get('return', null, 'base64');
        if (null != $return) {
        	$this->setState('return_page', base64_decode($return));
        }

        // Load the parameters
        $params = $app->getParams();
        $params_array = $params->toArray();

        if (isset($params_array['item_id'])) {
            $this->setState('weblink.id', $params_array['item_id']);
        }

        $this->setState('params', $params);
    }

    /**
     * Method to get an ojbect.
     *
     * @param   integer $id The id of the object to get.
     *
     * @return Object|boolean Object on success, false on failure.
     *
     * @throws \Exception
     */
    public function getItem($id = null)
    {
        if ($this->item === null)
        {
            $this->item = false;

            if (empty($id)) {
                $id = $this->getState('weblink.id');
            }

            // fix for when the user does not have core.edit permissions but only core.edit.own for instance
            // when returning from save back to the edit page
            // not sure why weblink.id looses the state

            // TODO check if fixed with $this->setState('weblink.id', $table->id); in save($data)
            if (empty($id)) {
                $id = Factory::getApplication()->getUserState('com_weblinklogospro.edit.weblink.id');
            }

            // Get a level row instance.
            $table = $this->getTable();

            if ($table !== false && $table->load($id)) {

                $user = Factory::getUser();
                //$id   = $table->id;

                $canEdit = $user->authorise('core.edit', 'com_weblinklogospro') || $user->authorise('core.create', 'com_weblinklogospro');

                if (!$canEdit && $user->authorise('core.edit.own', 'com_weblinklogospro')) {
                    $canEdit = $user->id == $table->created_by;
                }

                if (!$canEdit) {
                    throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
                }

                // Check published state
                if ($published = $this->getState('filter.published')) {
                    if (isset($table->published) && $table->published != $published) {
                        return $this->item;
                    }
                }

                // Convert the JTable to a clean JObject
                $properties = $table->getProperties(1);
                $this->item = ArrayHelper::toObject($properties, 'JObject');

                // Load item tags
                if (!empty($this->item->id)) {
                    $this->item->tags = new TagsHelper();
                    $this->item->tags->getTagIds($this->item->id, 'com_weblinks.weblink');
                }

            }
        }

        return $this->item;
    }

    /**
    * Get the return URL
    *
    * @return  string	The return URL
    */
    public function getReturnPage()
    {
    	if ($this->getState('return_page') != null) {
    		return base64_encode($this->getState('return_page'));
    	}

    	return '';
    }

    /**
     * Method to get the table
     *
     * @param   string $type   Name of the JTable class
     * @param   string $prefix Optional prefix for the table class name
     * @param   array  $config Optional configuration array for JTable object
     *
     * @return  Table|boolean JTable if found, boolean false on failure
     */
    public function getTable($type = 'Weblink', $prefix = 'Administrator', $config = array())
    {
        //$this->addTablePath(JPATH_ADMINISTRATOR . '/components/com_weblinklogospro/Table/');

    	return parent::getTable($type, $prefix, $config);
    }

    /**
     * Get an item by alias
     *
     * @param   string $alias Alias string
     *
     * @return int Element id
     */
    public function getItemIdByAlias($alias)
    {
        $table = $this->getTable();
        $properties = $table->getProperties();

        if (!in_array('alias', $properties)) {
            return null;
        }

        $table->load(array('alias' => $alias));

        return $table->id;

    }

    /**
     * Method to check in an item.
     *
     * @param   integer $id The id of the row to check out.
     *
     * @return  boolean True on success, false on failure.
     *
     * @since    1.6
     */
    public function checkin($id = null)
    {
        // Get the id.
        $id = (!empty($id)) ? $id : (int) $this->getState('weblink.id');

        if ($id) {
            // Initialise the table
            $table = $this->getTable();

            // Attempt to check the row in.
            if (method_exists($table, 'checkin')) {
                if (!$table->checkin($id)) {
                    return false;
                }
            }
        }

        return true;

    }

    /**
     * Method to check out an item for editing.
     *
     * @param   integer $id The id of the row to check out.
     *
     * @return  boolean True on success, false on failure.
     *
     * @since    1.6
     */
    public function checkout($id = null)
    {
        // Get the user id.
        $id = (!empty($id)) ? $id : (int) $this->getState('weblink.id');

        if ($id) {
            // Initialise the table
            $table = $this->getTable();

            // Get the current user object.
            $user = Factory::getUser();

            // Attempt to check the row out.
            if (method_exists($table, 'checkout')) {
                if (!$table->checkout($user->get('id'), $id)) {
                    return false;
                }
            }
        }

        return true;

    }

    /**
     * Method to get the profile form.
     *
     * The base form is loaded from XML
     *
     * @param   array   $data     An optional array of data for the form to interogate.
     * @param   boolean $loadData True if the form is to load its own data (default case), false if not.
     *
     * @return    Form    A Form object on success, false on failure
     *
     * @since    1.6
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm('com_weblinklogospro.weblink', 'weblink', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)) {
            return false;
        }

        return $form;
    }

    protected function preprocessForm(Form $form, $data, $group = 'content')
    {
        FormHelper::addFieldPrefix('SYW\Library\Field');

        $customfields = array();
        if (Folder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '1')) {

            $config = ComponentHelper::getParams('com_weblinklogospro');
            $edit_group_fields = $config->get('edit_group_fields'); // array of objects

            $selected_groups = array('0'); // keep only ungrouped fields and selected grouped fields

            if (isset($edit_group_fields) && !is_string($edit_group_fields)) {
                foreach ($edit_group_fields as $edit_group_field) {
                    $selected_groups[] = $edit_group_field->group;
                }
            }

            $customfields = FieldsHelper::getFields('com_weblinks.weblink');

            // organize the fields according to their group

            $fieldTypes = FieldsHelper::getFieldTypes();

            $fieldsPerGroup = array(0 => array());
            //$groupTitle = array(0 => Text::_('JGLOBAL_FIELDS'));

            foreach ($customfields as $field) {

                if (!array_key_exists($field->type, $fieldTypes)) { // field type is not available
                    continue;
                }

                if (!in_array($field->group_id, $selected_groups)) {
                    continue;
                }

                if (!array_key_exists($field->group_id, $fieldsPerGroup)) {
                    $fieldsPerGroup[$field->group_id] = array();
                    //$groupTitle[$field->group_id] = $field->group_title;
                }

                if ($path = $fieldTypes[$field->type]['path']) {
                    FormHelper::addFieldPath($path); // add the lookup path for the field
                }

                if ($path = $fieldTypes[$field->type]['rules']) {
                    FormHelper::addRulePath($path); // add the lookup path for the rule
                }

                $fieldsPerGroup[$field->group_id][] = $field;
            }

            $xml = new \DOMDocument('1.0', 'UTF-8');
            $fieldsNode = $xml->appendChild(new \DOMElement('form'))->appendChild(new \DOMElement('fields'));
            $fieldsNode->setAttribute('name', 'customfields');

            // loop trough the groups

            foreach ($fieldsPerGroup as $group_id => $groupFields) {

                if (!$groupFields) {
                    continue;
                }

                $fieldset = $fieldsNode->appendChild(new \DOMElement('fieldset'));
                $fieldset->setAttribute('name', 'fields_'.$group_id);

                foreach ($groupFields as $field) {
                    try {
                        Factory::getApplication()->triggerEvent('onCustomFieldsPrepareDom', array($field, $fieldset, $form));
                    } catch (\Exception $e) {
                        Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
                    }
                }
            }

            $form->load($xml->saveXML());
        }

        parent::preprocessForm($form, $data, $group);
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return    mixed    The data for the form.
     *
     * @since    1.6
     */
    protected function loadFormData()
    {
        $data = Factory::getApplication()->getUserState('com_weblinklogospro.edit.weblink.data', array());

        if (empty($data)) {
            $data = $this->getItem();

            // load custom fields

            if (Folder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '1')) {

                $config = ComponentHelper::getParams('com_weblinklogos');
                $edit_group_fields = $config->get('edit_group_fields', array()); // object of objects
                if (is_string($edit_group_fields)) {
                    $edit_group_fields = array();
                }

                $selected_groups = array('0'); // keep only ungrouped fields and selected grouped fields

                if (is_object($edit_group_fields) && !empty($edit_group_fields)) {
                    foreach ($edit_group_fields as $edit_group_field) {
                        $selected_groups[] = $edit_group_field->group;
                    }
                }

                if (empty($this->item->id)) {
                    $fields = FieldsHelper::getFields('com_weblinks.weblink');
                } else {
                    $fields = FieldsHelper::getFields('com_weblinks.weblink', $this->item);
                }

                if (!empty($fields)) {
                    $data->customfields = array();
                    foreach ($fields as $field) {

                        if (!in_array($field->group_id, $selected_groups)) {
                            continue;
                        }

                        if (isset($field->rawvalue)) {
                            $data->customfields[$field->name] = $field->rawvalue;
                        } else {
                            $data->customfields[$field->name] = null;
                        }
                    }
                }
            }

            // load specific params fields
            // {"target":"","width":"","height":"","count_clicks":"1"}

            //$params = json_decode($data->params);
            $data->params = new Registry($data->params);

//             $data->target = '';
//             if (isset($params->target)) {
//                 $data->target = $params->target;
//             }

//             $data->width = '';
//             if (isset($params->width)) {
//                 $data->width = $params->width;
//             }

//             $data->height = '';
//             if (isset($params->height)) {
//                 $data->height = $params->height;
//             }

//             $data->count_clicks = '';
//             if (isset($params->count_clicks)) {
//                 $data->count_clicks = $params->count_clicks;
//             }

            // load specific images fields
            // {"image_first":"","float_first":"","image_first_alt":"","image_first_caption":"","image_second":"","float_second":"","image_second_alt":"","image_second_caption":""}

//             $images = json_decode($data->images);
            $data->images = new Registry($data->images);

//             $data->images['image_first'] = '';
//             if (isset($images->image_first)) {
//                 $data->images['image_first'] = $images->image_first;
//             }

//             $data->image_first_alt = '';
//             if (isset($images->image_first_alt)) {
//                 $data->image_first_alt = $images->image_first_alt;
//             }

//             $data->image_first_caption = '';
//             if (isset($images->image_first_caption)) {
//                 $data->image_first_caption = $images->image_first_caption;
//             }

//             $data->image_second = '';
//             if (isset($images->image_second)) {
//                 $data->image_second = $images->image_second;
//             }

//             $data->image_second_alt = '';
//             if (isset($images->image_second_alt)) {
//                 $data->image_second_alt = $images->image_second_alt;
//             }

//             $data->image_second_caption = '';
//             if (isset($images->image_second_caption)) {
//                 $data->image_second_caption = $images->image_second_caption;
//             }

            $data->metadata = new Registry($data->metadata);
        }

        return $data;
    }

    /**
     * Method to save the form data.
     *
     * @param   array $data The form data
     *
     * @return bool
     *
     * @throws \Exception
     * @since 1.6
     */
    public function save($data)
    {
        $app = Factory::getApplication();
        $id = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('weblink.id');
        $user = Factory::getUser();
        $isNew = true;

        if ($id) {
            $isNew = false;

            // Check the user can edit this item
            $authorised = ($user->authorise('core.edit', 'com_weblinklogospro') || $user->authorise('core.edit.own', 'com_weblinklogospro'));
        } else {
            // Check the user can create new items in this section
            $authorised = $user->authorise('core.create', 'com_weblinklogospro');
        }

        if ($authorised !== true) {
            throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403); // returns 'You are not authorised to view this resource'
        }

        $config = ComponentHelper::getParams('com_weblinklogospro');

        // upload images

        $images = array('image_first', 'image_second');

        $files = $app->input->files->get('jform');

        foreach ($images as $image) {

            if (isset($files['images'][$image . '_file']['name']) && $files['images'][$image . '_file']['name']) {

                $tempName = $files['images'][$image . '_file']['tmp_name'];
                $tempFullPath = $tempName; //ini_get('upload_tmp_dir').'/'.$tempName;

                $type = $files['images'][$image . '_file']['type'];
                $name = $files['images'][$image . '_file']['name'];
                $size = $files['images'][$image . '_file']['size'];
                $error = $files['images'][$image . '_file']['error'];

                if ($error != 0) {
                    $app->enqueueMessage(Text::sprintf('COM_WEBLINKLOGOSPRO_WARNING_COULDNOTUPLOADFILE', $name), 'warning');
                } else {

                    $allowed_type = array('image/gif', 'image/jpg', 'image/jpeg', 'image/png', 'image/webp', 'image/avif');

                    if (!in_array($type, $allowed_type)) {
                        $app->enqueueMessage(Text::sprintf('COM_WEBLINKLOGOSPRO_WARNING_WRONGFILETYPE', $name), 'warning');
                    } else {

                        $media_params = ComponentHelper::getParams('com_media');
                        $images_path = $media_params->get('image_path', 'images');

                        $upload_directory = trim($config->get('upload_directory', ''), "/ ");

                        if ($config->get('upload_directory_user', 0)) {
                            $upload_directory .= '/'.$user->username;
                        }

                        if (SYWCache::isFolderReady(JPATH_ROOT.'/'.$images_path, $upload_directory)) {
                            if (!empty($upload_directory)) {
                                $upload_directory .= '/';
                            }
                            File::upload($tempFullPath, JPATH_SITE.'/'.$images_path.'/'.$upload_directory.$name);
                            $data['images'][$image] = $images_path.'/'.$upload_directory.$name;
                        } else {
                            $app->enqueueMessage(Text::sprintf('COM_WEBLINKLOGOSPRO_WARNING_COULDNOTUPLOADFILE', $name), 'warning');
                        }
                    }
                }
            }
        }

//         foreach ($images as $image) {

//             if (isset($files['name']['images'][$image]) && $files['name']['images'][$image]) {

//                 $tempName = $files['tmp_name']['images'][$image];
//                 $tempFullPath = $tempName; //ini_get('upload_tmp_dir').'/'.$tempName;

//                 $type = $files['type']['images'][$image];
//                 $name = $files['name']['images'][$image];
//                 $size = $files['size']['images'][$image];
//                 $error = $files['error']['images'][$image];

//                 if ($error != 0) {
//                     $app->enqueueMessage(JText::sprintf('COM_WEBLINKLOGOSPRO_WARNING_COULDNOTUPLOADFILE', $name), 'warning');
//                 } else {

//                     $allowed_type = array('image/gif', 'image/jpg', 'image/jpeg', 'image/png');

//                     if (!in_array($type, $allowed_type)) {
//                         $app->enqueueMessage(JText::sprintf('COM_WEBLINKLOGOSPRO_WARNING_WRONGFILETYPE', $name), 'warning');
//                     } else {

//                         $media_params = JComponentHelper::getParams('com_media');
//                         $images_path = $media_params->get('image_path', 'images');

//                         $upload_directory = trim($config->get('upload_directory', ''), "/ ");

//                         if ($config->get('upload_directory_user', 0)) {
//                             $upload_directory .= '/'.$user->username;
//                         }

//                         jimport('syw.cache', JPATH_LIBRARIES);
//                         if (SYWCache::isFolderReady(JPATH_ROOT.'/'.$images_path, $upload_directory)) {
//                             if (!empty($upload_directory)) {
//                                 $upload_directory .= '/';
//                             }
//                             \JFile::upload($tempFullPath, JPATH_SITE.'/'.$images_path.'/'.$upload_directory.$name);
//                             $data['images'][$image] = $images_path.'/'.$upload_directory.$name;
//                         } else {
//                             $app->enqueueMessage(JText::sprintf('COM_WEBLINKLOGOSPRO_WARNING_COULDNOTUPLOADFILE', $name), 'warning');
//                         }
//                     }
//                 }
//             } else {
//                 $data['images'][$image] = $data[$image];
//             }
//         }

        // save values in images

//         $images_values = array(/*'image_first', */'float_first', 'image_first_alt', 'image_first_caption', /*'image_second', */'float_second', 'image_second_alt', 'image_second_caption');

//         foreach ($images_values as $images_value) {
//             if (isset($data[$images_value]) && $data[$images_value]) {
//                 $data['images'][$images_value] = $data[$images_value];
//             }
//         }

        // save values in params

//         $param_values = array('target', 'width', 'height', 'count_clicks');

//         foreach ($param_values as $param_value) {
//             if (isset($data[$param_value]) && $data[$param_value]) {
//                 $data['params'][$param_value] = $data[$param_value];
//             }
//         }

        // save values in metadata

        //$metadata_values = array('robots', 'right');
        // unnecessary for now

        $table = $this->getTable();

        // tags
        if ((!empty($data['tags']) && $data['tags'][0] != '')) {
            $table->newTags = $data['tags'];
        } else {
            if (!$isNew) {
                $helper_tags = new TagsHelper();
                $table->newTags = explode(',', $helper_tags->getTagIds($id, 'com_weblinks.weblink'));
            }
        }

        // Attempt to bind the data
        if (!$table->bind($data)) {
            $this->setError($table->getError());
            return false;
        }

        // Check the data.
        if (!$table->check()) {
            $this->setError($table->getError());

            return false;
        }

        // Trigger the before event (needs the data to be bond)
        $result = Factory::getApplication()->triggerEvent('onContentBeforeSave', array('com_weblinklogospro.weblink', &$table, $isNew, $data));

        if (in_array(false, $result, true) || !$table->save($data)) { // don't use store() or else alias won't be created on new weblink - why ? - problem: bind is done twice now
            $this->setError($table->getError());
            return false;
        }

        // Attempt to check the row in, just in case it was checked out
        // use in conjunction with store()
        //if (!$table->checkin()) {
            //$this->setError($table->getError());
            //return false;
        //}

        // save custom fields (needs an id)

        if (Folder::exists(JPATH_ADMINISTRATOR . '/components/com_fields') && ComponentHelper::isEnabled('com_fields') && ComponentHelper::getParams('com_weblinks')->get('custom_fields_enable', '1')) {

            $fieldsObjects = FieldsHelper::getFields('com_weblinks.weblink');

            BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_fields/models', 'FieldsModel');
            $model = BaseDatabaseModel::getInstance('Field', 'FieldsModel', array('ignore_request' => true));

            foreach ($fieldsObjects as $field) {
                if (isset($data['customfields'][$field->name])) {
                    if ($field->type == 'subform') { // subform custom fields are stored as json strings
                        $model->setFieldValue($field->id, $table->id, json_encode($data['customfields'][$field->name]));
                    } else {
                        $model->setFieldValue($field->id, $table->id, $data['customfields'][$field->name]);
                    }
                }
            }
        }

        // Trigger the after save event
        Factory::getApplication()->triggerEvent('onContentAfterSave', array('com_weblinklogospro.weblink', &$table, $isNew));

        $this->setState('weblink.id', $table->id);
        Factory::getApplication()->setUserState('com_weblinklogospro.edit.weblink.id', $table->id);

        return $table->id;
    }

    /**
     * Method to delete data
     *
     * @param   int $pk Item primary key
     *
     * @return  int  The id of the deleted item
     *
     * @throws \Exception
     *
     * @since 1.6
     */
    public function delete($pk)
    {
        $user = Factory::getUser();

        if (empty($pk)) {
            $pk = (int) $this->getState('weblink.id');
        }

        if ($pk == 0 || $this->getItem($pk) == null) {
            throw new \Exception(Text::_('COM_WEBLINKLOGOSPRO_WEBLINK_DOESNT_EXIST'), 404);
        }

        if ($user->authorise('core.delete', 'com_weblinklogospro') !== true) {
            throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        $table = $this->getTable();

        if ($table->delete($pk) !== true) {
            throw new \Exception(Text::_('JERROR_FAILED'), 501);
        }

        return $pk;

    }

    /**
     * Check if data can be saved
     *
     * @return bool
     */
    public function getCanSave()
    {
        $table = $this->getTable();

        return $table !== false;
    }

}
