 /**
 * @package   securitycheckpro
 * @copyright Copyright (c) 2011 - Jose A. Luque / Securitycheck Extensions
 * @license   GNU General Public License version 3, or later
 */
"use strict";

	var active_task = Joomla.getOptions("securitycheckpro.Malwarescan.activetaskText");
	var task_failure = Joomla.getOptions("securitycheckpro.Malwarescan.taskfailureText");
	var repair_log_view_header = Joomla.getOptions("securitycheckpro.Malwarescan.repairviewlogheader");
	var process_completed = Joomla.getOptions("securitycheckpro.Malwarescan.processcompletedText");
	var cont = 0;
    var etiqueta = '';
    var url = '';
    var percent = 0;
    var ended_string2 = Joomla.getOptions("securitycheckpro.Malwarescan.end");
    var in_progress_string = Joomla.getOptions("securitycheckpro.Malwarescan.inprogress");
    var error_string = Joomla.getOptions("securitycheckpro.Malwarescan.error");
	var updating_stats = Joomla.getOptions("securitycheckpro.Malwarescan.updatingstats");
    var now = '';
    var url_to_redirect = Joomla.getOptions("securitycheckpro.Malwarescan.urltoredirect");
	var failure = Joomla.getOptions("securitycheckpro.Malwarescan.failureText");
	var error_button = Joomla.getOptions("securitycheckpro.Malwarescan.errorbutton");
	var message = Joomla.getOptions("securitycheckpro.Malwarescan.warningText");
	var contenido = Joomla.getOptions("securitycheckpro.Malwarescan.contenido");

    function get_percent() {
        url = 'index.php?option=com_securitycheckpro&controller=filemanager&format=raw&task=get_percent_malwarescan';
        jQuery.ajax({
            url: url,                            
            method: 'GET',
            success: function(responseText){                    
                if ( responseText < 100 ) {
                    document.getElementById('task_status').innerHTML = in_progress_string;
                    document.getElementById('warning_message2').innerHTML = '';
                    document.getElementById('error_message').className = 'alert alert-info';
                    document.getElementById('error_message').innerHTML = active_task;                    
                    hideElement('button_start_scan');
                    cont = 3;                    
                    runButton();
                }                    
            }
        });
    }
    
    function estado_malwarescan_timediff() {        
        url = 'index.php?option=com_securitycheckpro&controller=filemanager&format=raw&task=getEstadoMalwarescan_Timediff';
        jQuery.ajax({
            url: url,                            
            method: 'GET',
            dataType: 'json',
            success: function(response){                
                var json = Object.keys(response).map(function(k) {return response[k] });
                var estado_integrity = json[0];
                var timediff = json[1];
                                            
                if ( ((estado_integrity != 'ENDED') && (estado_integrity != error_string)) && (timediff < 3) ) {
                    get_percent();
                } else if ( ((estado_integrity != 'ENDED') && (estado_integrity != error_string)) && (timediff > 3) ) {                    
                    hideElement('button_start_scan');
                    hideElement('task_status');
                    document.getElementById('task_error').style.display = "block";                    
                    document.getElementById('error_message').className = 'alert alert-danger';
                    document.getElementById('error_message').innerHTML = task_failure;            
                }                        
            },
            error: function(xhr, status) {                
            }
        });
    }
        
    Joomla.submitbutton = function(task)
    {
        if (task == 'delete') {
            if (confirm(message)== true) {
                Joomla.submitform(task);
            }
            else {
                return false;
            }
        } else {        
            Joomla.submitform(task);
        }
    }
    
    jQuery(document).ready(function() {    
        jQuery("#more_info_deep_scan").tooltip();
		jQuery("#more_info_submission_type").tooltip();
		jQuery("#more_info_timeline").tooltip();
        
        jQuery( "#start_scan_button" ).click(function() {
            hideElement('button_start_scan'); 
            hideElement('container_resultado'); 
            hideElement('container_repair');
            hideElement('completed_message2'); 
            runButton();
        });
        
        jQuery( "#view_modal_log_button" ).click(function() {
            view_modal_log();
        });
        
        jQuery( "#search_filter_button" ).click(function() {
            document.getElementById('filter_malwarescan_search').value=''; this.form.submit();
        });
        
        jQuery( "#addfile_exception_button" ).click(function() {
            Joomla.submitbutton('addfile_exception');
        });
        
        jQuery( "#online_check_files_button" ).click(function() {
            Joomla.submitbutton('online_check_files');
        });
        
        jQuery( "#online_check_hashes_button" ).click(function() {
            Joomla.submitbutton('online_check_hashes');
        });
        
        jQuery( "#deletefile_exception_button" ).click(function() {
            Joomla.submitbutton('deletefile_exception');
        });
        
        jQuery( "#restore_quarantined_file_button" ).click(function() {
            Joomla.submitbutton('restore_quarantined_file');
        });
        
        jQuery( "#delete_quarantined_file_button" ).click(function() {
            Joomla.submitbutton('delete_quarantined_file');
        });
        
        hideElement('backup-progress');
        estado_malwarescan_timediff();
                
        // Chequeamos cuando se pulsa el botón 'close' del modal 'initialize data' para actualizar la página
        $(function() {
            $("#buttonclose").click(function() {
                setTimeout(function () {window.location.reload()},1000);                
            });
        });        
        
        // Cambiamos el estado de los botones cuando se mandan contra metascan
        $(".btn").on('click', function () {
          var dataLoadingText = $(this).attr("data-loading-text");
          if (typeof dataLoadingText !== typeof undefined && dataLoadingText !== false) {            
            $(this).text(dataLoadingText).addClass("disabled");
          }
        });          
        
    });    
        
    function date_time(id) {
        url = 'index.php?option=com_securitycheckpro&controller=filemanager&format=raw&task=currentDateTime';
		jQuery.ajax({
			url: url,                            
			method: 'GET',
			success: function(responseText){	
				document.getElementById(id).innerHTML = responseText;
			},
			error: function(responseText) { 
				
			}
		});	        
    }
    
    function runButton() {
        if ( cont == 0 ){
            document.getElementById('bar').style.width = "0%";
            document.getElementById('backup-progress').style.display = "flex";
            document.getElementById('warning_message2').innerHTML = '';            
            date_time('start_time');                                
            percent = 0;
        } else if ( cont == 1 ){            
            document.getElementById('task_status').innerHTML = in_progress_string;
            url = 'index.php?option=com_securitycheckpro&controller=filemanager&format=raw&task=acciones_malwarescan';
            jQuery.ajax({
                url: url,                            
                method: 'GET',
                success: function(responseText){                                                    
                }
            });                            
        } else {
            url = 'index.php?option=com_securitycheckpro&controller=filemanager&format=raw&task=get_percent_malwarescan';
            jQuery.ajax({
                url: url,                            
                method: 'GET',
                success: function(responseText){
                    percent = responseText;   					
                    document.getElementById('bar').style.width = percent + "%";					
                    if (percent == 100) {                        
                        date_time('end_time');
                        hideElement('error_message');
                        document.getElementById('task_status').innerHTML = ended_string2;
                        document.getElementById('bar').style.width = 100 + "%";
                        document.getElementById('completed_message2').innerHTML = process_completed;
                        document.getElementById('warning_message2').innerHTML = updating_stats;                                               
                        //setTimeout(function () {window.location.reload()},2000);                                  
                        window.location.href = url_to_redirect;
                    }
                },
                error: function(responseText) {
                    document.getElementById('task_error').style.display = "block";
                    hideElement('backup-progress');
                    hideElement('task_status');    
                    document.getElementById('warning_message2').innerHTML = '';
                    document.getElementById('error_message').className = 'alert alert-danger';
                    document.getElementById('error_message').innerHTML = failure;
                    document.getElementById('error_button').innerHTML = error_button;
                }
            });
        }
                        
        cont = cont + 1;
        
        if ( percent == 100) {
        
        } else if  ( (cont > 40) && (percent < 90) ) {
            var t = setTimeout(runButton,75000);
        } else {                                
            var t = setTimeout(runButton,1000);
        }
                                                    
    }    
