<?php
/**
 * ------------------------------------------------------------------------
 * Helper - Logo Slider  Module
 * ------------------------------------------------------------------------
 * Copyright (C) 2014-2016 LogicHunt, All Rights Reserved.
 * license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: LogicHunt
 * Websites:  http://logichunt.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

class LgxLogoSliderHelper
{


    /**
     * Source Data
     *
     * @param $source
     * @param $native_field
     * @param $custom_field
     *
     * @return array
     */

    public static function LgxLogoSliderSource($source, $native_field, $custom_field)
    {

        $output = array();

        if(isset($native_field) || isset($custom_field)) {
            $data_source = array();

            if ($source == 'joomla' && isset($native_field)) {
                $data_source = $native_field;
            } elseif(isset($custom_field)) {
                $data_source = $custom_field;
            }

            foreach ($data_source as $key => $logo_content):
                $output[] = array(
                    'active'  => $logo_content->active,
                    'thumb'   => $logo_content->thumb,
                    'title'   => $logo_content->title,
                    'tooltip' => (!empty($logo_content->tooltip) ? $logo_content->tooltip : ''),
                    'url'     => $logo_content->url,
                );
            endforeach;
        }

        return $output;
    }


// update by Vaskar Roy : 01.10.2020
   public static function lgx_logo_hex2rgba($color, $opacity)
    {

        if ($color == '#rrggbb') {
            return;
        }
        
        list($r, $g, $b) = sscanf($color, "#%02x%02x%02x");

        //Check if opacity is set(rgba or rgb)
        if (isset($opacity)) {
            if (abs($opacity) > 1) {
                $opacity = 1.0;
            }

            $output = 'rgba('. $r . ','. $g .','. $b.','. $opacity . ')';
        } else {
            $output = 'rgb('. $r . ','. $g .','. $b.')';
        }

        //Return rgb(a) color string


        return $output;

    }



// update by Vaskar Roy : 07.17.2019


    public static function nav_text_imgUpdated($nav_tape, $navTextLeft, $navTextRight, $navimgLeft, $navimgRight)
    {

        $imgStore = array();

        if ($nav_tape == 'img') {

            if (!isset($navimgLeft) || $navimgLeft == '') {
                $navimgLeft = 'modules/mod_lgx_logoslider/assets/img/prev-m.png';
            }

            if (!isset($navimgRight) || $navimgRight == '') {
                $navimgRight =  'modules/mod_lgx_logoslider/assets/img/next-m.png';
            }

            $imgStore[] = '<img src="' . JURI::root() . $navimgLeft . '" alt="Left Navigation" />';
            $imgStore[] = '<img src="' . JURI::root()  . $navimgRight . '" alt="Right  " />';

        } else {

            $imgStore[] = $navTextLeft;
            $imgStore[] = $navTextRight;
        }
        return  htmlspecialchars( json_encode( $imgStore, JSON_FORCE_OBJECT ) );
    }


    public static function lgx_logo_btngroup($option)
    {

        if ($option == 1) {
            $value = 'true';
        } elseif ($option == 0) {
            $value = 'false';
        }

        return $value;

    }


    public static function lgx_TP_Slide_type($tp_side)
    {

        if ($tp_side == 'bottom') {
            return '["bottom", "top", "right", "left"]';
        } elseif ($tp_side == 'right') {
            return '["right", "left", "top", "bottom"]';

        } elseif ($tp_side == 'left') {
            return '["left", "right", "top", "bottom"]';
        } else {
            return '["top", "bottom", "right", "left"]';
        }
    }

    public static function LgxLogoRandomize($items)
    {
        $shuffleKeys = array_keys($items);
        shuffle($shuffleKeys);
        $newArray = array();
        foreach ($shuffleKeys as $key) {
            $newArray[$key] = $items[$key];
        }
        return $newArray;
    }


}