<?php
/**
 * ------------------------------------------------------------------------
 * Simple Layout - Logo Slider  Module
 * ------------------------------------------------------------------------
 * Copyright (C) 2014-2018 LogicHunt, All Rights Reserved.
 * license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: LogicHunt
 * Websites:  http://logichunt.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
?>

<?php
$app = JFactory::getApplication();
$doc = JFactory::getDocument();
$mod_id = $module->id;
$jebase = JURI::base();

if(substr($jebase, -1)=="/") {
    $jebase = substr($jebase, 0, -1);
}
$basepath = JUri::root(true).'/modules/' . $module->module . '/assets/';

/**********************************************************************
 * StyleSheet Declaration
 **********************************************************************/

if($tooltip_en) {
    $doc->addStyleSheet($basepath.'lib/tooltipster/css/tooltipster.bundle.css');
}

// Load Main StyleSheet
$style_name = 'style.css';
$doc->addStyleSheet($basepath.'css/'.$style_name);

//Load Override StyleSheet
$templatestyle = 'templates/'.$app->getTemplate().'/css/'.$module->module.'.css';

if(file_exists(JPATH_SITE . '/' . $templatestyle)) {
    $doc->addStyleSheet(JURI::root(true).'/'.$templatestyle);
}


/**********************************************************************
 *  Script
 **********************************************************************/


JHtml::_('jquery.framework');

if($load_jquery) {
    $doc->addScript('https://code.jquery.com/jquery-1.12.4.min.js');
}



if($tooltip_en) {
    $doc->addScript($basepath.'lib/tooltipster/js/tooltipster.bundle.min.js');
}



/**********************************************************************
 * Dynamic Style
 **********************************************************************/

$tp_border_width=2;
$owl_controls_top_margin =0;


// Add styles
$style = '#mod-lgx-logoslider'.$mod_id.' {'
    .'margin: '.$section_margin_top.'px 0 '.$section_margin_bottom.'px ;'
    .'width: 100%;'
    .'}'
    .'#mod-lgx-logoslider'.$mod_id.' .lgx-logoslider-inner{'
    .(($bg_color_en) ? 'background-color: '.$inner_op_bg.';' : '')
    .'padding: '.$section_padding_top.'px 0 '.$section_padding_bottom.'px;'
    .'color: '.$inner_color.';'
    .'}'
    .'#mod-lgx-logoslider'.$mod_id.' .logo-company-name .lgx-logo-title {'
    .'font-size: '.$company_font_size.'px;'
    .'color: '.$company_color.';'
    .'}'

    .'#mod-lgx-logoslider'.$mod_id.' .lgx-logo-header .lgx-logo-header-title{
        font-size: '.$header_title_font_size.'px; color: '.$header_title_font_color.'; margin-bottom: '.$header_title_margin_bottom.'px; font-weight:'.$header_title_font_weight.';
    }'
    .'#mod-lgx-logoslider'.$mod_id.' .lgx-logo-header .lgx-logo-header-subtitle{
      font-size: '.$header_subtitle_font_size.'px; color: '.$header_subtitle_font_color.'; margin-bottom: '.$header_subtitle_margin_bottom.'px; font-weight:'.$header_subtitle_font_weight.';
    }'

    .'#mod-lgx-logoslider'.$mod_id.'.lgx-logo-nav-vertical  .lgx-logoslider{
        padding-left: '.$v_nav_padding_left.'px;
         padding-right: '.$v_nav_padding_right.'px;
    }
    '.'#mod-lgx-logoslider'.$mod_id.' .lgx-logo-img {'
    .(($img_border_en) ? 'border: '.$img_border_width.'px solid '.$img_border_color.';' : '')
    .(($img_bg_en) ? 'background-color: '.$img_bg_color.';' : '')
    .'padding:'.$img_padding.'px;'
    .'}'
    .'#mod-lgx-logoslider'.$mod_id.' :hover .lgx-logo-img {'
    .(($img_border_en) ? 'border: '.$img_border_width.'px solid '.$img_border_color_hover.';' : '')
    .(($img_bg_en) ? 'background-color: '.$img_bg_color_hover.';' : '')
    .'}'
    .'#mod-lgx-logoslider'.$mod_id.' .lgx-logo-img .lgx-logo{'
    .'max-width:'.$logo_max_width.'px;'
    .'max-height:'.$logo_max_height.'px;'
    .'}'
    .'#mod-lgx-logoslider'.$mod_id.' .lgx-logoslider-inner {'
    .'max-width: '.$content_width.';'
    .'margin:0 auto;'
    .'}';


$tooltip_style = '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.lgxlogoslider'.$mod_id.'-noir-customized .tooltipster-box {'
    .'background: '.$tp_bg_color.';'
    .'border: '.$tp_border_width.'px solid '.$tp_border_color.';'
    .'border-radius: '.$tp_border_radius.'px;'
    .(($tp_shadow_en) ? 'box-shadow: 5px 5px 2px 0 rgba(0,0,0,0.4);' : 'box-shadow:none;')
    .'}'
    .'.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.lgxlogoslider'.$mod_id.'-noir-customized .tooltipster-content {'
    .'color: '.$tp_text_color.';'
    .'padding: '.$tp_padding.'px;'
    .'}'
    . '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-bottom .tooltipster-arrow-border {'
    .'border-bottom-color: '.$tp_arrow_border_color.';'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-right .tooltipster-arrow-border {'
    .'border-right-color: '.$tp_arrow_border_color.';'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-left .tooltipster-arrow-border {'
    .'border-left-color: '.$tp_arrow_border_color.';'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-top .tooltipster-arrow-border {'
    .'border-top-color: '.$tp_arrow_border_color.';'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-bottom .tooltipster-arrow-background {'
    .'border-bottom-color: '.$tp_arrow_bg.';left: 0px; top: 3px;'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-right .tooltipster-arrow-background  {'
    .'border-left-color: '.$tp_arrow_bg.';left: -3px;top: 0px;'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-left .tooltipster-arrow-background  {'
    .' border-right-color:'.$tp_arrow_bg.';left: 3px;top: 0px;'
    .'}'.
    '.tooltipster-sidetip.lgxlogoslider'.$mod_id.'-noir.tooltipster-top .tooltipster-arrow-background  {'
    .'border-top-color: '.$tp_arrow_bg.';left: 0px; top: -3px;'
    .'}'
;


$bg_style = '#mod-lgx-logoslider'.$mod_id.' {'
    . 'background: url('.$jebase.'/'. $bg_img .') no-repeat center top;'
    . 'background-attachment: '.$bg_attachment.';'
    . 'background-size:'.$bg_size.';'
    . '}';


$doc->addStyleDeclaration($style);

//if($tooltip_en) {
$doc->addStyleDeclaration($tooltip_style);
//}

if($bg_img_en && !empty($bg_img)){
    $doc->addStyleDeclaration($bg_style);
}



if( !empty($custom_style)) {

    $doc->addStyleDeclaration($custom_style);
}



/**********************************************************************
 *  Output
 **********************************************************************/



$single_item = '';
$tooltip_text = '';


foreach ($items as $item) {

    if ($item["active"] && (!empty($item["thumb"]))) {

        $company_img    = $item["thumb"];
        $company_name   = $item["title"];
        $company_url    = $item["url"];

        if($company_tooltip_en == 'company') {
            $tooltip_text  = $company_name;
        } else {
            $tooltip_text  = $item["tooltip"];
        }


        //  $tooltip_text = $company_name;

        // Single  Item
        $single_item .= '<div class="lgx-logo-item-simple">';
        $single_item .= '<div class="lgx-logo-img logohover-'.$hover_style.' ">';
        $single_item .= (($url_en) ? '<a href="'.$company_url.'" target="'.$target_type.'">' : '');
        $single_item .= '<img class="lgx-logo lgx-logo-tooltip'.$mod_id.'" src="'.$company_img.'" alt="Logo-'.$company_name.'" '.((!empty($tooltip_text) ? ' title="'.$tooltip_text.'"' : '')).' />';
        $single_item .= (($url_en) ? '</a>' : '');
        $single_item .= ( (!empty($company_name) && $compnayanme_en) ? '<div class="logo-company-name"><h4 class="lgx-logo-title">'.$company_name.'</h4></div>': '');;
        $single_item .= '</div>';
        $single_item .= '</div>';
    }
}




?>

<div id="mod-lgx-logoslider<?php echo $mod_id; ?>" class="mod-lgx-logoslider mod-lgx-logoslider-simple  lgx-mod-logo<?php echo $moduleclass_sfx; ?>" >
    <div class="lgx-logoslider-inner <?php echo(($nav_hover)? 'lgx-nav-hover':'') ; ?> <?php echo(($dot_hover)? 'lgx-dot-hover':'') ; ?> ">
        <?php if($header_en): ?>
            <div class="lgx-logo-header">
                <?php if(!empty($header_title)): ?>
                    <h2 class="lgx-logo-header-title"><?php echo $header_title; ?></h2>
                <?php endif; ?>
                <?php if(!empty($header_subtitle)): ?>
                    <p class="lgx-logo-header-subtitle"><?php echo $header_subtitle; ?></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div id="lgx-logoslider<?php echo $mod_id;?>" class="lgx-logoslider lgx-logoslider-simple">
            <?php echo $single_item; ?>
        </div>
    </div>
</div>

<script type="text/javascript">

    jQuery(document).ready(function ($) {

        <?php   if($tooltip_en): ?>
        $('.lgx-logo-tooltip<?php echo $mod_id; ?>').tooltipster({
            animation: '<?php echo $tp_animation; ?>', //'fade',  'grow', 'swing', 'slide','fall'//Default: 'fade'
            animationDuration: <?php echo $tp_animationduration; ?>, //number: 350
            delay: <?php echo $tp_delay; ?>,//integer,Default: 300
            arrow:<?php echo $tp_arrow; ?>,//true
            theme: ['lgxlogoslider<?php echo $mod_id; ?>-noir', 'lgxlogoslider<?php echo $mod_id; ?>-noir-customized'],
            trigger: '<?php echo $tp_trigger; ?>', // click
            distance: <?php echo $tp_distance; ?>,
            minIntersection: <?php echo $tp_minintersection; ?>,
            minWidth: <?php echo $tp_minwidth; ?>,
            timer:<?php echo $tp_timer; ?>,
            side: <?php echo $tp_side_arr; ?> //['bottom', 'top', 'right', 'left'], ['right', 'left', 'top', 'bottom'], ['left', 'right', 'top', 'bottom']
        });
        <?php endif; ?>

    });

</script>



